/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.request;

import com.lzy.okgo.model.HttpParams;
import com.lzy.okgo.request.BaseRequest;
import com.lzy.okgo.request.HasBody;
import com.lzy.okgo.utils.HttpUtils;
import java.io.File;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseBodyRequest<R extends BaseBodyRequest>
extends BaseRequest<R>
implements HasBody<R> {
    protected MediaType mediaType;
    protected String content;
    protected byte[] bs;
    protected boolean isMultipart = false;
    protected RequestBody requestBody;

    public BaseBodyRequest(String url) {
        super(url);
    }

    @Override
    public R isMultipart(boolean isMultipart) {
        this.isMultipart = isMultipart;
        return (R)this;
    }

    @Override
    public R requestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
        return (R)this;
    }

    @Override
    public R params(String key, File file) {
        this.params.put(key, file);
        return (R)this;
    }

    @Override
    public R addFileParams(String key, List<File> files) {
        this.params.putFileParams(key, files);
        return (R)this;
    }

    @Override
    public R addFileWrapperParams(String key, List<HttpParams.FileWrapper> fileWrappers) {
        this.params.putFileWrapperParams(key, fileWrappers);
        return (R)this;
    }

    @Override
    public R params(String key, File file, String fileName) {
        this.params.put(key, file, fileName);
        return (R)this;
    }

    @Override
    public R params(String key, File file, String fileName, MediaType contentType) {
        this.params.put(key, file, fileName, contentType);
        return (R)this;
    }

    @Override
    public R upString(String string) {
        this.content = string;
        this.mediaType = HttpParams.MEDIA_TYPE_PLAIN;
        return (R)this;
    }

    public R upString(String string, MediaType mediaType) {
        this.content = string;
        this.mediaType = mediaType;
        return (R)this;
    }

    @Override
    public R upJson(String json) {
        this.content = json;
        this.mediaType = HttpParams.MEDIA_TYPE_JSON;
        return (R)this;
    }

    @Override
    public R upJson(JSONObject jsonObject) {
        this.content = jsonObject.toString();
        this.mediaType = HttpParams.MEDIA_TYPE_JSON;
        return (R)this;
    }

    @Override
    public R upJson(JSONArray jsonArray) {
        this.content = jsonArray.toString();
        this.mediaType = HttpParams.MEDIA_TYPE_JSON;
        return (R)this;
    }

    @Override
    public R upBytes(byte[] bs) {
        this.bs = bs;
        this.mediaType = HttpParams.MEDIA_TYPE_STREAM;
        return (R)this;
    }

    @Override
    public RequestBody generateRequestBody() {
        if (this.requestBody != null) {
            return this.requestBody;
        }
        if (this.content != null && this.mediaType != null) {
            return RequestBody.create((MediaType)this.mediaType, (String)this.content);
        }
        if (this.bs != null && this.mediaType != null) {
            return RequestBody.create((MediaType)this.mediaType, (byte[])this.bs);
        }
        return HttpUtils.generateMultipartRequestBody(this.params, this.isMultipart);
    }
}

