/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.model;

import android.os.Build;
import android.text.TextUtils;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.utils.OkLogger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpHeaders
implements Serializable {
    private static final long serialVersionUID = 8458647755751403873L;
    public static final String FORMAT_HTTP_DATA = "EEE, dd MMM y HH:mm:ss 'GMT'";
    public static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final String HEAD_KEY_RESPONSE_CODE = "ResponseCode";
    public static final String HEAD_KEY_RESPONSE_MESSAGE = "ResponseMessage";
    public static final String HEAD_KEY_ACCEPT = "Accept";
    public static final String HEAD_KEY_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEAD_VALUE_ACCEPT_ENCODING = "gzip, deflate";
    public static final String HEAD_KEY_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEAD_KEY_CONTENT_TYPE = "Content-Type";
    public static final String HEAD_KEY_CONTENT_LENGTH = "Content-Length";
    public static final String HEAD_KEY_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEAD_KEY_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEAD_KEY_CONTENT_RANGE = "Content-Range";
    public static final String HEAD_KEY_CACHE_CONTROL = "Cache-Control";
    public static final String HEAD_KEY_CONNECTION = "Connection";
    public static final String HEAD_VALUE_CONNECTION_KEEP_ALIVE = "keep-alive";
    public static final String HEAD_VALUE_CONNECTION_CLOSE = "close";
    public static final String HEAD_KEY_DATE = "Date";
    public static final String HEAD_KEY_EXPIRES = "Expires";
    public static final String HEAD_KEY_E_TAG = "ETag";
    public static final String HEAD_KEY_PRAGMA = "Pragma";
    public static final String HEAD_KEY_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEAD_KEY_IF_NONE_MATCH = "If-None-Match";
    public static final String HEAD_KEY_LAST_MODIFIED = "Last-Modified";
    public static final String HEAD_KEY_LOCATION = "Location";
    public static final String HEAD_KEY_USER_AGENT = "User-Agent";
    public static final String HEAD_KEY_COOKIE = "Cookie";
    public static final String HEAD_KEY_COOKIE2 = "Cookie2";
    public static final String HEAD_KEY_SET_COOKIE = "Set-Cookie";
    public static final String HEAD_KEY_SET_COOKIE2 = "Set-Cookie2";
    public LinkedHashMap<String, String> headersMap;
    private static String acceptLanguage;
    private static String userAgent;

    private void init() {
        this.headersMap = new LinkedHashMap();
    }

    public HttpHeaders() {
        this.init();
    }

    public HttpHeaders(String key, String value) {
        this.init();
        this.put(key, value);
    }

    public void put(String key, String value) {
        if (key != null && value != null) {
            this.headersMap.put(key, value);
        }
    }

    public void put(HttpHeaders headers) {
        if (headers != null && headers.headersMap != null && !headers.headersMap.isEmpty()) {
            this.headersMap.putAll(headers.headersMap);
        }
    }

    public String get(String key) {
        return this.headersMap.get(key);
    }

    public String remove(String key) {
        return (String)this.headersMap.remove(key);
    }

    public void clear() {
        this.headersMap.clear();
    }

    public Set<String> getNames() {
        return this.headersMap.keySet();
    }

    public final String toJSONString() {
        JSONObject jsonObject = new JSONObject();
        try {
            for (Map.Entry<String, String> entry : this.headersMap.entrySet()) {
                jsonObject.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (JSONException e) {
            OkLogger.e(e);
        }
        return jsonObject.toString();
    }

    public static long getDate(String gmtTime) {
        try {
            return HttpHeaders.parseGMTToMillis(gmtTime);
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public static String getDate(long milliseconds) {
        return HttpHeaders.formatMillisToGMT(milliseconds);
    }

    public static long getExpiration(String expiresTime) {
        try {
            return HttpHeaders.parseGMTToMillis(expiresTime);
        }
        catch (ParseException e) {
            return -1L;
        }
    }

    public static long getLastModified(String lastModified) {
        try {
            return HttpHeaders.parseGMTToMillis(lastModified);
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public static String getCacheControl(String cacheControl, String pragma) {
        if (cacheControl != null) {
            return cacheControl;
        }
        if (pragma != null) {
            return pragma;
        }
        return null;
    }

    public static void setAcceptLanguage(String language) {
        acceptLanguage = language;
    }

    public static String getAcceptLanguage() {
        if (TextUtils.isEmpty((CharSequence)acceptLanguage)) {
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            StringBuilder acceptLanguageBuilder = new StringBuilder(language);
            if (!TextUtils.isEmpty((CharSequence)country)) {
                acceptLanguageBuilder.append('-').append(country).append(',').append(language).append(";q=0.8");
            }
            acceptLanguage = acceptLanguageBuilder.toString();
            return acceptLanguage;
        }
        return acceptLanguage;
    }

    public static void setUserAgent(String agent) {
        userAgent = agent;
    }

    public static String getUserAgent() {
        if (TextUtils.isEmpty((CharSequence)userAgent)) {
            String id;
            String model;
            String webUserAgent = null;
            try {
                Class<?> sysResCls = Class.forName("com.android.internal.R$string");
                Field webUserAgentField = sysResCls.getDeclaredField("web_user_agent");
                Integer resId = (Integer)webUserAgentField.get(null);
                webUserAgent = OkGo.getContext().getString(resId.intValue());
            }
            catch (Exception sysResCls) {
                // empty catch block
            }
            if (TextUtils.isEmpty(webUserAgent)) {
                webUserAgent = "Mozilla/5.0 (Linux; U; Android %s) AppleWebKit/533.1 (KHTML, like Gecko) Version/5.0 %sSafari/533.1";
            }
            Locale locale = Locale.getDefault();
            StringBuffer buffer = new StringBuffer();
            String version = Build.VERSION.RELEASE;
            if (version.length() > 0) {
                buffer.append(version);
            } else {
                buffer.append("1.0");
            }
            buffer.append("; ");
            String language = locale.getLanguage();
            if (language != null) {
                buffer.append(language.toLowerCase(locale));
                String country = locale.getCountry();
                if (!TextUtils.isEmpty((CharSequence)country)) {
                    buffer.append("-");
                    buffer.append(country.toLowerCase(locale));
                }
            } else {
                buffer.append("en");
            }
            if ("REL".equals(Build.VERSION.CODENAME) && (model = Build.MODEL).length() > 0) {
                buffer.append("; ");
                buffer.append(model);
            }
            if ((id = Build.ID).length() > 0) {
                buffer.append(" Build/");
                buffer.append(id);
            }
            userAgent = String.format(webUserAgent, buffer, "Mobile ");
            return userAgent;
        }
        return userAgent;
    }

    public static long parseGMTToMillis(String gmtTime) throws ParseException {
        if (TextUtils.isEmpty((CharSequence)gmtTime)) {
            return 0L;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_HTTP_DATA, Locale.US);
        formatter.setTimeZone(GMT_TIME_ZONE);
        Date date = formatter.parse(gmtTime);
        return date.getTime();
    }

    public static String formatMillisToGMT(long milliseconds) {
        Date date = new Date(milliseconds);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_HTTP_DATA, Locale.US);
        simpleDateFormat.setTimeZone(GMT_TIME_ZONE);
        return simpleDateFormat.format(date);
    }

    public String toString() {
        return "HttpHeaders{headersMap=" + this.headersMap + '}';
    }
}

