/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cookie.store;

import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.cookie.store.CookieStore;
import com.lzy.okgo.cookie.store.SerializableHttpCookie;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class PersistentCookieStore
implements CookieStore {
    private static final String LOG_TAG = "PersistentCookieStore";
    private static final String COOKIE_PREFS = "okgo_cookie";
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private final HashMap<String, ConcurrentHashMap<String, Cookie>> cookies;
    private final SharedPreferences cookiePrefs = OkGo.getContext().getSharedPreferences("okgo_cookie", 0);

    public PersistentCookieStore() {
        this.cookies = new HashMap();
        Map prefsMap = this.cookiePrefs.getAll();
        for (Map.Entry entry : prefsMap.entrySet()) {
            String[] cookieNames;
            if (entry.getValue() == null || ((String)entry.getKey()).startsWith(COOKIE_NAME_PREFIX)) continue;
            for (String name : cookieNames = TextUtils.split((String)((String)entry.getValue()), (String)",")) {
                Cookie decodedCookie;
                String encodedCookie = this.cookiePrefs.getString(COOKIE_NAME_PREFIX + name, null);
                if (encodedCookie == null || (decodedCookie = this.decodeCookie(encodedCookie)) == null) continue;
                if (!this.cookies.containsKey(entry.getKey())) {
                    this.cookies.put((String)entry.getKey(), new ConcurrentHashMap());
                }
                this.cookies.get(entry.getKey()).put(name, decodedCookie);
            }
        }
    }

    private String getCookieToken(Cookie cookie) {
        return cookie.name() + "@" + cookie.domain();
    }

    private static boolean isCookieExpired(Cookie cookie) {
        return cookie.expiresAt() < System.currentTimeMillis();
    }

    @Override
    public List<Cookie> loadCookie(HttpUrl url) {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        if (this.cookies.containsKey(url.host())) {
            Collection<Cookie> urlCookies = this.cookies.get(url.host()).values();
            for (Cookie cookie : urlCookies) {
                if (PersistentCookieStore.isCookieExpired(cookie)) {
                    this.removeCookie(url, cookie);
                    continue;
                }
                ret.add(cookie);
            }
        }
        return ret;
    }

    @Override
    public void saveCookie(HttpUrl url, List<Cookie> urlCookies) {
        if (!this.cookies.containsKey(url.host())) {
            this.cookies.put(url.host(), new ConcurrentHashMap());
        }
        for (Cookie cookie : urlCookies) {
            if (PersistentCookieStore.isCookieExpired(cookie)) {
                this.removeCookie(url, cookie);
                continue;
            }
            this.saveCookie(url, cookie, this.getCookieToken(cookie));
        }
    }

    @Override
    public void saveCookie(HttpUrl url, Cookie cookie) {
        if (!this.cookies.containsKey(url.host())) {
            this.cookies.put(url.host(), new ConcurrentHashMap());
        }
        if (PersistentCookieStore.isCookieExpired(cookie)) {
            this.removeCookie(url, cookie);
        } else {
            this.saveCookie(url, cookie, this.getCookieToken(cookie));
        }
    }

    private void saveCookie(HttpUrl url, Cookie cookie, String name) {
        this.cookies.get(url.host()).put(name, cookie);
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        prefsWriter.putString(url.host(), TextUtils.join((CharSequence)",", (Iterable)this.cookies.get(url.host()).keySet()));
        prefsWriter.putString(COOKIE_NAME_PREFIX + name, this.encodeCookie(new SerializableHttpCookie(cookie)));
        prefsWriter.apply();
    }

    @Override
    public boolean removeCookie(HttpUrl url, Cookie cookie) {
        String name = this.getCookieToken(cookie);
        if (this.cookies.containsKey(url.host()) && this.cookies.get(url.host()).containsKey(name)) {
            this.cookies.get(url.host()).remove(name);
            SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
            if (this.cookiePrefs.contains(COOKIE_NAME_PREFIX + name)) {
                prefsWriter.remove(COOKIE_NAME_PREFIX + name);
            }
            prefsWriter.putString(url.host(), TextUtils.join((CharSequence)",", (Iterable)this.cookies.get(url.host()).keySet()));
            prefsWriter.apply();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCookie(HttpUrl url) {
        if (this.cookies.containsKey(url.host())) {
            Set cookieNames = this.cookies.get(url.host()).keySet();
            SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
            for (String cookieName : cookieNames) {
                if (!this.cookiePrefs.contains(COOKIE_NAME_PREFIX + cookieName)) continue;
                prefsWriter.remove(COOKIE_NAME_PREFIX + cookieName);
            }
            prefsWriter.remove(url.host()).apply();
            this.cookies.remove(url.host());
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllCookie() {
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        prefsWriter.clear().apply();
        this.cookies.clear();
        return true;
    }

    @Override
    public List<Cookie> getAllCookie() {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        for (String key : this.cookies.keySet()) {
            ret.addAll(this.cookies.get(key).values());
        }
        return ret;
    }

    @Override
    public List<Cookie> getCookie(HttpUrl url) {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        Map mapCookie = this.cookies.get(url.host());
        if (mapCookie != null) {
            ret.addAll(mapCookie.values());
        }
        return ret;
    }

    private String encodeCookie(SerializableHttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(os);
            outputStream.writeObject(cookie);
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"IOException in encodeCookie", (Throwable)e);
            return null;
        }
        return this.byteArrayToHexString(os.toByteArray());
    }

    private Cookie decodeCookie(String cookieString) {
        byte[] bytes = this.hexStringToByteArray(cookieString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        Cookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            cookie = ((SerializableHttpCookie)objectInputStream.readObject()).getCookie();
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"IOException in decodeCookie", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Log.d((String)LOG_TAG, (String)"ClassNotFoundException in decodeCookie", (Throwable)e);
        }
        return cookie;
    }

    private String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int v = element & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    private byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

