/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.convert;

import android.os.Environment;
import android.text.TextUtils;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.callback.AbsCallback;
import com.lzy.okgo.convert.Converter;
import com.lzy.okgo.utils.HttpUtils;
import com.lzy.okgo.utils.OkLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;

public class FileConvert
implements Converter<File> {
    public static final String DM_TARGET_FOLDER = File.separator + "download" + File.separator;
    private String destFileDir;
    private String destFileName;
    private AbsCallback callback;

    public FileConvert() {
        this(null);
    }

    public FileConvert(String destFileName) {
        this(Environment.getExternalStorageDirectory() + DM_TARGET_FOLDER, destFileName);
    }

    public FileConvert(String destFileDir, String destFileName) {
        this.destFileDir = destFileDir;
        this.destFileName = destFileName;
    }

    public void setCallback(AbsCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File convertSuccess(Response value) throws Exception {
        File file;
        File dir;
        if (TextUtils.isEmpty((CharSequence)this.destFileDir)) {
            this.destFileDir = Environment.getExternalStorageDirectory() + DM_TARGET_FOLDER;
        }
        if (TextUtils.isEmpty((CharSequence)this.destFileName)) {
            this.destFileName = HttpUtils.getNetFileName(value, value.request().url().toString());
        }
        if (!(dir = new File(this.destFileDir)).exists()) {
            dir.mkdirs();
        }
        if ((file = new File(dir, this.destFileName)).exists()) {
            file.delete();
        }
        long lastRefreshUiTime = 0L;
        long lastWriteBytes = 0L;
        InputStream is = null;
        byte[] buf = new byte[2048];
        FileOutputStream fos = null;
        try {
            int len;
            is = value.body().byteStream();
            final long total = value.body().contentLength();
            long sum = 0L;
            fos = new FileOutputStream(file);
            while ((len = is.read(buf)) != -1) {
                sum += (long)len;
                fos.write(buf, 0, len);
                if (this.callback == null) continue;
                final long finalSum = sum;
                long curTime = System.currentTimeMillis();
                if (curTime - lastRefreshUiTime < (long)OkGo.REFRESH_TIME && finalSum != total) continue;
                long diffTime = (curTime - lastRefreshUiTime) / 1000L;
                if (diffTime == 0L) {
                    ++diffTime;
                }
                long diffBytes = finalSum - lastWriteBytes;
                final long networkSpeed = diffBytes / diffTime;
                OkGo.getInstance().getDelivery().post(new Runnable(){

                    @Override
                    public void run() {
                        FileConvert.this.callback.downloadProgress(finalSum, total, (float)finalSum * 1.0f / (float)total, networkSpeed);
                    }
                });
                lastRefreshUiTime = System.currentTimeMillis();
                lastWriteBytes = finalSum;
            }
            fos.flush();
            File file2 = file;
            return file2;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                OkLogger.e(e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                OkLogger.e(e);
            }
        }
    }
}

