/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cache;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.lzy.okgo.utils.OkLogger;
import java.util.ArrayList;
import java.util.List;

public abstract class DataBaseDao<T> {
    private SQLiteOpenHelper helper;

    public DataBaseDao(SQLiteOpenHelper helper) {
        this.helper = helper;
    }

    protected final SQLiteDatabase openReader() {
        return this.helper.getReadableDatabase();
    }

    protected final SQLiteDatabase openWriter() {
        return this.helper.getWritableDatabase();
    }

    protected final void closeDatabase(SQLiteDatabase database, Cursor cursor) {
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
        if (database != null && database.isOpen()) {
            database.close();
        }
    }

    protected abstract String getTableName();

    public int count() {
        return this.countColumn("_id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countColumn(String columnName) {
        String sql = "SELECT COUNT(?) FROM " + this.getTableName();
        SQLiteDatabase database = this.openReader();
        Cursor cursor = null;
        try {
            database.beginTransaction();
            cursor = database.rawQuery(sql, new String[]{columnName});
            int count = 0;
            if (cursor.moveToNext()) {
                count = cursor.getInt(0);
            }
            database.setTransactionSuccessful();
            int n = count;
            database.endTransaction();
            this.closeDatabase(database, cursor);
            return n;
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        finally {
            database.endTransaction();
            this.closeDatabase(database, cursor);
        }
        return 0;
    }

    public int deleteAll() {
        return this.delete(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(String whereClause, String[] whereArgs) {
        SQLiteDatabase database = this.openWriter();
        try {
            database.beginTransaction();
            int result = database.delete(this.getTableName(), whereClause, whereArgs);
            database.setTransactionSuccessful();
            int n = result;
            return n;
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        finally {
            database.endTransaction();
            this.closeDatabase(database, null);
        }
        return 0;
    }

    public List<T> getAll() {
        return this.get(null, null);
    }

    public List<T> get(String selection, String[] selectionArgs) {
        return this.get(null, selection, selectionArgs, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> get(String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        SQLiteDatabase database = this.openReader();
        ArrayList<T> list = new ArrayList<T>();
        Cursor cursor = null;
        try {
            database.beginTransaction();
            cursor = database.query(this.getTableName(), columns, selection, selectionArgs, groupBy, having, orderBy, limit);
            while (!cursor.isClosed() && cursor.moveToNext()) {
                list.add(this.parseCursorToBean(cursor));
            }
            database.setTransactionSuccessful();
            database.endTransaction();
            this.closeDatabase(database, cursor);
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        finally {
            database.endTransaction();
            this.closeDatabase(database, cursor);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long replace(T t) {
        SQLiteDatabase database = this.openWriter();
        try {
            database.beginTransaction();
            long id = database.replace(this.getTableName(), null, this.getContentValues(t));
            database.setTransactionSuccessful();
            long l = id;
            return l;
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        finally {
            database.endTransaction();
            this.closeDatabase(database, null);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long create(T t) {
        SQLiteDatabase database = this.openWriter();
        try {
            database.beginTransaction();
            long id = database.insert(this.getTableName(), null, this.getContentValues(t));
            database.setTransactionSuccessful();
            long l = id;
            return l;
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        finally {
            database.endTransaction();
            this.closeDatabase(database, null);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(T t, String whereClause, String[] whereArgs) {
        SQLiteDatabase database = this.openWriter();
        try {
            database.beginTransaction();
            int count = database.update(this.getTableName(), this.getContentValues(t), whereClause, whereArgs);
            database.setTransactionSuccessful();
            int n = count;
            return n;
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        finally {
            database.endTransaction();
            this.closeDatabase(database, null);
        }
        return 0;
    }

    public abstract T parseCursorToBean(Cursor var1);

    public abstract ContentValues getContentValues(T var1);
}

