/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cache;

import com.lzy.okgo.cache.CacheDao;
import com.lzy.okgo.cache.CacheEntity;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public enum CacheManager {
    INSTANCE;

    private Lock mLock = new ReentrantLock();
    private CacheDao<Object> cacheDao = new CacheDao();

    public CacheEntity<Object> get(String key) {
        this.mLock.lock();
        try {
            CacheEntity<Object> cacheEntity = this.cacheDao.get(key);
            return cacheEntity;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public <T> CacheEntity<T> get(String key, Class<T> clazz) {
        return this.get(key);
    }

    public List<CacheEntity<Object>> getAll() {
        this.mLock.lock();
        try {
            List<CacheEntity<Object>> list = this.cacheDao.getAll();
            return list;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CacheEntity<T> replace(String key, CacheEntity<T> entity) {
        this.mLock.lock();
        try {
            entity.setKey(key);
            this.cacheDao.replace(entity);
            CacheEntity<T> cacheEntity = entity;
            return cacheEntity;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean remove(String key) {
        if (key == null) {
            return true;
        }
        this.mLock.lock();
        try {
            boolean bl = this.cacheDao.remove(key);
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean clear() {
        this.mLock.lock();
        try {
            boolean bl = this.cacheDao.deleteAll() > 0;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }
}

