/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.cache;

import android.content.ContentValues;
import android.database.Cursor;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.utils.OkLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CacheEntity<T>
implements Serializable {
    private static final long serialVersionUID = -4337711009801627866L;
    public static final long CACHE_NEVER_EXPIRE = -1L;
    private long id;
    private String key;
    private HttpHeaders responseHeaders;
    private T data;
    private long localExpire;
    private boolean isExpire;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(HttpHeaders responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public long getLocalExpire() {
        return this.localExpire;
    }

    public void setLocalExpire(long localExpire) {
        this.localExpire = localExpire;
    }

    public boolean isExpire() {
        return this.isExpire;
    }

    public void setExpire(boolean expire) {
        this.isExpire = expire;
    }

    public boolean checkExpire(CacheMode cacheMode, long cacheTime, long baseTime) {
        if (cacheMode == CacheMode.DEFAULT) {
            return this.getLocalExpire() < baseTime;
        }
        if (cacheTime == -1L) {
            return false;
        }
        return this.getLocalExpire() + cacheTime < baseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ContentValues getContentValues(CacheEntity<T> cacheEntity) {
        ContentValues values = new ContentValues();
        values.put("key", cacheEntity.getKey());
        values.put("localExpire", Long.valueOf(cacheEntity.getLocalExpire()));
        HttpHeaders headers = cacheEntity.getResponseHeaders();
        ByteArrayOutputStream headerBAOS = null;
        ObjectOutputStream headerOOS = null;
        try {
            if (headers != null) {
                headerBAOS = new ByteArrayOutputStream();
                headerOOS = new ObjectOutputStream(headerBAOS);
                headerOOS.writeObject(headers);
                headerOOS.flush();
                byte[] headerData = headerBAOS.toByteArray();
                values.put("head", headerData);
            }
        }
        catch (IOException e) {
            OkLogger.e(e);
        }
        finally {
            try {
                if (headerOOS != null) {
                    headerOOS.close();
                }
                if (headerBAOS != null) {
                    headerBAOS.close();
                }
            }
            catch (IOException e) {
                OkLogger.e(e);
            }
        }
        T data = cacheEntity.getData();
        ByteArrayOutputStream dataBAOS = null;
        ObjectOutputStream dataOOS = null;
        try {
            if (data != null) {
                dataBAOS = new ByteArrayOutputStream();
                dataOOS = new ObjectOutputStream(dataBAOS);
                dataOOS.writeObject(data);
                dataOOS.flush();
                byte[] dataData = dataBAOS.toByteArray();
                values.put("data", dataData);
            }
        }
        catch (IOException e) {
            OkLogger.e(e);
        }
        finally {
            try {
                if (dataOOS != null) {
                    dataOOS.close();
                }
                if (dataBAOS != null) {
                    dataBAOS.close();
                }
            }
            catch (IOException e) {
                OkLogger.e(e);
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> CacheEntity<T> parseCursorToBean(Cursor cursor) {
        CacheEntity<Object> cacheEntity = new CacheEntity<Object>();
        cacheEntity.setId(cursor.getInt(cursor.getColumnIndex("_id")));
        cacheEntity.setKey(cursor.getString(cursor.getColumnIndex("key")));
        cacheEntity.setLocalExpire(cursor.getLong(cursor.getColumnIndex("localExpire")));
        byte[] headerData = cursor.getBlob(cursor.getColumnIndex("head"));
        ByteArrayInputStream headerBAIS = null;
        ObjectInputStream headerOIS = null;
        try {
            if (headerData != null) {
                headerBAIS = new ByteArrayInputStream(headerData);
                headerOIS = new ObjectInputStream(headerBAIS);
                Object header = headerOIS.readObject();
                cacheEntity.setResponseHeaders((HttpHeaders)header);
            }
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        finally {
            try {
                if (headerOIS != null) {
                    headerOIS.close();
                }
                if (headerBAIS != null) {
                    headerBAIS.close();
                }
            }
            catch (IOException e) {
                OkLogger.e(e);
            }
        }
        byte[] dataData = cursor.getBlob(cursor.getColumnIndex("data"));
        ByteArrayInputStream dataBAIS = null;
        ObjectInputStream dataOIS = null;
        try {
            if (dataData != null) {
                dataBAIS = new ByteArrayInputStream(dataData);
                dataOIS = new ObjectInputStream(dataBAIS);
                Object data = dataOIS.readObject();
                cacheEntity.setData(data);
            }
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        finally {
            try {
                if (dataOIS != null) {
                    dataOIS.close();
                }
                if (dataBAIS != null) {
                    dataBAIS.close();
                }
            }
            catch (IOException e) {
                OkLogger.e(e);
            }
        }
        return cacheEntity;
    }

    public String toString() {
        return "CacheEntity{id=" + this.id + ", key='" + this.key + '\'' + ", responseHeaders=" + this.responseHeaders + ", data=" + this.data + ", localExpire=" + this.localExpire + '}';
    }
}

