/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo.adapter;

import android.graphics.Bitmap;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.adapter.Call;
import com.lzy.okgo.cache.CacheEntity;
import com.lzy.okgo.cache.CacheManager;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.callback.AbsCallback;
import com.lzy.okgo.callback.AbsCallbackWrapper;
import com.lzy.okgo.exception.OkGoException;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.request.BaseRequest;
import com.lzy.okgo.utils.HeaderParser;
import com.lzy.okgo.utils.HttpUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CacheCall<T>
implements Call<T> {
    private volatile boolean canceled;
    private boolean executed;
    private BaseRequest baseRequest;
    private okhttp3.Call rawCall;
    private CacheEntity<T> cacheEntity;
    private AbsCallback<T> mCallback;
    private int currentRetryCount;

    public CacheCall(BaseRequest baseRequest) {
        this.baseRequest = baseRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(AbsCallback<T> callback) {
        CacheMode cacheMode;
        CacheCall cacheCall = this;
        synchronized (cacheCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
        }
        this.mCallback = callback;
        if (this.mCallback == null) {
            this.mCallback = new AbsCallbackWrapper();
        }
        this.mCallback.onBefore(this.baseRequest);
        if (this.baseRequest.getCacheKey() == null) {
            this.baseRequest.setCacheKey(HttpUtils.createUrlFromParams(this.baseRequest.getBaseUrl(), this.baseRequest.getParams().urlParamsMap));
        }
        if (this.baseRequest.getCacheMode() == null) {
            this.baseRequest.setCacheMode(CacheMode.NO_CACHE);
        }
        if ((cacheMode = this.baseRequest.getCacheMode()) != CacheMode.NO_CACHE) {
            this.cacheEntity = CacheManager.INSTANCE.get(this.baseRequest.getCacheKey());
            if (this.cacheEntity != null && this.cacheEntity.checkExpire(cacheMode, this.baseRequest.getCacheTime(), System.currentTimeMillis())) {
                this.cacheEntity.setExpire(true);
            }
            HeaderParser.addCacheHeaders(this.baseRequest, this.cacheEntity, cacheMode);
        }
        RequestBody requestBody = this.baseRequest.generateRequestBody();
        Request request = this.baseRequest.generateRequest(this.baseRequest.wrapRequestBody(requestBody));
        this.rawCall = this.baseRequest.generateCall(request);
        if (cacheMode == CacheMode.IF_NONE_CACHE_REQUEST) {
            if (this.cacheEntity != null && !this.cacheEntity.isExpire()) {
                T data = this.cacheEntity.getData();
                HttpHeaders headers = this.cacheEntity.getResponseHeaders();
                if (data != null && headers != null) {
                    this.sendSuccessResultCallback(true, data, this.rawCall, null);
                    return;
                }
                this.sendFailResultCallback(true, this.rawCall, null, OkGoException.INSTANCE("\u6ca1\u6709\u83b7\u53d6\u5230\u7f13\u5b58,\u6216\u8005\u7f13\u5b58\u5df2\u7ecf\u8fc7\u671f!"));
            } else {
                this.sendFailResultCallback(true, this.rawCall, null, OkGoException.INSTANCE("\u6ca1\u6709\u83b7\u53d6\u5230\u7f13\u5b58,\u6216\u8005\u7f13\u5b58\u5df2\u7ecf\u8fc7\u671f!"));
            }
        } else if (cacheMode == CacheMode.FIRST_CACHE_THEN_REQUEST) {
            if (this.cacheEntity != null && !this.cacheEntity.isExpire()) {
                T data = this.cacheEntity.getData();
                HttpHeaders headers = this.cacheEntity.getResponseHeaders();
                if (data == null || headers == null) {
                    this.sendFailResultCallback(true, this.rawCall, null, OkGoException.INSTANCE("\u6ca1\u6709\u83b7\u53d6\u5230\u7f13\u5b58,\u6216\u8005\u7f13\u5b58\u5df2\u7ecf\u8fc7\u671f!"));
                } else {
                    this.sendSuccessResultCallback(true, data, this.rawCall, null);
                }
            } else {
                this.sendFailResultCallback(true, this.rawCall, null, OkGoException.INSTANCE("\u6ca1\u6709\u83b7\u53d6\u5230\u7f13\u5b58,\u6216\u8005\u7f13\u5b58\u5df2\u7ecf\u8fc7\u671f!"));
            }
        }
        if (this.canceled) {
            this.rawCall.cancel();
        }
        this.currentRetryCount = 0;
        this.rawCall.enqueue(new Callback(){

            public void onFailure(okhttp3.Call call, IOException e) {
                if (e instanceof SocketTimeoutException && CacheCall.this.currentRetryCount < CacheCall.this.baseRequest.getRetryCount()) {
                    CacheCall.this.currentRetryCount++;
                    okhttp3.Call newCall = CacheCall.this.baseRequest.generateCall(call.request());
                    newCall.enqueue((Callback)this);
                } else {
                    CacheCall.this.mCallback.parseError(call, e);
                    if (!call.isCanceled()) {
                        CacheCall.this.sendFailResultCallback(false, call, null, e);
                    }
                }
            }

            public void onResponse(okhttp3.Call call, Response response) throws IOException {
                int responseCode = response.code();
                if (responseCode == 304 && cacheMode == CacheMode.DEFAULT) {
                    if (CacheCall.this.cacheEntity == null) {
                        CacheCall.this.sendFailResultCallback(true, call, response, OkGoException.INSTANCE("\u670d\u52a1\u5668\u54cd\u5e94\u7801304\uff0c\u4f46\u662f\u5ba2\u6237\u7aef\u6ca1\u6709\u7f13\u5b58\uff01"));
                    } else {
                        Object data = CacheCall.this.cacheEntity.getData();
                        HttpHeaders headers = CacheCall.this.cacheEntity.getResponseHeaders();
                        if (data == null || headers == null) {
                            CacheCall.this.sendFailResultCallback(true, call, response, OkGoException.INSTANCE("\u6ca1\u6709\u83b7\u53d6\u5230\u7f13\u5b58,\u6216\u8005\u7f13\u5b58\u5df2\u7ecf\u8fc7\u671f!"));
                        } else {
                            CacheCall.this.sendSuccessResultCallback(true, data, call, response);
                        }
                    }
                    return;
                }
                if (responseCode == 404 || responseCode >= 500) {
                    CacheCall.this.sendFailResultCallback(false, call, response, OkGoException.INSTANCE("\u670d\u52a1\u5668\u6570\u636e\u5f02\u5e38!"));
                    return;
                }
                try {
                    com.lzy.okgo.model.Response parseResponse = CacheCall.this.parseResponse(response);
                    Object data = parseResponse.body();
                    CacheCall.this.handleCache(response.headers(), data);
                    CacheCall.this.sendSuccessResultCallback(false, data, call, response);
                }
                catch (Exception e) {
                    CacheCall.this.sendFailResultCallback(false, call, response, e);
                }
            }
        });
    }

    private void handleCache(Headers headers, T data) {
        if (this.baseRequest.getCacheMode() == CacheMode.NO_CACHE) {
            return;
        }
        if (data instanceof Bitmap) {
            return;
        }
        CacheEntity<T> cache = HeaderParser.createCacheEntity(headers, data, this.baseRequest.getCacheMode(), this.baseRequest.getCacheKey());
        if (cache == null) {
            CacheManager.INSTANCE.remove(this.baseRequest.getCacheKey());
        } else {
            CacheManager.INSTANCE.replace(this.baseRequest.getCacheKey(), cache);
        }
    }

    private void sendFailResultCallback(final boolean isFromCache, final okhttp3.Call call, final Response response, final Exception e) {
        final CacheMode cacheMode = this.baseRequest.getCacheMode();
        OkGo.getInstance().getDelivery().post(new Runnable(){

            @Override
            public void run() {
                if (isFromCache) {
                    CacheCall.this.mCallback.onCacheError(call, e);
                    if (cacheMode == CacheMode.DEFAULT || cacheMode == CacheMode.REQUEST_FAILED_READ_CACHE) {
                        CacheCall.this.mCallback.onAfter(null, e);
                    }
                } else {
                    CacheCall.this.mCallback.onError(call, response, e);
                    if (cacheMode != CacheMode.REQUEST_FAILED_READ_CACHE) {
                        CacheCall.this.mCallback.onAfter(null, e);
                    }
                }
            }
        });
        if (!isFromCache && cacheMode == CacheMode.REQUEST_FAILED_READ_CACHE) {
            if (this.cacheEntity != null && !this.cacheEntity.isExpire()) {
                T data = this.cacheEntity.getData();
                HttpHeaders headers = this.cacheEntity.getResponseHeaders();
                if (data == null || headers == null) {
                    this.sendFailResultCallback(true, call, response, OkGoException.INSTANCE("\u6ca1\u6709\u83b7\u53d6\u5230\u7f13\u5b58,\u6216\u8005\u7f13\u5b58\u5df2\u7ecf\u8fc7\u671f!"));
                } else {
                    this.sendSuccessResultCallback(true, data, call, response);
                }
            } else {
                this.sendFailResultCallback(true, call, response, OkGoException.INSTANCE("\u6ca1\u6709\u83b7\u53d6\u5230\u7f13\u5b58,\u6216\u8005\u7f13\u5b58\u5df2\u7ecf\u8fc7\u671f!"));
            }
        }
    }

    private void sendSuccessResultCallback(final boolean isFromCache, final T t, final okhttp3.Call call, final Response response) {
        final CacheMode cacheMode = this.baseRequest.getCacheMode();
        OkGo.getInstance().getDelivery().post(new Runnable(){

            @Override
            public void run() {
                if (isFromCache) {
                    CacheCall.this.mCallback.onCacheSuccess(t, call);
                    if (cacheMode == CacheMode.DEFAULT || cacheMode == CacheMode.REQUEST_FAILED_READ_CACHE || cacheMode == CacheMode.IF_NONE_CACHE_REQUEST) {
                        CacheCall.this.mCallback.onAfter(t, null);
                    }
                } else {
                    CacheCall.this.mCallback.onSuccess(t, call, response);
                    CacheCall.this.mCallback.onAfter(t, null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.lzy.okgo.model.Response<T> execute() throws Exception {
        CacheCall cacheCall = this;
        synchronized (cacheCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
        }
        okhttp3.Call call = this.baseRequest.getCall();
        if (this.canceled) {
            call.cancel();
        }
        return this.parseResponse(call.execute());
    }

    private com.lzy.okgo.model.Response<T> parseResponse(Response rawResponse) throws Exception {
        Object body = this.baseRequest.getConverter().convertSuccess(rawResponse);
        return com.lzy.okgo.model.Response.success(body, rawResponse);
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.rawCall != null) {
            this.rawCall.cancel();
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public Call<T> clone() {
        return new CacheCall<T>(this.baseRequest);
    }

    @Override
    public BaseRequest getBaseRequest() {
        return this.baseRequest;
    }
}

