/*
 * Decompiled with CFR 0.152.
 */
package com.lzy.okgo;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.cookie.CookieJarImpl;
import com.lzy.okgo.cookie.store.CookieStore;
import com.lzy.okgo.https.HttpsUtils;
import com.lzy.okgo.interceptor.HttpLoggingInterceptor;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.model.HttpParams;
import com.lzy.okgo.request.DeleteRequest;
import com.lzy.okgo.request.GetRequest;
import com.lzy.okgo.request.HeadRequest;
import com.lzy.okgo.request.OptionsRequest;
import com.lzy.okgo.request.PostRequest;
import com.lzy.okgo.request.PutRequest;
import com.lzy.okgo.utils.OkLogger;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkGo {
    public static final int DEFAULT_MILLISECONDS = 60000;
    public static int REFRESH_TIME = 100;
    private Handler mDelivery;
    private OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
    private OkHttpClient okHttpClient;
    private HttpParams mCommonParams;
    private HttpHeaders mCommonHeaders;
    private CacheMode mCacheMode;
    private int mRetryCount = 3;
    private long mCacheTime = -1L;
    private static Application context;
    private CookieJarImpl cookieJar;

    private OkGo() {
        this.okHttpClientBuilder.hostnameVerifier(HttpsUtils.UnSafeHostnameVerifier);
        this.okHttpClientBuilder.connectTimeout(60000L, TimeUnit.MILLISECONDS);
        this.okHttpClientBuilder.readTimeout(60000L, TimeUnit.MILLISECONDS);
        this.okHttpClientBuilder.writeTimeout(60000L, TimeUnit.MILLISECONDS);
        this.mDelivery = new Handler(Looper.getMainLooper());
    }

    public static OkGo getInstance() {
        return OkGoHolder.holder;
    }

    public static void init(Application app) {
        context = app;
    }

    public static Context getContext() {
        if (context == null) {
            throw new IllegalStateException("\u8bf7\u5148\u5728\u5168\u5c40Application\u4e2d\u8c03\u7528 OkGo.init() \u521d\u59cb\u5316\uff01");
        }
        return context;
    }

    public Handler getDelivery() {
        return this.mDelivery;
    }

    public OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            this.okHttpClient = this.okHttpClientBuilder.build();
        }
        return this.okHttpClient;
    }

    public OkHttpClient.Builder getOkHttpClientBuilder() {
        return this.okHttpClientBuilder;
    }

    public static GetRequest get(String url) {
        return new GetRequest(url);
    }

    public static PostRequest post(String url) {
        return new PostRequest(url);
    }

    public static PutRequest put(String url) {
        return new PutRequest(url);
    }

    public static HeadRequest head(String url) {
        return new HeadRequest(url);
    }

    public static DeleteRequest delete(String url) {
        return new DeleteRequest(url);
    }

    public static OptionsRequest options(String url) {
        return new OptionsRequest(url);
    }

    public OkGo debug(String tag) {
        this.debug(tag, Level.INFO, true);
        return this;
    }

    public OkGo debug(String tag, Level level, boolean isPrintException) {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(tag);
        loggingInterceptor.setPrintLevel(HttpLoggingInterceptor.Level.BODY);
        loggingInterceptor.setColorLevel(level);
        this.okHttpClientBuilder.addInterceptor((Interceptor)loggingInterceptor);
        OkLogger.debug(isPrintException);
        return this;
    }

    public OkGo setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.okHttpClientBuilder.hostnameVerifier(hostnameVerifier);
        return this;
    }

    public OkGo setCertificates(InputStream ... certificates) {
        this.setCertificates((InputStream)null, (String)null, certificates);
        return this;
    }

    public OkGo setCertificates(X509TrustManager trustManager) {
        this.setCertificates(null, null, trustManager);
        return this;
    }

    public OkGo setCertificates(InputStream bksFile, String password, InputStream ... certificates) {
        HttpsUtils.SSLParams sslParams = HttpsUtils.getSslSocketFactory(null, bksFile, password, certificates);
        this.okHttpClientBuilder.sslSocketFactory(sslParams.sSLSocketFactory, sslParams.trustManager);
        return this;
    }

    public OkGo setCertificates(InputStream bksFile, String password, X509TrustManager trustManager) {
        HttpsUtils.SSLParams sslParams = HttpsUtils.getSslSocketFactory(trustManager, bksFile, password, null);
        this.okHttpClientBuilder.sslSocketFactory(sslParams.sSLSocketFactory, sslParams.trustManager);
        return this;
    }

    public OkGo setCookieStore(CookieStore cookieStore) {
        this.cookieJar = new CookieJarImpl(cookieStore);
        this.okHttpClientBuilder.cookieJar((CookieJar)this.cookieJar);
        return this;
    }

    public CookieJarImpl getCookieJar() {
        return this.cookieJar;
    }

    public OkGo setReadTimeOut(long readTimeOut) {
        this.okHttpClientBuilder.readTimeout(readTimeOut, TimeUnit.MILLISECONDS);
        return this;
    }

    public OkGo setWriteTimeOut(long writeTimeout) {
        this.okHttpClientBuilder.writeTimeout(writeTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public OkGo setConnectTimeout(long connectTimeout) {
        this.okHttpClientBuilder.connectTimeout(connectTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public OkGo setRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("retryCount must > 0");
        }
        this.mRetryCount = retryCount;
        return this;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    public OkGo setCacheMode(CacheMode cacheMode) {
        this.mCacheMode = cacheMode;
        return this;
    }

    public CacheMode getCacheMode() {
        return this.mCacheMode;
    }

    public OkGo setCacheTime(long cacheTime) {
        if (cacheTime <= -1L) {
            cacheTime = -1L;
        }
        this.mCacheTime = cacheTime;
        return this;
    }

    public long getCacheTime() {
        return this.mCacheTime;
    }

    public HttpParams getCommonParams() {
        return this.mCommonParams;
    }

    public OkGo addCommonParams(HttpParams commonParams) {
        if (this.mCommonParams == null) {
            this.mCommonParams = new HttpParams();
        }
        this.mCommonParams.put(commonParams);
        return this;
    }

    public HttpHeaders getCommonHeaders() {
        return this.mCommonHeaders;
    }

    public OkGo addCommonHeaders(HttpHeaders commonHeaders) {
        if (this.mCommonHeaders == null) {
            this.mCommonHeaders = new HttpHeaders();
        }
        this.mCommonHeaders.put(commonHeaders);
        return this;
    }

    public OkGo addInterceptor(Interceptor interceptor) {
        this.okHttpClientBuilder.addInterceptor(interceptor);
        return this;
    }

    public void cancelTag(Object tag) {
        for (Call call : this.getOkHttpClient().dispatcher().queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : this.getOkHttpClient().dispatcher().runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    public void cancelAll() {
        for (Call call : this.getOkHttpClient().dispatcher().queuedCalls()) {
            call.cancel();
        }
        for (Call call : this.getOkHttpClient().dispatcher().runningCalls()) {
            call.cancel();
        }
    }

    private static class OkGoHolder {
        private static OkGo holder = new OkGo();

        private OkGoHolder() {
        }
    }
}

