/*
 * Decompiled with CFR 0.152.
 */
package com.lyra.rest.client;

import com.google.gson.Gson;
import com.lyra.rest.client.ClientConfiguration;
import com.lyra.rest.client.ClientCryptUtil;
import com.lyra.rest.client.ClientException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class Client {
    protected static final String REST_API_VERSION = "V4";
    protected static final Gson GSON = new Gson();
    private static final String DEFAULT_CONFIGURATION_FILE_NAME = "api-client-configuration-default";
    private static final String APP_CONFIGURATION_FILE_NAME = "api-client-configuration";
    private static final int HTTP_RESPONSE_OK = 200;
    private static String defaultUsername;
    private static String defaultPassword;
    private static String defaultRestApiServerName;
    private static String defaultProxyHost;
    private static String defaultProxyPort;
    private static String defaultConnectionTimeout;
    private static String defaultRequestTimeout;
    private static String defaultHashKey;

    private Client() {
    }

    public static String post(String targetResource, Map<String, Object> parameters) {
        return Client.post(targetResource, parameters, ClientConfiguration.builder().build());
    }

    public static String post(String targetResource, Map<String, Object> parameters, ClientConfiguration requestConfiguration) {
        String responseMessage = null;
        Map<String, String> configuration = Client.getFinalConfiguration(requestConfiguration);
        try {
            HttpURLConnection connection = Client.createConnection(targetResource, configuration);
            Client.sendRequestPayload(connection, GSON.toJson(parameters));
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new ClientException("HTTP call to Payment Platform was not successful.", responseCode, Client.readResponseContent(connection));
            }
            responseMessage = Client.readResponseContent(connection);
        }
        catch (IOException ioe) {
            throw new ClientException("Exception calling payment platform server", ioe);
        }
        return responseMessage;
    }

    public static boolean verifyAnswer(Map<String, Object> paymentAnswer) {
        return Client.verifyAnswer(paymentAnswer, ClientConfiguration.builder().build());
    }

    public static boolean verifyAnswer(Map<String, Object> paymentAnswer, ClientConfiguration requestConfiguration) {
        String answer = (String)paymentAnswer.get("kr-answer");
        String hashAlgorithm = (String)paymentAnswer.get("kr-hash-algorithm");
        if (!ClientCryptUtil.isAlgorithmSupported(hashAlgorithm)) {
            throw new ClientException("Signature algorithm not supported. Make sure you are using the last version of this SDK");
        }
        Map<String, String> configuration = Client.getFinalConfiguration(requestConfiguration);
        String answerHash = (String)paymentAnswer.get("kr-hash");
        return answerHash.equals(ClientCryptUtil.calculateHash(answer, configuration.get("hashKey"), hashAlgorithm));
    }

    private static Map<String, String> getFinalConfiguration(ClientConfiguration requestConfiguration) {
        if (requestConfiguration == null) {
            requestConfiguration = ClientConfiguration.builder().build();
        }
        HashMap<String, String> finalConfiguration = new HashMap<String, String>();
        finalConfiguration.put("username", requestConfiguration.getUsername() != null ? requestConfiguration.getUsername() : defaultUsername);
        finalConfiguration.put("password", requestConfiguration.getPassword() != null ? requestConfiguration.getPassword() : defaultPassword);
        finalConfiguration.put("restApiServerName", requestConfiguration.getRestApiServerName() != null ? requestConfiguration.getRestApiServerName() : defaultRestApiServerName);
        finalConfiguration.put("proxyHost", requestConfiguration.getProxyHost() != null ? requestConfiguration.getProxyHost() : defaultProxyHost);
        finalConfiguration.put("proxyPort", requestConfiguration.getProxyPort() != null ? requestConfiguration.getProxyPort() : defaultProxyPort);
        finalConfiguration.put("connectionTimeout", requestConfiguration.getConnectionTimeout() != null ? requestConfiguration.getConnectionTimeout() : defaultConnectionTimeout);
        finalConfiguration.put("requestTimeout", requestConfiguration.getRequestTimeout() != null ? requestConfiguration.getRequestTimeout() : defaultRequestTimeout);
        finalConfiguration.put("hashKey", requestConfiguration.getHashKey() != null ? requestConfiguration.getHashKey() : defaultHashKey);
        return finalConfiguration;
    }

    private static Properties readDefaultConfiguration() {
        Properties finalConfigurationProperties = Client.readConfigurationFile(DEFAULT_CONFIGURATION_FILE_NAME);
        Properties appConfigurationProperties = Client.readConfigurationFile(APP_CONFIGURATION_FILE_NAME);
        appConfigurationProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> finalConfigurationProperties.setProperty((String)k, (String)v)));
        return finalConfigurationProperties;
    }

    private static Properties readConfigurationFile(String configurationFilename) {
        Properties props = new Properties();
        try (InputStream input = Client.class.getClassLoader().getResourceAsStream(configurationFilename + ".properties");){
            if (input != null) {
                props.load(input);
            }
        }
        catch (IOException ioe) {
            throw new ClientException("Could not read application configuration", ioe);
        }
        return props;
    }

    private static String generateChargeUrl(String resource, Map<String, String> configuration) {
        return String.format("%s/api-payment/%s/%s", configuration.get("restApiServerName"), REST_API_VERSION, resource);
    }

    private static URL getURLToConnect(String resource, Map<String, String> configuration) throws MalformedURLException {
        return new URL(Client.generateChargeUrl(resource, configuration));
    }

    private static HttpURLConnection getConnection(URL url, Proxy proxy) throws IOException {
        return proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
    }

    private static HttpURLConnection createConnection(String resource, Map<String, String> configuration) throws IOException {
        URL urlToConnect = Client.getURLToConnect(resource, configuration);
        Proxy proxy = null;
        if (Client.couldUseProxy(urlToConnect.getHost())) {
            String proxyServer = configuration.get("proxyHost");
            String proxyPort = configuration.get("proxyPort");
            if (proxyServer != null && !proxyServer.isEmpty() && proxyPort != null && !proxyPort.isEmpty()) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyServer, Integer.parseInt(proxyPort)));
            }
        }
        HttpURLConnection connection = Client.getConnection(urlToConnect, proxy);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("User-Agent", "Mobile Client SDK V4");
        connection.setRequestProperty("Content-type", "application/json; charset=" + StandardCharsets.UTF_8);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Authorization", "Basic " + Client.generateAuthorizationToken(configuration));
        String connectionTimeout = configuration.get("connectionTimeout");
        String requestTimeout = configuration.get("requestTimeout");
        if (connectionTimeout != null && !connectionTimeout.isEmpty()) {
            connection.setConnectTimeout(Integer.parseInt(connectionTimeout));
        }
        if (requestTimeout != null && !requestTimeout.isEmpty()) {
            connection.setReadTimeout(Integer.parseInt(requestTimeout));
        }
        return connection;
    }

    private static void sendRequestPayload(HttpURLConnection connection, String payload) throws IOException {
        connection.setDoOutput(true);
        try (OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);){
            wr.write(payload);
            wr.flush();
        }
    }

    private static String readResponseContent(HttpURLConnection connection) throws IOException {
        String responseMessage = "";
        if (connection != null && connection.getInputStream() != null) {
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                responseMessage = buffer.lines().collect(Collectors.joining("\n"));
            }
        }
        return responseMessage;
    }

    private static String generateAuthorizationToken(Map<String, String> configuration) {
        return Base64.getEncoder().encodeToString((configuration.get("username") + ":" + configuration.get("password")).getBytes(StandardCharsets.UTF_8));
    }

    private static boolean couldUseProxy(String proxyHost) {
        return proxyHost != null && !"localhost".equals(proxyHost) && !"127.0.0.1".equals(proxyHost);
    }

    static {
        Properties defaultConfiguration = Client.readDefaultConfiguration();
        defaultUsername = defaultConfiguration.getProperty("username");
        defaultPassword = defaultConfiguration.getProperty("password");
        defaultRestApiServerName = defaultConfiguration.getProperty("restApiServerName");
        defaultProxyHost = defaultConfiguration.getProperty("proxyHost");
        defaultProxyPort = defaultConfiguration.getProperty("proxyPort");
        defaultConnectionTimeout = defaultConfiguration.getProperty("connectionTimeout");
        defaultRequestTimeout = defaultConfiguration.getProperty("requestTimeout");
        defaultHashKey = defaultConfiguration.getProperty("hashKey");
    }
}

