/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx.service.directions;

import com.lynden.gmapsfx.javascript.JavascriptObject;
import com.lynden.gmapsfx.javascript.object.LatLong;
import com.lynden.gmapsfx.service.directions.DirectionsWaypoint;
import com.lynden.gmapsfx.service.directions.DrivingOptions;
import com.lynden.gmapsfx.service.directions.TravelModes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectionsRequest
extends JavascriptObject {
    private static final Logger LOG = LoggerFactory.getLogger(DirectionsRequest.class);
    static boolean opt = true;

    public void setOpt(boolean opt) {
        DirectionsRequest.opt = opt;
    }

    public DirectionsRequest(String addressOrigin, String addressDestination, TravelModes travelModes) {
        this(addressOrigin, null, addressDestination, null, travelModes, null, null);
    }

    public DirectionsRequest(LatLong latLongOrigin, LatLong latLongDestination, TravelModes travelModes) {
        this(null, latLongOrigin, null, latLongDestination, travelModes, null, null);
    }

    public DirectionsRequest(LatLong latLongOrigin, LatLong latLongDestination, TravelModes travelModes, DrivingOptions drivingOpttions) {
        this(null, latLongOrigin, null, latLongDestination, travelModes, drivingOpttions, null);
    }

    public DirectionsRequest(String addressOrigin, String addressDestination, TravelModes travelModes, DrivingOptions drivingOpttions) {
        this(addressOrigin, null, addressDestination, null, travelModes, drivingOpttions, null);
    }

    public DirectionsRequest(LatLong latLongOrigin, LatLong latLongDestination, TravelModes travelModes, DrivingOptions drivingOpttions, DirectionsWaypoint[] waypoints) {
        this(null, latLongOrigin, null, latLongDestination, travelModes, drivingOpttions, waypoints);
    }

    public DirectionsRequest(String addressOrigin, String addressDestination, TravelModes travelModes, DrivingOptions drivingOpttions, DirectionsWaypoint[] waypoints) {
        this(addressOrigin, null, addressDestination, null, travelModes, drivingOpttions, waypoints);
    }

    public DirectionsRequest(LatLong latLongOrigin, LatLong latLongDestination, TravelModes travelModes, DirectionsWaypoint[] waypoints) {
        this(null, latLongOrigin, null, latLongDestination, travelModes, null, waypoints);
    }

    public DirectionsRequest(String addressOrigin, String addressDestination, TravelModes travelModes, DirectionsWaypoint[] waypoints) {
        this(addressOrigin, null, addressDestination, null, travelModes, null, waypoints);
    }

    public DirectionsRequest(String addressOrigin, LatLong latLongOrigin, String addressDestination, LatLong latLongDestination, TravelModes travelmode, DrivingOptions drivingOptions, DirectionsWaypoint[] waypoints) {
        super("google.maps.DirectionsRequest", DirectionsRequest.convertToJavascriptString(addressOrigin, latLongOrigin, addressDestination, latLongDestination, travelmode, drivingOptions, waypoints));
    }

    private static String convertToJavascriptString(String addressOrigin, LatLong latLongOrigin, String addressDestination, LatLong latLongDestination, TravelModes travelmode, DrivingOptions drivingOptions, DirectionsWaypoint[] waypoints) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean something = false;
        if (addressOrigin != null && latLongOrigin == null) {
            something = true;
            builder.append("origin: '").append(addressOrigin).append("'");
        }
        if (addressOrigin == null && latLongOrigin != null) {
            something = true;
            builder.append("origin: '").append(latLongOrigin.getVariableName()).append("'");
        }
        if (addressDestination != null && latLongDestination == null) {
            builder.append(something ? "," : "");
            builder.append("destination: '").append(addressDestination).append("'");
        }
        if (addressDestination == null && latLongDestination != null) {
            builder.append(something ? "," : "");
            builder.append("destination: '").append(latLongDestination.getVariableName()).append("'");
        }
        if (travelmode != null) {
            builder.append(something ? "," : "");
            builder.append("travelMode: ").append("google.maps.TravelMode.").append(travelmode.toString());
            something = true;
        }
        if (drivingOptions != null) {
            builder.append(something ? "," : "");
            builder.append("drivingOptions: ").append(drivingOptions.getVariableName());
            something = true;
        }
        if (waypoints != null) {
            builder.append(something ? "," : "");
            builder.append("optimizeWaypoints: ");
            builder.append(opt);
            builder.append(",");
            builder.append("waypoints: [");
            for (DirectionsWaypoint w : waypoints) {
                something = true;
                builder.append(w.getVariableName());
                builder.append(something ? "," : "");
            }
            builder.append("]");
        }
        builder.append("}");
        LOG.trace("REQUEST " + builder.toString());
        return builder.toString();
    }

    public String toString() {
        return "REQUEST: \norigin: " + this.getJSObject().getMember("origin").toString() + "\n" + "destination: " + this.getJSObject().getMember("destination").toString() + "\n" + "travelMode: " + this.getJSObject().getMember("travelMode").toString() + "\n";
    }
}

