/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx.javascript.object;

import com.lynden.gmapsfx.javascript.JavascriptObject;
import com.lynden.gmapsfx.javascript.JavascriptRuntime;
import com.lynden.gmapsfx.javascript.event.EventHandlers;
import com.lynden.gmapsfx.javascript.event.GFXEventHandler;
import com.lynden.gmapsfx.javascript.event.MapStateEventType;
import com.lynden.gmapsfx.javascript.event.MouseEventHandler;
import com.lynden.gmapsfx.javascript.event.StateEventHandler;
import com.lynden.gmapsfx.javascript.event.UIEventHandler;
import com.lynden.gmapsfx.javascript.event.UIEventType;
import com.lynden.gmapsfx.javascript.object.GMapPoint;
import com.lynden.gmapsfx.javascript.object.LatLong;
import com.lynden.gmapsfx.javascript.object.LatLongBounds;
import com.lynden.gmapsfx.javascript.object.MapOptions;
import com.lynden.gmapsfx.javascript.object.MapShape;
import com.lynden.gmapsfx.javascript.object.MapTypeIdEnum;
import com.lynden.gmapsfx.javascript.object.Marker;
import com.lynden.gmapsfx.javascript.object.Projection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.geometry.Point2D;
import javafx.util.Callback;
import netscape.javascript.JSObject;

public class GoogleMap
extends JavascriptObject {
    private boolean userPromptedZoomChange;
    private boolean mapPromptedZoomChange;
    protected MapOptions options;
    protected static String divArg = "document.getElementById('map-canvas')";
    private ReadOnlyObjectWrapper<LatLong> center;
    private IntegerProperty zoom;
    private ReadOnlyObjectWrapper<LatLongBounds> bounds;
    private final EventHandlers jsHandlers = new EventHandlers();
    private boolean registeredOnJS;
    private Set<Marker> markers;

    public GoogleMap() {
        super("google.maps.Map", divArg);
        this.initialize();
    }

    public GoogleMap(MapOptions mapOptions) {
        super("google.maps.Map", divArg, mapOptions);
        this.initialize();
    }

    protected void initialize() {
        this.zoom = new SimpleIntegerProperty(this.internalGetZoom());
        this.addStateEventHandler(MapStateEventType.zoom_changed, () -> {
            if (!this.userPromptedZoomChange) {
                this.mapPromptedZoomChange = true;
                this.zoom.set(this.internalGetZoom());
                this.mapPromptedZoomChange = false;
            }
        });
        this.zoom.addListener((obs, o, n) -> {
            if (!this.mapPromptedZoomChange) {
                this.userPromptedZoomChange = true;
                this.internalSetZoom(n.intValue());
                this.userPromptedZoomChange = false;
            }
        });
        this.center = new ReadOnlyObjectWrapper((Object)this.getCenter());
        this.addStateEventHandler(MapStateEventType.center_changed, () -> this.center.set((Object)this.getCenter()));
    }

    public void setZoom(int zoom) {
        this.zoomProperty().set(zoom);
    }

    public int getZoom() {
        return this.zoomProperty().get();
    }

    private int internalGetZoom() {
        return (Integer)this.invokeJavascript("getZoom");
    }

    private void internalSetZoom(int zoom) {
        this.invokeJavascript("setZoom", zoom);
    }

    public void showDirectionsPane() {
        JavascriptRuntime.getInstance().execute("showDirections()");
    }

    public void hideDirectionsPane() {
        JavascriptRuntime.getInstance().execute("hideDirections()");
    }

    public IntegerProperty zoomProperty() {
        return this.zoom;
    }

    public final ReadOnlyObjectProperty<LatLong> centerProperty() {
        return this.center.getReadOnlyProperty();
    }

    public LatLong getCenter() {
        return new LatLong((JSObject)this.invokeJavascript("getCenter"));
    }

    public void setCenter(LatLong latLong) {
        this.invokeJavascript("setCenter", latLong);
    }

    public LatLongBounds getBounds() {
        return this.invokeJavascriptReturnValue("getBounds", LatLongBounds.class);
    }

    public void fitBounds(LatLongBounds bounds) {
        this.invokeJavascript("fitBounds", bounds);
    }

    public void panToBounds(LatLongBounds bounds) {
        this.invokeJavascript("panToBounds", bounds);
    }

    public final ReadOnlyObjectProperty<LatLongBounds> boundsProperty() {
        if (this.bounds == null) {
            this.bounds = new ReadOnlyObjectWrapper((Object)this.getBounds());
            this.addStateEventHandler(MapStateEventType.idle, () -> this.bounds.set((Object)this.getBounds()));
        }
        return this.bounds.getReadOnlyProperty();
    }

    public void setHeading(double heading) {
        this.invokeJavascript("setHeading", heading);
    }

    public double getHeading() {
        return this.invokeJavascriptReturnValue("getHeading", Double.class);
    }

    public void addMarker(Marker marker) {
        if (this.markers == null) {
            this.markers = new HashSet<Marker>();
        }
        this.markers.add(marker);
        marker.setMap(this);
    }

    public void removeMarker(Marker marker) {
        if (this.markers != null && this.markers.contains(marker)) {
            this.markers.remove(marker);
        }
        marker.setMap(null);
    }

    public void clearMarkers() {
        if (this.markers != null && !this.markers.isEmpty()) {
            this.markers.forEach(m -> m.setMap(null));
            this.markers.clear();
        }
    }

    public void addMarkers(Collection<Marker> col) {
        if (this.markers == null) {
            this.markers = new HashSet<Marker>(col);
        } else {
            this.markers.addAll(col);
        }
        col.forEach(m -> m.setMap(this));
    }

    public void addMarkers(Collection<Marker> col, UIEventType type, Callback<Marker, UIEventHandler> h) {
        if (this.markers == null) {
            this.markers = new HashSet<Marker>(col);
        } else {
            this.markers.addAll(col);
        }
        col.forEach(m -> {
            m.setMap(this);
            this.addUIEventHandler((JavascriptObject)m, type, (UIEventHandler)h.call(m));
        });
    }

    public void removeMarkers(Collection<Marker> col) {
        if (this.markers != null && !this.markers.isEmpty()) {
            this.markers.removeAll(col);
            col.forEach(m -> m.setMap(null));
        }
    }

    public void setMapType(MapTypeIdEnum type) {
        this.invokeJavascript("setMapTypeId", type);
    }

    public void addMapShape(MapShape shape) {
        shape.setMap(this);
    }

    public void removeMapShape(MapShape shape) {
        shape.setMap(null);
    }

    public Projection getProjection() {
        Object obj = this.invokeJavascript("getProjection");
        return obj == null ? null : new Projection((JSObject)obj);
    }

    public void panBy(double x, double y) {
        this.invokeJavascript("panBy", x, y);
    }

    public void panTo(LatLong latLong) {
        this.invokeJavascript("panTo", latLong);
    }

    public Point2D fromLatLngToPoint(LatLong loc) {
        Projection proj = this.getProjection();
        LatLongBounds llb = this.getBounds();
        GMapPoint topRight = proj.fromLatLngToPoint(llb.getNorthEast());
        GMapPoint bottomLeft = proj.fromLatLngToPoint(llb.getSouthWest());
        double scale = Math.pow(2.0, this.getZoom());
        GMapPoint worldPoint = proj.fromLatLngToPoint(loc);
        double x = (worldPoint.getX() - bottomLeft.getX()) * scale;
        double y = (worldPoint.getY() - topRight.getY()) * scale;
        return new Point2D(x, y);
    }

    private String registerEventHandler(GFXEventHandler h) {
        if (!this.registeredOnJS) {
            JSObject doc = this.runtime.execute("document");
            doc.setMember("jsHandlers", this.jsHandlers);
            this.registeredOnJS = true;
        }
        return this.jsHandlers.registerHandler(h);
    }

    public void addUIEventHandler(UIEventType type, UIEventHandler h) {
        this.addUIEventHandler(this, type, h);
    }

    public void addUIEventHandler(JavascriptObject obj, UIEventType type, UIEventHandler h) {
        this.addUIHandler(obj, type, h);
    }

    public void addMouseEventHandler(UIEventType type, MouseEventHandler h) {
        this.addUIHandler(this, type, h);
    }

    protected void addUIHandler(JavascriptObject obj, UIEventType type, GFXEventHandler h) {
        String key = this.registerEventHandler(h);
        String mcall = "google.maps.event.addListener(" + obj.getVariableName() + ", '" + type.name() + "', " + "function(event) {document.jsHandlers.handleUIEvent('" + key + "', event);});";
        this.runtime.execute(mcall);
    }

    public void addStateEventHandler(MapStateEventType type, StateEventHandler h) {
        String key = this.registerEventHandler(h);
        String mcall = "google.maps.event.addListener(" + this.getVariableName() + ", '" + type.name() + "', " + "function() {document.jsHandlers.handleStateEvent('" + key + "');});";
        this.runtime.execute(mcall);
    }
}

