/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx.javascript.object;

import com.lynden.gmapsfx.javascript.JavascriptObject;
import com.lynden.gmapsfx.javascript.event.EventHandlers;
import com.lynden.gmapsfx.javascript.event.GFXEventHandler;
import com.lynden.gmapsfx.javascript.event.MapStateEventType;
import com.lynden.gmapsfx.javascript.event.StateEventHandler;
import com.lynden.gmapsfx.javascript.event.UIEventHandler;
import com.lynden.gmapsfx.javascript.event.UIEventType;
import com.lynden.gmapsfx.javascript.object.GMapPoint;
import com.lynden.gmapsfx.javascript.object.LatLong;
import com.lynden.gmapsfx.javascript.object.LatLongBounds;
import com.lynden.gmapsfx.javascript.object.MapOptions;
import com.lynden.gmapsfx.javascript.object.MapShape;
import com.lynden.gmapsfx.javascript.object.MapTypeIdEnum;
import com.lynden.gmapsfx.javascript.object.Marker;
import com.lynden.gmapsfx.javascript.object.Projection;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.geometry.Point2D;
import netscape.javascript.JSObject;

public class DirectionsPane
extends JavascriptObject {
    private boolean userPromptedZoomChange;
    private boolean mapPromptedZoomChange;
    protected MapOptions options;
    protected static String divArg = "document.getElementById('directions')";
    private ReadOnlyObjectWrapper<LatLong> center;
    private IntegerProperty zoom;
    private final EventHandlers jsHandlers = new EventHandlers();
    private boolean registeredOnJS;

    public DirectionsPane() {
        super("google.maps.Node", divArg);
    }

    public DirectionsPane(MapOptions mapOptions) {
        super("google.maps.Node", divArg, mapOptions);
    }

    public void setZoom(int zoom) {
        this.zoomProperty().set(zoom);
    }

    public int getZoom() {
        return this.zoomProperty().get();
    }

    private int internalGetZoom() {
        return (Integer)this.invokeJavascript("getZoom");
    }

    private void internalSetZoom(int zoom) {
        this.invokeJavascript("setZoom", zoom);
    }

    public IntegerProperty zoomProperty() {
        if (this.zoom == null) {
            this.zoom = new SimpleIntegerProperty(this.internalGetZoom());
            this.addStateEventHandler(MapStateEventType.zoom_changed, () -> {
                if (!this.userPromptedZoomChange) {
                    this.mapPromptedZoomChange = true;
                    this.zoom.set(this.internalGetZoom());
                    this.mapPromptedZoomChange = false;
                }
            });
            this.zoom.addListener((obs, o, n) -> {
                if (!this.mapPromptedZoomChange) {
                    this.userPromptedZoomChange = true;
                    this.internalSetZoom(n.intValue());
                    this.userPromptedZoomChange = false;
                }
            });
        }
        return this.zoom;
    }

    public void setCenter(LatLong latLong) {
        this.invokeJavascript("setCenter", latLong);
    }

    public LatLong getLatLong() {
        return this.getProperty("setCenter", LatLong.class);
    }

    public void fitBounds(LatLongBounds bounds) {
        this.invokeJavascript("fitBounds", bounds);
    }

    public final ReadOnlyObjectProperty<LatLong> centerProperty() {
        if (this.center == null) {
            this.center = new ReadOnlyObjectWrapper((Object)this.getCenter());
            this.addStateEventHandler(MapStateEventType.center_changed, () -> this.center.set((Object)this.getCenter()));
        }
        return this.center.getReadOnlyProperty();
    }

    public LatLong getCenter() {
        return new LatLong((JSObject)this.invokeJavascript("getCenter"));
    }

    public void setHeading(double heading) {
        this.invokeJavascript("setHeading", heading);
    }

    public double getHeading() {
        return this.invokeJavascriptReturnValue("getHeading", Double.class);
    }

    public void removeMarker(Marker marker) {
        marker.setMap(null);
    }

    public void setMapType(MapTypeIdEnum type) {
        this.invokeJavascript("setMapTypeId", type);
    }

    public void removeMapShape(MapShape shape) {
        shape.setMap(null);
    }

    public Projection getProjection() {
        Object obj = this.invokeJavascript("getProjection");
        return obj == null ? null : new Projection((JSObject)obj);
    }

    public LatLongBounds getBounds() {
        return this.invokeJavascriptReturnValue("getBounds", LatLongBounds.class);
    }

    public Point2D fromLatLngToPoint(LatLong loc) {
        Projection proj = this.getProjection();
        LatLongBounds llb = this.getBounds();
        GMapPoint topRight = proj.fromLatLngToPoint(llb.getNorthEast());
        GMapPoint bottomLeft = proj.fromLatLngToPoint(llb.getSouthWest());
        double scale = Math.pow(2.0, this.getZoom());
        GMapPoint worldPoint = proj.fromLatLngToPoint(loc);
        double x = (worldPoint.getX() - bottomLeft.getX()) * scale;
        double y = (worldPoint.getY() - topRight.getY()) * scale;
        return new Point2D(x, y);
    }

    public void panBy(double x, double y) {
        this.invokeJavascript("panBy", x, y);
    }

    private String registerEventHandler(GFXEventHandler h) {
        if (!this.registeredOnJS) {
            JSObject doc = this.runtime.execute("document");
            doc.setMember("jsHandlers", this.jsHandlers);
            this.registeredOnJS = true;
        }
        return this.jsHandlers.registerHandler(h);
    }

    public void addUIEventHandler(UIEventType type, UIEventHandler h) {
        this.addUIEventHandler(this, type, h);
    }

    public void addUIEventHandler(JavascriptObject obj, UIEventType type, UIEventHandler h) {
        String key = this.registerEventHandler(h);
        String mcall = "google.maps.event.addListener(" + obj.getVariableName() + ", '" + type.name() + "', " + "function(event) {document.jsHandlers.handleUIEvent('" + key + "', event);});";
        this.runtime.execute(mcall);
    }

    public void addStateEventHandler(MapStateEventType type, StateEventHandler h) {
        String key = this.registerEventHandler(h);
        String mcall = "google.maps.event.addListener(" + this.getVariableName() + ", '" + type.name() + "', " + "function() {document.jsHandlers.handleStateEvent('" + key + "');});";
        this.runtime.execute(mcall);
    }
}

