/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx.javascript;

import com.lynden.gmapsfx.javascript.IJavascriptRuntime;
import com.lynden.gmapsfx.javascript.JavascriptEnum;
import com.lynden.gmapsfx.javascript.JavascriptRuntime;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.WeakHashMap;
import netscape.javascript.JSObject;

public class JavascriptObject {
    protected static Map<JSObject, JavascriptObject> peerRegistry = new WeakHashMap<JSObject, JavascriptObject>();
    protected IJavascriptRuntime runtime = JavascriptRuntime.getInstance();
    protected JSObject jsObject;
    protected static int objectCounter = 0;
    protected String variableName = this.getNextVariableName();

    protected JavascriptObject() {
    }

    protected JavascriptObject(String type) {
        this(type, (Object[])null);
    }

    protected JavascriptObject(String type, String stringRepresentation) {
        this.runtime.execute("var " + this.variableName + " = " + stringRepresentation);
        this.jsObject = this.runtime.execute(this.variableName);
        peerRegistry.put(this.jsObject, this);
    }

    protected JavascriptObject(String type, Object ... args) {
        this.runtime.execute("var " + this.variableName + " = " + this.runtime.getConstructor(type, args));
        this.jsObject = this.runtime.execute(this.variableName);
        peerRegistry.put(this.jsObject, this);
    }

    protected JavascriptObject(String type, Object[] ary, boolean isArray) {
        this.runtime.execute("var " + this.variableName + " = " + this.runtime.getArrayConstructor(type, ary));
        this.jsObject = this.runtime.execute(this.variableName);
        peerRegistry.put(this.jsObject, this);
    }

    protected JavascriptObject(String type, JSObject jsObject) {
        this.jsObject = jsObject;
        peerRegistry.put(jsObject, this);
    }

    public JSObject getJSObject() {
        return this.jsObject;
    }

    protected final String getNextVariableName() {
        return this.getClass().getSimpleName() + objectCounter++;
    }

    public String getVariableName() {
        return this.variableName;
    }

    protected void setProperty(String propertyName, Object propertyValue) {
        this.jsObject.setMember(propertyName, propertyValue);
    }

    protected void setProperty(String propertyName, JavascriptObject propertyValue) {
        this.jsObject.setMember(propertyName, propertyValue.getJSObject());
    }

    protected void setProperty(String propertyName, JavascriptEnum propertyValue) {
        this.jsObject.setMember(propertyName, propertyValue.getEnumValue());
    }

    protected Object getProperty(String key) {
        return this.checkUndefined(this.jsObject.getMember(key));
    }

    protected <T> T getProperty(String key, Class<T> type) {
        Object returnValue = this.getProperty(key);
        if (returnValue != null) {
            return (T)returnValue;
        }
        return null;
    }

    protected Object invokeJavascript(String function) {
        return this.checkUndefined(this.jsObject.call(function, new Object[0]));
    }

    protected Object invokeJavascript(String function, Object ... args) {
        Object[] jsArgs = new Object[args.length];
        for (int i = 0; i < jsArgs.length; ++i) {
            jsArgs[i] = args[i] instanceof JavascriptObject ? ((JavascriptObject)args[i]).getJSObject() : (args[i] instanceof JavascriptEnum ? ((JavascriptEnum)args[i]).getEnumValue() : args[i]);
        }
        return this.checkUndefined(this.jsObject.call(function, jsArgs));
    }

    protected <T> T invokeJavascriptReturnValue(String function, Class<T> returnType) {
        Object returnObject = this.invokeJavascript(function);
        if (returnObject instanceof JSObject) {
            try {
                Constructor<T> constructor = returnType.getConstructor(JSObject.class);
                return constructor.newInstance((JSObject)returnObject);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return (T)returnObject;
    }

    protected <T> T invokeJavascriptReturnValue(String function, Class<T> returnType, Object ... args) {
        Object returnObject = this.invokeJavascript(function, args);
        if (returnObject != null) {
            return (T)returnObject;
        }
        return null;
    }

    protected boolean isMemberDefined(String member) {
        Object res = this.jsObject.getMember(member);
        return res instanceof String && !((String)res).equals("undefined");
    }

    protected Object checkUndefined(Object val) {
        if (val instanceof String && ((String)val).equals("undefined")) {
            return null;
        }
        return val;
    }

    protected Boolean checkBoolean(Object val, Boolean def) {
        return val == null ? def : (Boolean)val;
    }

    protected Integer checkInteger(Object val, Integer def) {
        return val == null ? def : (Integer)val;
    }
}

