/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx;

import com.lynden.gmapsfx.GoogleMapView;
import com.lynden.gmapsfx.MapComponentInitializedListener;
import com.lynden.gmapsfx.javascript.object.DirectionsPane;
import com.lynden.gmapsfx.javascript.object.GoogleMap;
import com.lynden.gmapsfx.javascript.object.LatLong;
import com.lynden.gmapsfx.javascript.object.MapOptions;
import com.lynden.gmapsfx.javascript.object.MapTypeIdEnum;
import com.lynden.gmapsfx.javascript.object.Marker;
import com.lynden.gmapsfx.javascript.object.MarkerOptions;
import com.lynden.gmapsfx.service.directions.DirectionStatus;
import com.lynden.gmapsfx.service.directions.DirectionsRenderer;
import com.lynden.gmapsfx.service.directions.DirectionsResult;
import com.lynden.gmapsfx.service.directions.DirectionsServiceCallback;
import com.lynden.gmapsfx.service.elevation.ElevationResult;
import com.lynden.gmapsfx.service.elevation.ElevationServiceCallback;
import com.lynden.gmapsfx.service.elevation.ElevationStatus;
import com.lynden.gmapsfx.service.geocoding.GeocoderStatus;
import com.lynden.gmapsfx.service.geocoding.GeocodingResult;
import com.lynden.gmapsfx.service.geocoding.GeocodingService;
import com.lynden.gmapsfx.service.geocoding.GeocodingServiceCallback;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class MainApp2
extends Application
implements MapComponentInitializedListener,
ElevationServiceCallback,
GeocodingServiceCallback,
DirectionsServiceCallback {
    protected GoogleMapView mapComponent;
    protected GoogleMap map;
    protected DirectionsPane directions;
    private Button btnZoomIn;
    private Button btnZoomOut;
    private Label lblZoom;
    private Label lblCenter;
    private Label lblClick;
    private ComboBox<MapTypeIdEnum> mapTypeCombo;
    private MarkerOptions markerOptions2;
    private Marker myMarker2;
    private Button btnHideMarker;
    private Button btnDeleteMarker;
    DirectionsRenderer renderer;

    public void start(Stage stage) throws Exception {
        this.mapComponent = new GoogleMapView();
        this.mapComponent.addMapInializedListener(this);
        this.mapComponent.setDisableDoubleClick(true);
        this.mapComponent.getWebview().getEngine().setOnAlert(event -> {});
        BorderPane bp = new BorderPane();
        bp.setCenter((Node)this.mapComponent);
        Scene scene = new Scene((Parent)bp);
        stage.setScene(scene);
        stage.show();
    }

    @Override
    public void mapInitialized() {
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(3000L);
                System.out.println("Calling showDirections from Java");
                Platform.runLater(() -> this.mapComponent.getMap().hideDirectionsPane());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        t.start();
        LatLong center = new LatLong(47.606189, -122.335842);
        this.mapComponent.addMapReadyListener(() -> this.checkCenter(center));
        MapOptions options = new MapOptions();
        options.center(center).mapMarker(true).zoom(9.0).overviewMapControl(false).panControl(false).rotateControl(false).scaleControl(false).streetViewControl(false).zoomControl(false).mapType(MapTypeIdEnum.TERRAIN);
        this.map = this.mapComponent.createMap(options);
        this.map.setHeading(123.2);
    }

    private void hideMarker() {
        boolean visible = this.myMarker2.getVisible();
        this.myMarker2.setVisible(!visible);
    }

    private void deleteMarker() {
        this.map.removeMarker(this.myMarker2);
    }

    private void checkCenter(LatLong center) {
    }

    public static void main(String[] args) {
        System.setProperty("java.net.useSystemProxies", "true");
        MainApp2.launch((String[])args);
    }

    @Override
    public void elevationsReceived(ElevationResult[] results, ElevationStatus status) {
        if (status.equals((Object)ElevationStatus.OK)) {
            for (ElevationResult e : results) {
                System.out.println(" Elevation on " + e.getLocation().toString() + " is " + e.getElevation());
            }
        }
    }

    @Override
    public void geocodedResultsReceived(GeocodingResult[] results, GeocoderStatus status) {
        if (status.equals((Object)GeocoderStatus.OK)) {
            for (GeocodingResult e : results) {
                System.out.println(e.getVariableName());
                System.out.println("GEOCODE: " + e.getFormattedAddress() + "\n" + e.toString());
            }
        }
    }

    @Override
    public void directionsReceived(DirectionsResult results, DirectionStatus status) {
        if (status.equals((Object)DirectionStatus.OK)) {
            System.out.println("OK");
            DirectionsResult e = results;
            GeocodingService gs = new GeocodingService();
            System.out.println("SIZE ROUTES: " + e.getRoutes().size() + "\n" + "ORIGIN: " + e.getRoutes().get(0).getLegs().get(0).getStartLocation());
            System.out.println("LEGS SIZE: " + e.getRoutes().get(0).getLegs().size());
            System.out.println("WAYPOINTS " + e.getGeocodedWaypoints().size());
            try {
                System.out.println("Distancia total = " + e.getRoutes().get(0).getLegs().get(0).getDistance().getText());
            }
            catch (Exception ex) {
                System.out.println("ERRO: " + ex.getMessage());
            }
            System.out.println("LEG(0)");
            System.out.println(e.getRoutes().get(0).getLegs().get(0).getSteps().size());
            System.out.println(this.renderer.toString());
        }
    }
}

