/*
 * Decompiled with CFR 0.152.
 */
package com.lusfold.spinnerloading;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.lusfold.spinnerloading.Animation.CallbackAnimation;
import com.lusfold.spinnerloading.Circle;
import com.lusfold.spinnerloading.utils.SpinnerLoadingUtils;
import java.util.ArrayList;

public class SpinnerLoading
extends View
implements CallbackAnimation.TransformationListener {
    public static final int DEFAULT_DURATION = 1200;
    public static final int DEFAULT_itemCount = 8;
    public static final int DEFAULT_CIRCLE_COLOR = -13391873;
    public static final int DEFAULT_CIRCLE_COLOR_OUT = -2144098305;
    public static final float DEFAULT_SCALE_RATE = 0.2f;
    public static final int DEFAULT_RADIUS = 20;
    public static final int DEFAULT_WIDTH_FACTOR = 14;
    public static final int DEFAULT_WIDTH_PADDING_FACTOR = 2;
    private int itemCount = 8;
    private Paint paint = new Paint();
    private float handle_len_rate = 2.0f;
    private float radius = 20.0f;
    private final float SCALE_RATE = 0.2f;
    private ArrayList<Circle> circlePaths = new ArrayList();
    private float mInterpolatedTime;
    private CallbackAnimation callbackAnimation;
    private float width;
    private float preFac1;
    private float preFac2;
    private float pi2;

    public SpinnerLoading(Context context) {
        super(context);
        this.init();
    }

    public SpinnerLoading(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SpinnerLoading(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @Override
    public void onApplyTrans(float interpolatedTime) {
        this.mInterpolatedTime = interpolatedTime;
        this.invalidate();
    }

    private void init() {
        this.pi2 = 1.5707964f;
        this.paint.setColor(-13391873);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        this.reMakeFactors();
    }

    private void drawSpinner(Canvas canvas, int j, int i, float v, float handle_len_rate, float maxDistance) {
        float u2;
        float u1;
        Circle circle1 = this.circlePaths.get(i);
        Circle circle2 = this.circlePaths.get(j);
        float[] center1 = circle1.center;
        float[] center2 = circle2.center;
        float radius1 = circle1.radius;
        float radius2 = circle2.radius;
        float d = SpinnerLoadingUtils.getDistance(center1, center2);
        if (d < maxDistance) {
            float scale2 = 1.0f + 0.2f * (1.0f - d / maxDistance);
            radius2 *= scale2;
        }
        if (radius1 == 0.0f || radius2 == 0.0f) {
            return;
        }
        if (j == 1) {
            this.paint.setShader((Shader)new RadialGradient(center1[0], center1[1], this.radius * 2.0f, -2144098305, 0, Shader.TileMode.CLAMP));
            canvas.drawCircle(center1[0], center1[1], radius1 * 3.0f, this.paint);
            this.paint.setShader(null);
            canvas.drawCircle(center1[0], center1[1], radius1, this.paint);
        }
        canvas.drawCircle(center2[0], center2[1], radius2, this.paint);
        if (d > maxDistance || d <= Math.abs(radius1 - radius2)) {
            return;
        }
        if (d < radius1 + radius2) {
            u1 = (float)Math.acos((radius1 * radius1 + d * d - radius2 * radius2) / (2.0f * radius1 * d));
            u2 = (float)Math.acos((radius2 * radius2 + d * d - radius1 * radius1) / (2.0f * radius2 * d));
        } else {
            u1 = 0.0f;
            u2 = 0.0f;
        }
        float[] centermin = new float[]{center2[0] - center1[0], center2[1] - center1[1]};
        float angle1 = (float)Math.atan2(centermin[1], centermin[0]);
        float angle2 = (float)Math.acos((radius1 - radius2) / d);
        float angle1a = angle1 + u1 + (angle2 - u1) * v;
        float angle1b = angle1 - u1 - (angle2 - u1) * v;
        float angle2a = (float)((double)angle1 + Math.PI - (double)u2 - (Math.PI - (double)u2 - (double)angle2) * (double)v);
        float angle2b = (float)((double)angle1 - Math.PI + (double)u2 + (Math.PI - (double)u2 - (double)angle2) * (double)v);
        float[] p1a1 = SpinnerLoadingUtils.getVector(angle1a, radius1);
        float[] p1b1 = SpinnerLoadingUtils.getVector(angle1b, radius1);
        float[] p2a1 = SpinnerLoadingUtils.getVector(angle2a, radius2);
        float[] p2b1 = SpinnerLoadingUtils.getVector(angle2b, radius2);
        float[] p1a = new float[]{p1a1[0] + center1[0], p1a1[1] + center1[1]};
        float[] p1b = new float[]{p1b1[0] + center1[0], p1b1[1] + center1[1]};
        float[] p2a = new float[]{p2a1[0] + center2[0], p2a1[1] + center2[1]};
        float[] p2b = new float[]{p2b1[0] + center2[0], p2b1[1] + center2[1]};
        float[] p1_p2 = new float[]{p1a[0] - p2a[0], p1a[1] - p2a[1]};
        float totalRadius = radius1 + radius2;
        float d2 = Math.min(v * handle_len_rate, SpinnerLoadingUtils.getLength(p1_p2) / totalRadius);
        d2 *= Math.min(1.0f, d * 2.0f / (radius1 + radius2));
        float[] sp1 = SpinnerLoadingUtils.getVector(angle1a - this.pi2, radius1 *= d2);
        float[] sp2 = SpinnerLoadingUtils.getVector(angle2a + this.pi2, radius2 *= d2);
        float[] sp3 = SpinnerLoadingUtils.getVector(angle2b - this.pi2, radius2);
        float[] sp4 = SpinnerLoadingUtils.getVector(angle1b + this.pi2, radius1);
        Path path1 = new Path();
        path1.moveTo(p1a[0], p1a[1]);
        path1.cubicTo(p1a[0] + sp1[0], p1a[1] + sp1[1], p2a[0] + sp2[0], p2a[1] + sp2[1], p2a[0], p2a[1]);
        path1.lineTo(p2b[0], p2b[1]);
        path1.cubicTo(p2b[0] + sp3[0], p2b[1] + sp3[1], p1b[0] + sp4[0], p1b[1] + sp4[1], p1b[0], p1b[1]);
        path1.lineTo(p1a[0], p1a[1]);
        path1.close();
        canvas.drawPath(path1, this.paint);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.circlePaths.get((int)0).center[0] = (float)((double)this.preFac1 + (double)this.preFac2 * Math.cos(Math.PI * 2 * (double)this.mInterpolatedTime));
        this.circlePaths.get((int)0).center[1] = (float)((double)this.preFac1 + (double)this.preFac2 * Math.sin(Math.PI * 2 * (double)this.mInterpolatedTime));
        int l = this.circlePaths.size();
        for (int i = 1; i < l; ++i) {
            this.drawSpinner(canvas, i, 0, 0.6f, this.handle_len_rate, this.radius * 3.0f);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)(this.radius * 14.0f)), (int)0x40000000);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)(this.radius * 14.0f)), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void stopAnimation() {
        this.clearAnimation();
        this.postInvalidate();
    }

    private void startAnimation() {
        if (this.callbackAnimation == null) {
            this.callbackAnimation = new CallbackAnimation(this);
            this.callbackAnimation.setDuration(1200L);
            this.callbackAnimation.setInterpolator((Interpolator)new LinearInterpolator());
            this.callbackAnimation.setRepeatCount(-1);
        }
        this.startAnimation(this.callbackAnimation);
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 8 || visibility == 4) {
            this.stopAnimation();
        } else {
            this.startAnimation();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAnimation();
    }

    protected void onDetachedFromWindow() {
        this.stopAnimation();
        super.onDetachedFromWindow();
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public void setCircleRadius(int radius) {
        this.radius = radius;
        this.reMakeFactors();
    }

    public void setPaintMode(int mode) {
        this.paint.setStyle(mode == 0 ? Paint.Style.STROKE : Paint.Style.FILL);
    }

    private void reMakeFactors() {
        this.circlePaths.clear();
        this.width = this.radius * 14.0f;
        this.preFac1 = this.radius * 7.0f;
        this.preFac2 = this.preFac1 - this.radius * 2.0f;
        Circle circlePath = new Circle();
        circlePath.center = new float[]{this.radius * 12.0f, this.radius * 14.0f / 2.0f};
        circlePath.radius = this.radius / 4.0f * 3.0f;
        this.circlePaths.add(circlePath);
        for (int i = 1; i <= this.itemCount; ++i) {
            circlePath = new Circle();
            circlePath.center = new float[]{(float)((double)this.preFac1 + (double)this.preFac2 * Math.cos(Math.PI * 2 * (double)i / (double)this.itemCount)), (float)((double)this.preFac1 + (double)this.preFac2 * Math.sin(Math.PI * 2 * (double)i / (double)this.itemCount))};
            circlePath.radius = this.radius;
            this.circlePaths.add(circlePath);
        }
    }
}

