/*
 * Decompiled with CFR 0.152.
 */
package com.lusfold.androidkeyvaluestore.core;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.lusfold.androidkeyvaluestore.core.KVManger;
import com.lusfold.androidkeyvaluestore.exception.KVStoreKeyNullException;
import com.lusfold.androidkeyvaluestore.exception.KVStoreValueNullException;
import com.lusfold.androidkeyvaluestore.utils.CursorUtils;
import com.lusfold.androidkeyvaluestore.utils.LogUtils;
import com.lusfold.androidkeyvaluestore.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class KVManagerImpl
implements KVManger {
    private static final String TAG = "KVManagerImpl";
    public static final String COLUMN_KEY = "Key";
    public static final String COLUMN_VALUE = "Value";
    public static final String TABLE_NAME = "KVStore";
    private static final String SQL_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS ? (? TEXT PRIMARY KEY NOT NULL,? TEXT NOT NULL)";
    private static final String SQL_QUERY_TABLE = "SELECT COUNT(*) AS c FROM sqlite_master WHERE type='table' AND name= '?'";
    private static final String SQL_DELETE_TABLE = "DELETE FROM ?";
    private static final String SQL_QUERY_DATA = "SELECT * FROM ? WHERE ? = '?'";
    private static final String SQL_QUERY_DATA_PREFIX = "SELECT * FROM ? WHERE ? LIKE '?%'";
    private static final String SQL_QUERY_DATA_CONTAINS = "SELECT * FROM ? WHERE ? LIKE '%?%'";
    private SQLiteDatabase database;

    public KVManagerImpl(SQLiteDatabase database) {
        this.database = database;
        if (!this.isTableExist()) {
            this.createKVTable();
        }
    }

    private void createKVTable() {
        this.execNonQuery(SQL_CREATE_TABLE, new String[]{TABLE_NAME, COLUMN_KEY, COLUMN_VALUE});
    }

    private void deleteKVTable() {
        this.execNonQuery(SQL_DELETE_TABLE, new String[]{TABLE_NAME});
    }

    private boolean isTableExist() {
        int count;
        Cursor cursor = this.execQuery(SQL_QUERY_TABLE, new String[]{TABLE_NAME});
        return cursor != null && cursor.moveToNext() && (count = cursor.getInt(0)) > 0;
    }

    @Override
    public Cursor execQuery(String sql, String[] selectionArgs) {
        int count = selectionArgs.length;
        for (int i = 0; i < count; ++i) {
            sql = sql.replaceFirst("[?]", selectionArgs[i]);
        }
        LogUtils.d(sql);
        return this.database.rawQuery(sql, null);
    }

    @Override
    public void execNonQuery(String sql, String[] selectionArgs) {
        int count = selectionArgs.length;
        for (int i = 0; i < count; ++i) {
            sql = sql.replaceFirst("[?]", selectionArgs[i]);
        }
        LogUtils.d(sql);
        this.database.execSQL(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyExists(String key) {
        if (StringUtils.isNull(key)) {
            throw new KVStoreKeyNullException();
        }
        Cursor cursor = this.execQuery(SQL_QUERY_DATA, new String[]{TABLE_NAME, COLUMN_KEY, key});
        if (cursor != null) {
            try {
                if (cursor.moveToNext()) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                CursorUtils.closeCursorQuietly(cursor);
            }
        }
        return false;
    }

    private void checkKey(String key) {
        if (StringUtils.isNull(key)) {
            throw new KVStoreKeyNullException();
        }
    }

    private void checkValue(String value) {
        if (StringUtils.isNull(value)) {
            throw new KVStoreValueNullException();
        }
    }

    private long doInsert(String key, String value) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(COLUMN_KEY, key);
        contentValues.put(COLUMN_VALUE, value);
        return this.database.insert(TABLE_NAME, null, contentValues);
    }

    private int doUpdate(String key, String value) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(COLUMN_VALUE, value);
        return this.database.update(TABLE_NAME, contentValues, "Key = ?", new String[]{key});
    }

    @Override
    public long insert(String key, String value) {
        this.checkKey(key);
        this.checkValue(value);
        if (this.keyExists(key)) {
            return -1L;
        }
        return this.doInsert(key, value);
    }

    @Override
    public long insertOrUpdate(String key, String value) {
        this.checkKey(key);
        this.checkValue(value);
        if (this.keyExists(key)) {
            return this.doUpdate(key, value);
        }
        return this.doInsert(key, value);
    }

    @Override
    public int update(String key, String value) {
        this.checkKey(key);
        this.checkValue(value);
        if (!this.keyExists(key)) {
            return -1;
        }
        return this.doUpdate(key, value);
    }

    @Override
    public int delete(String key) {
        this.checkKey(key);
        return this.database.delete(TABLE_NAME, "Key = ?", new String[]{key});
    }

    @Override
    public String get(String key) {
        this.checkKey(key);
        Cursor cursor = this.execQuery(SQL_QUERY_DATA, new String[]{TABLE_NAME, COLUMN_KEY, key});
        String result = null;
        if (cursor != null) {
            if (cursor.moveToNext()) {
                result = cursor.getString(1);
            }
            CursorUtils.closeCursorQuietly(cursor);
        }
        return result;
    }

    @Override
    public Map<String, String> getByPrefix(String keyPrefix) {
        this.checkKey(keyPrefix);
        Cursor cursor = this.execQuery(SQL_QUERY_DATA_PREFIX, new String[]{TABLE_NAME, COLUMN_KEY, keyPrefix});
        HashMap<String, String> result = null;
        if (cursor != null) {
            result = new HashMap<String, String>();
            while (cursor.moveToNext()) {
                result.put(cursor.getString(0), cursor.getString(1));
            }
            CursorUtils.closeCursorQuietly(cursor);
        }
        return result;
    }

    @Override
    public Map<String, String> getByContains(String keyContains) {
        this.checkKey(keyContains);
        Cursor cursor = this.execQuery(SQL_QUERY_DATA_CONTAINS, new String[]{TABLE_NAME, COLUMN_KEY, keyContains});
        HashMap<String, String> result = null;
        if (cursor != null) {
            result = new HashMap<String, String>();
            while (cursor.moveToNext()) {
                result.put(cursor.getString(0), cursor.getString(1));
            }
            CursorUtils.closeCursorQuietly(cursor);
        }
        return result;
    }

    @Override
    public void clearTable() {
        this.deleteKVTable();
        this.createKVTable();
    }

    @Override
    public SQLiteDatabase getDatabase() {
        return this.database;
    }

    @Override
    public void setDebug(boolean debug) {
        LogUtils.debug = debug;
    }
}

