/*
 * Decompiled with CFR 0.152.
 */
package com.luojilab.component.componentlib.router.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.luojilab.component.componentlib.router.ui.IComponentRouter;
import com.luojilab.component.componentlib.utils.UriUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseCompRouter
implements IComponentRouter {
    protected Map<String, Class> routeMapper = new HashMap<String, Class>();
    protected Map<Class, Map<String, Integer>> paramsMapper = new HashMap<Class, Map<String, Integer>>();
    protected boolean hasInitMap = false;

    protected abstract String getHost();

    protected void initMap() {
        this.hasInitMap = true;
    }

    @Override
    public boolean openUri(Context context, String url, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)url) || context == null) {
            return true;
        }
        return this.openUri(context, Uri.parse((String)url), bundle, (Integer)0);
    }

    @Override
    public boolean openUri(Context context, Uri uri, Bundle bundle) {
        return this.openUri(context, uri, bundle, (Integer)0);
    }

    @Override
    public boolean openUri(Context context, String url, Bundle bundle, Integer requestCode) {
        if (TextUtils.isEmpty((CharSequence)url) || context == null) {
            return true;
        }
        return this.openUri(context, Uri.parse((String)url), bundle, requestCode);
    }

    @Override
    public boolean openUri(Context context, Uri uri, Bundle bundle, Integer requestCode) {
        if (!this.hasInitMap) {
            this.initMap();
        }
        if (uri == null || context == null) {
            return true;
        }
        String scheme = uri.getScheme();
        String host = uri.getHost();
        if (!this.getHost().equals(host)) {
            return false;
        }
        List pathSegments = uri.getPathSegments();
        String path = "/" + TextUtils.join((CharSequence)"/", (Iterable)pathSegments);
        if (this.routeMapper.containsKey(path)) {
            Class target = this.routeMapper.get(path);
            if (bundle == null) {
                bundle = new Bundle();
            }
            HashMap<String, String> params = UriUtils.parseParams(uri);
            Map<String, Integer> paramsType = this.paramsMapper.get(target);
            UriUtils.setBundleValue(bundle, params, paramsType);
            Intent intent = new Intent(context, target);
            intent.putExtras(bundle);
            if (requestCode > 0 && context instanceof Activity) {
                ((Activity)context).startActivityForResult(intent, requestCode.intValue());
                return true;
            }
            context.startActivity(intent);
            return true;
        }
        return false;
    }

    @Override
    public boolean verifyUri(Uri uri) {
        String host = uri.getHost();
        if (!this.getHost().equals(host)) {
            return false;
        }
        if (!this.hasInitMap) {
            this.initMap();
        }
        List pathSegments = uri.getPathSegments();
        String path = "/" + TextUtils.join((CharSequence)"/", (Iterable)pathSegments);
        return this.routeMapper.containsKey(path);
    }
}

