/*
 * Decompiled with CFR 0.152.
 */
package com.lucasurbas.listitemview.util.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.view.SupportMenuInflater;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuPopupHelper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.lucasurbas.listitemview.R;
import com.lucasurbas.listitemview.util.ViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class MenuView
extends LinearLayout {
    private int mMenuResId = -1;
    private MenuBuilder mMenuBuilder;
    private SupportMenuInflater mMenuInflater;
    private MenuPopupHelper mMenuPopupHelper;
    private MenuBuilder.Callback mMenuCallback;
    private int mActionIconColor;
    private int mOverflowIconColor;
    private List<MenuItemImpl> mMenuItems;
    private List<MenuItemImpl> mActionItems = new ArrayList<MenuItemImpl>();
    private List<MenuItemImpl> mActionShowAlwaysItems = new ArrayList<MenuItemImpl>();
    private boolean mHasOverflow = false;

    public MenuView(Context context) {
        this(context, null);
    }

    public MenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        int color2;
        this.mActionIconColor = color2 = ViewUtils.getDefaultColor(this.getContext());
        this.mOverflowIconColor = color2;
    }

    public void setActionIconColor(int actionColor) {
        this.mActionIconColor = actionColor;
        this.refreshColors();
    }

    public void setOverflowColor(int overflowColor) {
        this.mOverflowIconColor = overflowColor;
        this.refreshColors();
    }

    private void refreshColors() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ViewUtils.setIconColor((ImageView)this.getChildAt(i), this.mActionIconColor);
            if (!this.mHasOverflow || i != this.getChildCount() - 1) continue;
            ViewUtils.setIconColor((ImageView)this.getChildAt(i), this.mOverflowIconColor);
        }
    }

    public void setMenuCallback(MenuBuilder.Callback menuCallback) {
        this.mMenuCallback = menuCallback;
    }

    public void reset(@NonNull MenuBuilder menuBuilder, int menuItemsRoom) {
        this.removeAllViews();
        this.mMenuBuilder = menuBuilder;
        this.mMenuPopupHelper = new MenuPopupHelper(this.getContext(), this.mMenuBuilder, (View)this);
        this.mActionShowAlwaysItems = new ArrayList<MenuItemImpl>();
        this.mActionItems = new ArrayList<MenuItemImpl>();
        this.mMenuItems = new ArrayList<MenuItemImpl>();
        this.mMenuItems = this.mMenuBuilder.getActionItems();
        this.mMenuItems.addAll(this.mMenuBuilder.getNonActionItems());
        Collections.sort(this.mMenuItems, new Comparator<MenuItemImpl>(){

            @Override
            public int compare(MenuItemImpl lhs, MenuItemImpl rhs) {
                return Integer.valueOf(lhs.getOrder()).compareTo(rhs.getOrder());
            }
        });
        List<MenuItemImpl> localActionItems = this.filter(this.mMenuItems, new MenuItemImplPredicate(){

            @Override
            public boolean apply(MenuItemImpl menuItem) {
                return menuItem.getIcon() != null && (menuItem.requiresActionButton() || menuItem.requestsActionButton());
            }
        });
        boolean addOverflowAtTheEnd = false;
        if (localActionItems.size() < this.mMenuItems.size() || menuItemsRoom < localActionItems.size()) {
            addOverflowAtTheEnd = true;
            --menuItemsRoom;
        }
        ArrayList<Integer> actionItemsIds = new ArrayList<Integer>();
        if (menuItemsRoom > 0) {
            for (int i = 0; i < localActionItems.size(); ++i) {
                final MenuItemImpl menuItem = localActionItems.get(i);
                if (menuItem.getIcon() == null) continue;
                ImageView action = this.createActionView();
                action.setImageDrawable(menuItem.getIcon());
                ViewUtils.setIconColor(action, this.mActionIconColor);
                this.addView((View)action);
                this.mActionItems.add(menuItem);
                actionItemsIds.add(menuItem.getItemId());
                action.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (MenuView.this.mMenuCallback != null) {
                            MenuView.this.mMenuCallback.onMenuItemSelected(MenuView.this.mMenuBuilder, (MenuItem)menuItem);
                        }
                    }
                });
                if (--menuItemsRoom == 0) break;
            }
        }
        this.mHasOverflow = addOverflowAtTheEnd;
        if (addOverflowAtTheEnd) {
            ImageView overflowAction = this.getOverflowActionView();
            overflowAction.setImageResource(R.drawable.ic_more_vert_black_24dp);
            ViewUtils.setIconColor(overflowAction, this.mOverflowIconColor);
            this.addView((View)overflowAction);
            overflowAction.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MenuView.this.mMenuPopupHelper.show();
                }
            });
            this.mMenuBuilder.setCallback(this.mMenuCallback);
        }
        Iterator iterator = actionItemsIds.iterator();
        while (iterator.hasNext()) {
            int id2 = (Integer)iterator.next();
            this.mMenuBuilder.removeItem(id2);
        }
        actionItemsIds = null;
    }

    public void reset(int menu, int menuItemsRoom) {
        this.mMenuResId = menu;
        this.removeAllViews();
        if (this.mMenuResId == -1) {
            return;
        }
        MenuBuilder builder = new MenuBuilder(this.getContext());
        this.getMenuInflater().inflate(this.mMenuResId, (Menu)builder);
        this.reset(builder, menuItemsRoom);
    }

    private ImageView createActionView() {
        return (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.liv_action_item_layout, (ViewGroup)this, false);
    }

    private ImageView getOverflowActionView() {
        return (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.liv_action_item_overflow_layout, (ViewGroup)this, false);
    }

    private List<MenuItemImpl> filter(List<MenuItemImpl> target, MenuItemImplPredicate predicate) {
        ArrayList<MenuItemImpl> result = new ArrayList<MenuItemImpl>();
        for (MenuItemImpl element : target) {
            if (!predicate.apply(element)) continue;
            result.add(element);
        }
        return result;
    }

    private MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            this.mMenuInflater = new SupportMenuInflater(this.getContext());
        }
        return this.mMenuInflater;
    }

    private static interface MenuItemImplPredicate {
        public boolean apply(MenuItemImpl var1);
    }
}

