/*
 * Decompiled with CFR 0.152.
 */
package com.lucasurbas.listitemview.util.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.lucasurbas.listitemview.util.ViewUtils;

public class CircularIconView
extends View {
    private Paint mPaint;
    private RectF mRect;
    private Bitmap mMask;
    private Xfermode mXfermode;
    private Drawable mIconDrawable;
    @ColorInt
    private int mCircleColor;
    private boolean mIsMask;

    public CircularIconView(Context context) {
        super(context);
        this.init();
    }

    public CircularIconView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setLayerType(1, null);
        this.mXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mCircleColor = ViewUtils.getDefaultColor(this.getContext());
        this.mIsMask = true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mRect = new RectF(0.0f, 0.0f, (float)w, (float)h);
        this.swapBitmapMask(this.makeBitmapMask(this.mIconDrawable));
    }

    protected void onDraw(Canvas canvas) {
        if (canvas.getHeight() > 0 && canvas.getWidth() > 0 && this.mMask != null) {
            int sc = canvas.save();
            this.mPaint.setColor(this.mCircleColor);
            this.mPaint.setXfermode(null);
            canvas.drawOval(this.mRect, this.mPaint);
            if (this.mIsMask) {
                this.mPaint.setColor(-1);
                this.mPaint.setXfermode(this.mXfermode);
                canvas.drawBitmap(this.mMask, 0.0f, 0.0f, this.mPaint);
            } else {
                this.mIconDrawable.draw(canvas);
            }
            canvas.restoreToCount(sc);
        }
    }

    @Nullable
    private Bitmap makeBitmapMask(@Nullable Drawable drawable2) {
        int mh = this.getMeasuredHeight();
        int mw = this.getMeasuredWidth();
        if (drawable2 != null && mw > 0 && mh > 0) {
            Bitmap mask = Bitmap.createBitmap((int)mw, (int)mh, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(mask);
            int h = drawable2.getIntrinsicHeight();
            int w = drawable2.getIntrinsicWidth();
            drawable2.setBounds((mw - w) / 2, (mh - h) / 2, (mw - w) / 2 + w, (mh - h) / 2 + h);
            drawable2.draw(canvas);
            return mask;
        }
        return null;
    }

    private void swapBitmapMask(@Nullable Bitmap newMask) {
        if (newMask != null) {
            if (this.mMask != null && !this.mMask.isRecycled()) {
                this.mMask.recycle();
            }
            this.mMask = newMask;
        }
    }

    public void setIconDrawable(Drawable iconDrawable) {
        this.mIconDrawable = iconDrawable;
        this.swapBitmapMask(this.makeBitmapMask(iconDrawable));
        this.invalidate();
    }

    public Drawable getIconDrawable() {
        return this.mIconDrawable;
    }

    public void setMask(boolean isMask) {
        this.mIsMask = isMask;
        this.invalidate();
    }

    public void setCircleColor(@ColorInt int circleColor) {
        this.mCircleColor = circleColor;
        this.invalidate();
    }
}

