/*
 * Decompiled with CFR 0.152.
 */
package com.lucasurbas.listitemview.util;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.lucasurbas.listitemview.R;

public class ViewUtils {
    ViewUtils() {
    }

    public static boolean isLaidOut(View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            return view.isLaidOut();
        }
        return view.getWidth() > 0 && view.getHeight() > 0;
    }

    public static void onLaidOut(final View view, final Runnable runnable) {
        if (ViewUtils.isLaidOut(view)) {
            runnable.run();
            return;
        }
        final ViewTreeObserver observer = view.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ViewTreeObserver trueObserver = observer.isAlive() ? observer : view.getViewTreeObserver();
                ViewUtils.removeGlobalLayoutObserver(trueObserver, this);
                runnable.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ColorInt
    public static int getDefaultColor(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{16842808});
        try {
            int n = a.getColor(0, ContextCompat.getColor((Context)context, (int)R.color.liv_gray_active_icon));
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static void setIconColor(ImageView iconHolder, int color2) {
        Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)iconHolder.getDrawable());
        DrawableCompat.setTint((Drawable)wrappedDrawable, (int)color2);
        iconHolder.setImageDrawable(wrappedDrawable);
        iconHolder.invalidate();
    }

    public static float dpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        return dp * metrics.density;
    }

    public static float spToPixel(float sp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)metrics);
    }

    public static void removeGlobalLayoutObserver(ViewTreeObserver observer, ViewTreeObserver.OnGlobalLayoutListener layoutListener) {
        if (Build.VERSION.SDK_INT < 16) {
            observer.removeGlobalOnLayoutListener(layoutListener);
        } else {
            observer.removeOnGlobalLayoutListener(layoutListener);
        }
    }
}

