/*
 * Decompiled with CFR 0.152.
 */
package com.lucasurbas.listitemview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.MenuRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.view.menu.MenuBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.lucasurbas.listitemview.R;
import com.lucasurbas.listitemview.util.ViewUtils;
import com.lucasurbas.listitemview.util.view.CircularIconView;
import com.lucasurbas.listitemview.util.view.MenuView;

public class ListItemView
extends FrameLayout {
    public static final int NULL = -1;
    public static final int MODE_STANDARD = 0;
    public static final int MODE_ICON = 1;
    public static final int MODE_CIRCULAR_ICON = 2;
    public static final int MODE_AVATAR = 3;
    private static final int DEFAULT_MENU_ITEMS_ROOM = 2;
    private static final int SINGLE_LINE_ITEM_HEIGHT_DP = 48;
    private static final int SINGLE_LINE_AVATAR_ITEM_HEIGHT_DP = 56;
    private static final int TWO_LINE_ITEM_HEIGHT_DP = 72;
    private static final int AVATAR_WIDTH_DP = 40;
    private static final int ACTION_ICON_PADDING_DP = 12;
    private static final int ICON_WIDTH_DP = 24;
    private static final int TITLE_LEADING_SP = 24;
    private static final int SUBTITLE_LEADING_SP = 20;
    private LinearLayout mItemLayout;
    private LinearLayout mTextsLayout;
    private TextView mTitleView;
    private TextView mSubtitleView;
    private ImageView mIconView;
    private CircularIconView mCircularIconView;
    private ImageView mAvatarView;
    private MenuView mMenuView;
    @MenuRes
    private int mMenuId = -1;
    private MenuBuilder mMenuBuilder;
    private int mMenuItemsRoom;
    @ColorInt
    private int mMenuActionColor;
    @ColorInt
    private int mMenuOverflowColor;
    private OnMenuItemClickListener mActionMenuItemListener;
    private String mTitle;
    private String mSubtitle;
    private boolean mIsMultiline;
    private int mPaddingEnd;
    private int mPaddingStart;
    private int mPaddingVertical;
    private int mKeyline;
    private boolean mForceKeyline;
    private int mAvatarWidth;
    private int mIconWidth;
    private int mDisplayMode;
    @DrawableRes
    private int mIconResId;
    private Drawable mIconDrawable;
    @ColorInt
    private int mIconColor;
    @ColorInt
    private int mCircularIconColor;
    @ColorInt
    private int mDefaultColor;

    public ListItemView(@NonNull Context context) {
        super(context);
        this.init(null);
    }

    public ListItemView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        ListItemView.inflate((Context)this.getContext(), (int)R.layout.liv_list_item_layout, (ViewGroup)this);
        this.mItemLayout = (LinearLayout)this.findViewById(R.id.item_layout);
        this.mMenuView = (MenuView)this.findViewById(R.id.menu_view);
        this.mTitleView = (TextView)this.findViewById(R.id.title_view);
        this.mSubtitleView = (TextView)this.findViewById(R.id.subtitle_view);
        this.mIconView = (ImageView)this.findViewById(R.id.icon_view);
        this.mTextsLayout = (LinearLayout)this.findViewById(R.id.texts_layout);
        this.mCircularIconView = (CircularIconView)this.findViewById(R.id.circular_icon_view);
        this.mAvatarView = (ImageView)this.findViewById(R.id.avatar_view);
        this.mDefaultColor = ViewUtils.getDefaultColor(this.getContext());
        this.mPaddingEnd = this.getResources().getDimensionPixelSize(R.dimen.liv_padding_end);
        this.mPaddingStart = this.getResources().getDimensionPixelSize(R.dimen.liv_padding_start);
        this.mKeyline = this.getResources().getDimensionPixelSize(R.dimen.liv_keyline);
        this.mAvatarWidth = (int)ViewUtils.dpToPixel(40.0f);
        this.mIconWidth = (int)ViewUtils.dpToPixel(24.0f);
        if (attrs != null) {
            this.applyAttrs(attrs);
        }
        this.setupView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAttrs(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ListItemView);
        try {
            this.mMenuId = a.getResourceId(R.styleable.ListItemView_liv_menu, -1);
            this.mMenuItemsRoom = a.getInteger(R.styleable.ListItemView_liv_menuItemsRoom, 2);
            this.mMenuActionColor = a.getColor(R.styleable.ListItemView_liv_menuActionColor, 0);
            this.mMenuOverflowColor = a.getColor(R.styleable.ListItemView_liv_menuOverflowColor, 0);
            this.mTitle = a.getString(R.styleable.ListItemView_liv_title);
            this.mSubtitle = a.getString(R.styleable.ListItemView_liv_subtitle);
            this.mIsMultiline = a.getBoolean(R.styleable.ListItemView_liv_multiline, false);
            this.mDisplayMode = a.getInt(R.styleable.ListItemView_liv_displayMode, this.mDisplayMode);
            this.mPaddingEnd = a.getDimensionPixelSize(R.styleable.ListItemView_liv_paddingEnd, this.mPaddingEnd);
            this.mPaddingStart = a.getDimensionPixelSize(R.styleable.ListItemView_liv_paddingStart, this.mPaddingStart);
            this.mKeyline = a.getDimensionPixelSize(R.styleable.ListItemView_liv_keyline, this.mKeyline);
            this.mForceKeyline = a.getBoolean(R.styleable.ListItemView_liv_forceKeyline, false);
            int iconDrawableResId = a.getResourceId(R.styleable.ListItemView_liv_icon, -1);
            if (iconDrawableResId != -1) {
                this.mIconDrawable = AppCompatResources.getDrawable((Context)this.getContext(), (int)iconDrawableResId);
            }
            this.mIconColor = a.getColor(R.styleable.ListItemView_liv_iconColor, 0);
            this.mCircularIconColor = a.getColor(R.styleable.ListItemView_liv_circularIconColor, 0);
        }
        finally {
            a.recycle();
        }
    }

    private void setupView() {
        this.assertPadding();
        this.setupTextView(this.mTitleView, (int)ViewUtils.spToPixel(24.0f), 1);
        this.setupTextView(this.mSubtitleView, (int)ViewUtils.spToPixel(20.0f), 1);
        this.setDisplayMode(this.mDisplayMode);
        this.setCircularIconColor(this.mCircularIconColor);
        this.setIconDrawable(this.mIconDrawable);
        this.setMultiline(this.mIsMultiline);
        this.setTitle(this.mTitle);
        this.setSubtitle(this.mSubtitle);
        this.setMenuActionColor(this.mMenuActionColor);
        this.setMenuOverflowColor(this.mMenuOverflowColor);
        this.inflateMenu(this.mMenuId);
        this.addRipple();
    }

    private void assertPadding() {
        switch (this.mDisplayMode) {
            case 2: 
            case 3: {
                if (this.mKeyline - this.mAvatarWidth >= this.mPaddingStart) break;
                throw new IllegalArgumentException("keyline value is to small");
            }
            case 1: {
                if (this.mKeyline - this.mIconWidth >= this.mPaddingStart) break;
                throw new IllegalArgumentException("keyline value is to small");
            }
            default: {
                if (this.mKeyline >= this.mPaddingStart) break;
                throw new IllegalArgumentException("keyline value is to small");
            }
        }
    }

    private boolean useKeyline() {
        return this.mForceKeyline || this.mDisplayMode != 0;
    }

    private void adjustPadding() {
        int paddingEnd = this.mPaddingEnd - (this.isActionMenu() ? (int)ViewUtils.dpToPixel(12.0f) : 0);
        this.mItemLayout.setPaddingRelative(this.useKeyline() ? this.mKeyline : this.mPaddingStart, this.mPaddingVertical, paddingEnd, this.mPaddingVertical);
        ((ViewGroup.MarginLayoutParams)this.mIconView.getLayoutParams()).setMarginStart(this.mPaddingStart);
        ((ViewGroup.MarginLayoutParams)this.mCircularIconView.getLayoutParams()).setMarginStart(this.mPaddingStart);
        ((ViewGroup.MarginLayoutParams)this.mAvatarView.getLayoutParams()).setMarginStart(this.mPaddingStart);
        ViewGroup.MarginLayoutParams textsLayoutParams = (ViewGroup.MarginLayoutParams)this.mTextsLayout.getLayoutParams();
        textsLayoutParams.setMarginEnd(this.isActionMenu() ? (int)ViewUtils.dpToPixel(4.0f) : 0);
        textsLayoutParams.resolveLayoutDirection(textsLayoutParams.getLayoutDirection());
    }

    private void addRipple() {
        int[] attrs = new int[]{R.attr.selectableItemBackground};
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs);
        int backgroundResource = typedArray.getResourceId(0, 0);
        this.setBackgroundResource(backgroundResource);
        typedArray.recycle();
    }

    private void setupTextView(TextView textView, int leading, int step) {
        textView.setIncludeFontPadding(false);
        Paint.FontMetricsInt metrics = textView.getPaint().getFontMetricsInt();
        int extra = leading - metrics.descent + metrics.ascent;
        textView.setLineSpacing((float)extra, 1.0f);
        int alignTopExtra = (step + metrics.ascent % step) % step;
        int alignBottomExtra = (step - metrics.descent % step) % step;
        textView.setPadding(textView.getPaddingLeft(), textView.getPaddingTop() + alignTopExtra, textView.getPaddingRight(), textView.getPaddingBottom() + alignBottomExtra);
    }

    private void setIconDrawable(Drawable iconDrawable) {
        this.mIconDrawable = iconDrawable;
        if (this.mDisplayMode == 1) {
            this.mIconView.setImageDrawable(this.mIconDrawable);
        } else if (this.mDisplayMode == 2) {
            this.mCircularIconView.setIconDrawable(this.mIconDrawable);
        }
        this.setIconColor(this.mIconColor);
        this.adjustPadding();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mIsMultiline) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            int finalHeight = 0;
            finalHeight = this.mTitleView.getVisibility() != 8 && this.mSubtitleView.getVisibility() != 8 ? (int)ViewUtils.dpToPixel(72.0f) : (this.mAvatarView != null && this.mAvatarView.getVisibility() != 8 || this.mCircularIconView.getVisibility() != 8 ? (int)ViewUtils.dpToPixel(56.0f) : (int)ViewUtils.dpToPixel(48.0f));
            super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)finalHeight, (int)0x40000000));
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.menuId = this.mMenuId;
        savedState.menuItemsRoom = this.mMenuItemsRoom;
        savedState.menuActionColor = this.mMenuActionColor;
        savedState.menuOverflowColor = this.mMenuOverflowColor;
        savedState.title = this.mTitle;
        savedState.subtitle = this.mSubtitle;
        savedState.isMultiline = this.mIsMultiline;
        savedState.forceKeyline = this.mForceKeyline;
        savedState.iconColor = this.mIconColor;
        savedState.circularIconColor = this.mCircularIconColor;
        savedState.iconResId = this.mIconResId;
        savedState.displayMode = this.mDisplayMode;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mMenuId = savedState.menuId;
        this.mMenuItemsRoom = savedState.menuItemsRoom;
        this.mMenuActionColor = savedState.menuActionColor;
        this.mMenuOverflowColor = savedState.menuOverflowColor;
        this.mTitle = savedState.title;
        this.mSubtitle = savedState.subtitle;
        this.mIsMultiline = savedState.isMultiline;
        this.mForceKeyline = savedState.forceKeyline;
        this.mIconColor = savedState.iconColor;
        this.mCircularIconColor = savedState.circularIconColor;
        this.mIconResId = savedState.iconResId;
        if (this.mIconResId != 0) {
            this.setIconResId(this.mIconResId);
        }
        this.mDisplayMode = savedState.displayMode;
        this.setupView();
    }

    public void setTitle(String title) {
        this.mTitle = title;
        this.mTitleView.setText((CharSequence)this.mTitle);
        this.mTitleView.setVisibility(TextUtils.isEmpty((CharSequence)this.mTitle) ? 8 : 0);
    }

    public void setTitle(@StringRes int titleResId) {
        this.mTitle = this.getContext().getString(titleResId);
        this.mTitleView.setText((CharSequence)this.mTitle);
        this.mTitleView.setVisibility(TextUtils.isEmpty((CharSequence)this.mTitle) ? 8 : 0);
    }

    public void setSubtitle(String subtitle) {
        this.mSubtitle = subtitle;
        this.mSubtitleView.setText((CharSequence)this.mSubtitle);
        this.mSubtitleView.setVisibility(TextUtils.isEmpty((CharSequence)this.mSubtitle) ? 8 : 0);
    }

    public void setSubtitle(@StringRes int subtitleResId) {
        this.mSubtitle = this.getContext().getString(subtitleResId);
        this.mSubtitleView.setText((CharSequence)this.mSubtitle);
        this.mSubtitleView.setVisibility(TextUtils.isEmpty((CharSequence)this.mSubtitle) ? 8 : 0);
    }

    public void setMenu(MenuBuilder menuBuilder) {
        this.mMenuBuilder = menuBuilder;
        this.mMenuId = -1;
        this.mMenuView.setMenuCallback(new MenuBuilder.Callback(){

            public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
                if (ListItemView.this.mActionMenuItemListener != null) {
                    ListItemView.this.mActionMenuItemListener.onActionMenuItemSelected(item);
                }
                return true;
            }

            public void onMenuModeChange(MenuBuilder menu) {
            }
        });
        this.mMenuView.reset(menuBuilder, this.mMenuItemsRoom);
        this.adjustPadding();
    }

    public void inflateMenu(@MenuRes int menuId) {
        this.mMenuId = menuId;
        this.mMenuBuilder = null;
        this.mMenuView.setMenuCallback(new MenuBuilder.Callback(){

            public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
                if (ListItemView.this.mActionMenuItemListener != null) {
                    ListItemView.this.mActionMenuItemListener.onActionMenuItemSelected(item);
                }
                return true;
            }

            public void onMenuModeChange(MenuBuilder menu) {
            }
        });
        this.mMenuView.reset(menuId, this.mMenuItemsRoom);
        this.adjustPadding();
    }

    public void setMenuItemsRoom(int menuItemsRoom) {
        this.mMenuItemsRoom = menuItemsRoom;
        this.mMenuView.reset(this.mMenuId, this.mMenuItemsRoom);
        this.adjustPadding();
    }

    public void setMultiline(boolean isMultiline) {
        this.mIsMultiline = isMultiline;
        if (isMultiline) {
            this.mPaddingVertical = (int)ViewUtils.dpToPixel(4.0f);
            this.mItemLayout.setGravity(48);
            ((FrameLayout.LayoutParams)this.mIconView.getLayoutParams()).gravity = 48;
            ((FrameLayout.LayoutParams)this.mCircularIconView.getLayoutParams()).gravity = 48;
            ((FrameLayout.LayoutParams)this.mAvatarView.getLayoutParams()).gravity = 48;
            this.mTitleView.setMaxLines(Integer.MAX_VALUE);
            this.mSubtitleView.setMaxLines(Integer.MAX_VALUE);
        } else {
            this.mPaddingVertical = 0;
            this.mItemLayout.setGravity(16);
            ((FrameLayout.LayoutParams)this.mIconView.getLayoutParams()).gravity = 8388627;
            ((FrameLayout.LayoutParams)this.mCircularIconView.getLayoutParams()).gravity = 8388627;
            ((FrameLayout.LayoutParams)this.mAvatarView.getLayoutParams()).gravity = 8388627;
            this.mTitleView.setMaxLines(1);
            this.mSubtitleView.setMaxLines(1);
        }
        this.adjustPadding();
    }

    public void forceKeyline(boolean forceKeyline) {
        this.mForceKeyline = forceKeyline;
        this.adjustPadding();
    }

    public void setDisplayMode(int displayMode) {
        this.mDisplayMode = displayMode;
        switch (this.mDisplayMode) {
            case 1: {
                this.mIconView.setVisibility(0);
                this.mCircularIconView.setVisibility(8);
                this.mAvatarView.setVisibility(8);
                break;
            }
            case 2: {
                this.mIconView.setVisibility(8);
                this.mCircularIconView.setVisibility(0);
                this.mAvatarView.setVisibility(8);
                break;
            }
            case 3: {
                this.mIconView.setVisibility(8);
                this.mCircularIconView.setVisibility(8);
                this.mAvatarView.setVisibility(0);
                break;
            }
            default: {
                this.mIconView.setVisibility(8);
                this.mCircularIconView.setVisibility(8);
                this.mAvatarView.setVisibility(8);
            }
        }
        this.adjustPadding();
    }

    public void setIconResId(@DrawableRes int iconResId) {
        this.mIconResId = iconResId;
        this.setIconDrawable(this.mIconResId != -1 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)this.mIconResId) : null);
    }

    public void setIconColor(@ColorInt int iconColor) {
        this.mIconColor = iconColor;
        if (this.mDisplayMode == 1 && this.mIconView.getDrawable() != null) {
            ViewUtils.setIconColor(this.mIconView, Color.alpha((int)this.mIconColor) == 0 ? this.mDefaultColor : this.mIconColor);
        } else if (this.mDisplayMode == 2 && this.mCircularIconView.getIconDrawable() != null) {
            this.mCircularIconView.setMask(Color.alpha((int)this.mIconColor) == 0);
            Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)this.mCircularIconView.getIconDrawable());
            DrawableCompat.setTint((Drawable)wrappedDrawable, (int)(Color.alpha((int)this.mIconColor) == 0 ? -1 : this.mIconColor));
            this.mCircularIconView.setIconDrawable(wrappedDrawable);
        }
    }

    public void setCircularIconColor(@ColorInt int circularIconColor) {
        this.mCircularIconColor = Color.alpha((int)circularIconColor) == 0 ? this.mDefaultColor : circularIconColor;
        this.mCircularIconView.setCircleColor(this.mCircularIconColor);
    }

    public void setMenuActionColor(@ColorInt int menuActionColor) {
        this.mMenuActionColor = Color.alpha((int)menuActionColor) == 0 ? this.mDefaultColor : menuActionColor;
        this.mMenuView.setActionIconColor(this.mMenuActionColor);
    }

    public void setMenuOverflowColor(@ColorInt int overflowColor) {
        this.mMenuOverflowColor = Color.alpha((int)overflowColor) == 0 ? this.mDefaultColor : overflowColor;
        this.mMenuView.setOverflowColor(this.mMenuOverflowColor);
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mActionMenuItemListener = listener;
    }

    public int getDisplayMode() {
        return this.mDisplayMode;
    }

    public boolean isActionMenu() {
        return this.mMenuId != -1;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getSubtitle() {
        return this.mSubtitle;
    }

    public int getMenuItemsRoom() {
        return this.mMenuItemsRoom;
    }

    @ColorInt
    public int getIconColor() {
        return this.mIconColor;
    }

    @ColorInt
    public int getCircularIconColor() {
        return this.mCircularIconColor;
    }

    @ColorInt
    public int getMenuActionColor() {
        return this.mMenuActionColor;
    }

    @ColorInt
    public int getMenuOverflowColor() {
        return this.mMenuOverflowColor;
    }

    public ImageView getAvatarView() {
        return this.mAvatarView;
    }

    private static class SavedState
    extends View.BaseSavedState {
        private int menuId;
        private int menuItemsRoom;
        private int menuActionColor;
        private int menuOverflowColor;
        private String title;
        private String subtitle;
        private boolean isMultiline;
        private boolean forceKeyline;
        private int iconColor;
        private int circularIconColor;
        private int iconResId;
        private int displayMode;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.menuId = in.readInt();
            this.menuItemsRoom = in.readInt();
            this.menuActionColor = in.readInt();
            this.menuOverflowColor = in.readInt();
            this.title = in.readString();
            this.subtitle = in.readString();
            this.isMultiline = in.readInt() == 1;
            this.forceKeyline = in.readInt() == 1;
            this.iconColor = in.readInt();
            this.circularIconColor = in.readInt();
            this.iconResId = in.readInt();
            this.displayMode = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.menuId);
            out.writeInt(this.menuItemsRoom);
            out.writeInt(this.menuActionColor);
            out.writeInt(this.menuOverflowColor);
            out.writeString(this.title);
            out.writeString(this.subtitle);
            out.writeInt(this.isMultiline ? 1 : 0);
            out.writeInt(this.forceKeyline ? 1 : 0);
            out.writeInt(this.iconColor);
            out.writeInt(this.circularIconColor);
            out.writeInt(this.iconResId);
            out.writeInt(this.displayMode);
        }
    }

    public static interface OnMenuItemClickListener {
        public void onActionMenuItemSelected(MenuItem var1);
    }
}

