/*
 * Decompiled with CFR 0.152.
 */
package com.idunnololz.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import android.widget.BaseExpandableListAdapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import com.idunnololz.widgets.R;
import java.util.ArrayList;
import java.util.List;

public class AnimatedExpandableListView
extends ExpandableListView {
    private static final String TAG = AnimatedExpandableListAdapter.class.getSimpleName();
    private static final int ANIMATION_DURATION = 300;
    private AnimatedExpandableListAdapter adapter;
    private ExpandableListView.OnGroupClickListener animatedOnGroupClickListener = new ExpandableListView.OnGroupClickListener(){

        public boolean onGroupClick(ExpandableListView parent, View v, int groupPosition, long id) {
            if (AnimatedExpandableListView.this.isGroupExpanded(groupPosition)) {
                AnimatedExpandableListView.this.collapseGroupWithAnimation(groupPosition);
            } else {
                AnimatedExpandableListView.this.expandGroupWithAnimation(groupPosition);
            }
            return true;
        }
    };

    public AnimatedExpandableListView(Context context) {
        super(context);
        this.init(context, null);
    }

    public AnimatedExpandableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AnimatedExpandableListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void setAutoScroll(final boolean onlyOneExpanded) {
        ExpandableListView.OnGroupExpandListener autoScrollToOnGroupExpandListener = new ExpandableListView.OnGroupExpandListener(){
            private int previousGroup = -1;
            private int onlyOneExpandedOffset = 3;

            public void onGroupExpand(int groupPosition) {
                if (onlyOneExpanded && groupPosition != this.previousGroup && AnimatedExpandableListView.this.isGroupExpanded(this.previousGroup)) {
                    AnimatedExpandableListView.this.collapseGroupWithAnimation(this.previousGroup);
                    int selectGroup = groupPosition >= this.onlyOneExpandedOffset ? groupPosition - this.onlyOneExpandedOffset : 0;
                    AnimatedExpandableListView.this.setSelectedGroup(selectGroup);
                }
                this.previousGroup = groupPosition;
                AnimatedExpandableListView.this.smoothScrollToPositionFromTop(groupPosition, 0, 300);
            }
        };
        this.setOnGroupExpandListener(autoScrollToOnGroupExpandListener);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AnimatedExpandableListView, 0, 0);
            boolean animated = typedArray.getBoolean(0, true);
            if (animated) {
                this.setOnGroupClickListener(this.animatedOnGroupClickListener);
            }
            boolean autoScroll = typedArray.getBoolean(1, false);
            boolean onlyOneExpanded = typedArray.getBoolean(2, false);
            if (autoScroll || onlyOneExpanded) {
                this.setOnGroupClickListener(this.animatedOnGroupClickListener);
                this.setAutoScroll(onlyOneExpanded);
            }
            typedArray.recycle();
        }
    }

    public void setAdapter(ExpandableListAdapter adapter) {
        super.setAdapter(adapter);
        if (!(adapter instanceof AnimatedExpandableListAdapter)) {
            throw new ClassCastException(adapter.toString() + " must implement AnimatedExpandableListAdapter");
        }
        this.adapter = (AnimatedExpandableListAdapter)adapter;
        this.adapter.setParent(this);
    }

    public boolean expandGroupWithAnimation(int groupPos) {
        View v;
        int childIndex;
        int groupFlatPos = this.getFlatListPosition(AnimatedExpandableListView.getPackedPositionForGroup((int)groupPos));
        if (groupFlatPos != -1 && (childIndex = groupFlatPos - this.getFirstVisiblePosition()) < this.getChildCount() && (v = this.getChildAt(childIndex)).getBottom() >= this.getBottom()) {
            this.adapter.notifyGroupExpanded(groupPos);
            return this.expandGroup(groupPos);
        }
        this.adapter.startExpandAnimation(groupPos, 0);
        return this.expandGroup(groupPos);
    }

    public boolean collapseGroupWithAnimation(int groupPos) {
        int groupFlatPos = this.getFlatListPosition(AnimatedExpandableListView.getPackedPositionForGroup((int)groupPos));
        if (groupFlatPos != -1) {
            int childIndex = groupFlatPos - this.getFirstVisiblePosition();
            if (childIndex >= 0 && childIndex < this.getChildCount()) {
                View v = this.getChildAt(childIndex);
                if (v.getBottom() >= this.getBottom()) {
                    return this.collapseGroup(groupPos);
                }
            } else {
                return this.collapseGroup(groupPos);
            }
        }
        long packedPos = this.getExpandableListPosition(this.getFirstVisiblePosition());
        int firstChildPos = AnimatedExpandableListView.getPackedPositionChild((long)packedPos);
        int firstGroupPos = AnimatedExpandableListView.getPackedPositionGroup((long)packedPos);
        firstChildPos = firstChildPos == -1 || firstGroupPos != groupPos ? 0 : firstChildPos;
        this.adapter.startCollapseAnimation(groupPos, firstChildPos);
        this.adapter.notifyDataSetChanged();
        return this.isGroupExpanded(groupPos);
    }

    private int getAnimationDuration() {
        return 300;
    }

    private static class ExpandAnimation
    extends Animation {
        private int baseHeight;
        private int delta;
        private View view;
        private GroupInfo groupInfo;

        private ExpandAnimation(View v, int startHeight, int endHeight, GroupInfo info) {
            this.baseHeight = startHeight;
            this.delta = endHeight - startHeight;
            this.view = v;
            this.groupInfo = info;
            this.view.getLayoutParams().height = startHeight;
            this.view.requestLayout();
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            super.applyTransformation(interpolatedTime, t);
            if (interpolatedTime < 1.0f) {
                int val;
                this.view.getLayoutParams().height = val = this.baseHeight + (int)((float)this.delta * interpolatedTime);
                this.groupInfo.dummyHeight = val;
                this.view.requestLayout();
            } else {
                int val;
                this.view.getLayoutParams().height = val = this.baseHeight + this.delta;
                this.groupInfo.dummyHeight = val;
                this.view.requestLayout();
            }
        }
    }

    private static class DummyView
    extends View {
        private List<View> views = new ArrayList<View>();
        private Drawable divider;
        private int dividerWidth;
        private int dividerHeight;

        public DummyView(Context context) {
            super(context);
        }

        public void setDivider(Drawable divider, int dividerWidth, int dividerHeight) {
            if (divider != null) {
                this.divider = divider;
                this.dividerWidth = dividerWidth;
                this.dividerHeight = dividerHeight;
                divider.setBounds(0, 0, dividerWidth, dividerHeight);
            }
        }

        public void addFakeView(View childView) {
            childView.layout(0, 0, this.getWidth(), this.getHeight());
            this.views.add(childView);
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            super.onLayout(changed, left, top, right, bottom);
            int len = this.views.size();
            for (int i = 0; i < len; ++i) {
                View v = this.views.get(i);
                v.layout(left, top, right, bottom);
            }
        }

        public void clearViews() {
            this.views.clear();
        }

        public void dispatchDraw(Canvas canvas) {
            canvas.save();
            if (this.divider != null) {
                this.divider.setBounds(0, 0, this.dividerWidth, this.dividerHeight);
            }
            int len = this.views.size();
            for (int i = 0; i < len; ++i) {
                View v = this.views.get(i);
                v.draw(canvas);
                canvas.translate(0.0f, (float)v.getMeasuredHeight());
                if (this.divider == null) continue;
                this.divider.draw(canvas);
                canvas.translate(0.0f, (float)this.dividerHeight);
            }
            canvas.restore();
        }
    }

    public static abstract class AnimatedExpandableListAdapter
    extends BaseExpandableListAdapter {
        private SparseArray<GroupInfo> groupInfo = new SparseArray();
        private AnimatedExpandableListView parent;
        private static final int STATE_IDLE = 0;
        private static final int STATE_EXPANDING = 1;
        private static final int STATE_COLLAPSING = 2;

        private void setParent(AnimatedExpandableListView parent) {
            this.parent = parent;
        }

        public int getRealChildType(int groupPosition, int childPosition) {
            return 0;
        }

        public int getRealChildTypeCount() {
            return 1;
        }

        public abstract View getRealChildView(int var1, int var2, boolean var3, View var4, ViewGroup var5);

        public abstract int getRealChildrenCount(int var1);

        private GroupInfo getGroupInfo(int groupPosition) {
            GroupInfo info = (GroupInfo)this.groupInfo.get(groupPosition);
            if (info == null) {
                info = new GroupInfo();
                this.groupInfo.put(groupPosition, (Object)info);
            }
            return info;
        }

        public void notifyGroupExpanded(int groupPosition) {
            GroupInfo info = this.getGroupInfo(groupPosition);
            info.dummyHeight = -1;
        }

        private void startExpandAnimation(int groupPosition, int firstChildPosition) {
            GroupInfo info = this.getGroupInfo(groupPosition);
            info.animating = true;
            info.firstChildPosition = firstChildPosition;
            info.expanding = true;
        }

        private void startCollapseAnimation(int groupPosition, int firstChildPosition) {
            GroupInfo info = this.getGroupInfo(groupPosition);
            info.animating = true;
            info.firstChildPosition = firstChildPosition;
            info.expanding = false;
        }

        private void stopAnimation(int groupPosition) {
            GroupInfo info = this.getGroupInfo(groupPosition);
            info.animating = false;
        }

        public final int getChildType(int groupPosition, int childPosition) {
            GroupInfo info = this.getGroupInfo(groupPosition);
            if (info.animating) {
                return 0;
            }
            return this.getRealChildType(groupPosition, childPosition) + 1;
        }

        public final int getChildTypeCount() {
            return this.getRealChildTypeCount() + 1;
        }

        public final View getChildView(final int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
            final GroupInfo info = this.getGroupInfo(groupPosition);
            if (info.animating) {
                int animationHeight;
                Object o;
                if (!(convertView instanceof DummyView)) {
                    convertView = new DummyView(parent.getContext());
                    convertView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, 0));
                }
                if (childPosition < info.firstChildPosition) {
                    convertView.getLayoutParams().height = 0;
                    return convertView;
                }
                final ExpandableListView listView = (ExpandableListView)parent;
                final DummyView dummyView = (DummyView)convertView;
                dummyView.clearViews();
                dummyView.setDivider(listView.getDivider(), parent.getMeasuredWidth(), listView.getDividerHeight());
                int measureSpecW = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0x40000000);
                int measureSpecH = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                int totalHeight = 0;
                int clipHeight = parent.getHeight();
                int len = this.getRealChildrenCount(groupPosition);
                for (int i = info.firstChildPosition; i < len; ++i) {
                    View childView = this.getRealChildView(groupPosition, i, i == len - 1, null, parent);
                    childView.measure(measureSpecW, measureSpecH);
                    if ((totalHeight += childView.getMeasuredHeight()) >= clipHeight) {
                        dummyView.addFakeView(childView);
                        int averageHeight = totalHeight / (i + 1);
                        totalHeight += (len - i - 1) * averageHeight;
                        break;
                    }
                    dummyView.addFakeView(childView);
                }
                int state = (o = dummyView.getTag()) == null ? 0 : (Integer)o;
                int n = animationHeight = totalHeight < clipHeight ? totalHeight : clipHeight;
                if (info.expanding && state != 1) {
                    ExpandAnimation ani = new ExpandAnimation(dummyView, 0, animationHeight, info);
                    ani.setDuration(this.parent.getAnimationDuration());
                    ani.setAnimationListener(new Animation.AnimationListener(){

                        public void onAnimationEnd(Animation animation) {
                            AnimatedExpandableListAdapter.this.stopAnimation(groupPosition);
                            AnimatedExpandableListAdapter.this.notifyDataSetChanged();
                            dummyView.setTag(0);
                        }

                        public void onAnimationRepeat(Animation animation) {
                        }

                        public void onAnimationStart(Animation animation) {
                        }
                    });
                    dummyView.startAnimation(ani);
                    dummyView.setTag(1);
                } else if (!info.expanding && state != 2) {
                    if (info.dummyHeight == -1) {
                        info.dummyHeight = totalHeight;
                    }
                    ExpandAnimation ani = new ExpandAnimation(dummyView, animationHeight, 0, info);
                    ani.setDuration(this.parent.getAnimationDuration());
                    ani.setAnimationListener(new Animation.AnimationListener(){

                        public void onAnimationEnd(Animation animation) {
                            AnimatedExpandableListAdapter.this.stopAnimation(groupPosition);
                            listView.collapseGroup(groupPosition);
                            AnimatedExpandableListAdapter.this.notifyDataSetChanged();
                            info.dummyHeight = -1;
                            dummyView.setTag(0);
                        }

                        public void onAnimationRepeat(Animation animation) {
                        }

                        public void onAnimationStart(Animation animation) {
                        }
                    });
                    dummyView.startAnimation(ani);
                    dummyView.setTag(2);
                }
                return convertView;
            }
            return this.getRealChildView(groupPosition, childPosition, isLastChild, convertView, parent);
        }

        public final int getChildrenCount(int groupPosition) {
            GroupInfo info = this.getGroupInfo(groupPosition);
            if (info.animating) {
                return info.firstChildPosition + 1;
            }
            return this.getRealChildrenCount(groupPosition);
        }
    }

    private static class GroupInfo {
        boolean animating = false;
        boolean expanding = false;
        int firstChildPosition;
        int dummyHeight = -1;

        private GroupInfo() {
        }
    }
}

