/*
 * Decompiled with CFR 0.152.
 */
package com.woxthebox.draglistview.swipe;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.RelativeLayout;
import com.lshershun.draglistview.R;
import com.woxthebox.draglistview.swipe.ListSwipeHelper;

public class ListSwipeItem
extends RelativeLayout {
    private View mLeftView;
    private View mRightView;
    private View mSwipeView;
    private RecyclerView.ViewHolder mViewHolder;
    private SwipeState mSwipeState = SwipeState.IDLE;
    private float mSwipeTranslationX;
    private float mStartSwipeTranslationX;
    private float mFlingSpeed;
    private boolean mSwipeStarted;
    private int mSwipeViewId;
    private int mLeftViewId;
    private int mRightViewId;
    private SwipeDirection mSwipeDirection = SwipeDirection.LEFT_AND_RIGHT;
    private SwipeInStyle mSwipeInStyle = SwipeInStyle.APPEAR;
    private ListSwipeHelper.OnSwipeListener mSwipeListener;

    public ListSwipeItem(Context context) {
        super(context);
    }

    public ListSwipeItem(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ListSwipeItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ListSwipeItem);
        this.mSwipeViewId = a.getResourceId(R.styleable.ListSwipeItem_swipeViewId, -1);
        this.mLeftViewId = a.getResourceId(R.styleable.ListSwipeItem_leftViewId, -1);
        this.mRightViewId = a.getResourceId(R.styleable.ListSwipeItem_rightViewId, -1);
        a.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mSwipeView = this.findViewById(this.mSwipeViewId);
        this.mLeftView = this.findViewById(this.mLeftViewId);
        this.mRightView = this.findViewById(this.mRightViewId);
        if (this.mLeftView != null) {
            this.mLeftView.setVisibility(4);
        }
        if (this.mRightView != null) {
            this.mRightView.setVisibility(4);
        }
    }

    public void setTag(Object tag) {
        super.setTag(tag);
        if (this.mViewHolder != null && this.mViewHolder.isRecyclable()) {
            this.resetSwipe(false);
        }
    }

    public void setSwipeInStyle(SwipeInStyle style) {
        this.mSwipeInStyle = style;
    }

    public void setSupportedSwipeDirection(SwipeDirection swipeDirection) {
        this.mSwipeDirection = swipeDirection;
    }

    public SwipeDirection getSupportedSwipeDirection() {
        return this.mSwipeDirection;
    }

    void setSwipeListener(ListSwipeHelper.OnSwipeListener listener) {
        this.mSwipeListener = listener;
    }

    SwipeDirection getSwipedDirection() {
        if (this.mSwipeState != SwipeState.IDLE) {
            return SwipeDirection.NONE;
        }
        if (this.mSwipeView.getTranslationX() == (float)(-this.getMeasuredWidth())) {
            return SwipeDirection.LEFT;
        }
        if (this.mSwipeView.getTranslationX() == (float)this.getMeasuredWidth()) {
            return SwipeDirection.RIGHT;
        }
        return SwipeDirection.NONE;
    }

    boolean isAnimating() {
        return this.mSwipeState == SwipeState.ANIMATING;
    }

    boolean isSwipeStarted() {
        return this.mSwipeStarted;
    }

    void setFlingSpeed(float speed) {
        this.mFlingSpeed = speed;
    }

    void swipeTranslationByX(float dx) {
        this.setSwipeTranslationX(this.mSwipeTranslationX + dx);
    }

    void setSwipeTranslationX(float x) {
        if (this.mSwipeDirection == SwipeDirection.LEFT && x > 0.0f || this.mSwipeDirection == SwipeDirection.RIGHT && x < 0.0f || this.mSwipeDirection == SwipeDirection.NONE) {
            x = 0.0f;
        }
        this.mSwipeTranslationX = x;
        this.mSwipeTranslationX = Math.min(this.mSwipeTranslationX, (float)this.getMeasuredWidth());
        this.mSwipeTranslationX = Math.max(this.mSwipeTranslationX, (float)(-this.getMeasuredWidth()));
        this.mSwipeView.setTranslationX(this.mSwipeTranslationX);
        if (this.mSwipeListener != null) {
            this.mSwipeListener.onItemSwiping(this, this.mSwipeTranslationX);
        }
        if (this.mSwipeTranslationX < 0.0f) {
            if (this.mSwipeInStyle == SwipeInStyle.SLIDE) {
                this.mRightView.setTranslationX((float)this.getMeasuredWidth() + this.mSwipeTranslationX);
            }
            this.mRightView.setVisibility(0);
            this.mLeftView.setVisibility(4);
        } else if (this.mSwipeTranslationX > 0.0f) {
            if (this.mSwipeInStyle == SwipeInStyle.SLIDE) {
                this.mLeftView.setTranslationX((float)(-this.getMeasuredWidth()) + this.mSwipeTranslationX);
            }
            this.mLeftView.setVisibility(0);
            this.mRightView.setVisibility(4);
        } else {
            this.mRightView.setVisibility(4);
            this.mLeftView.setVisibility(4);
        }
    }

    void animateToSwipeTranslationX(float x, Animator.AnimatorListener ... listeners) {
        if (x == this.mSwipeTranslationX) {
            return;
        }
        this.mSwipeState = SwipeState.ANIMATING;
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"SwipeTranslationX", (float[])new float[]{this.mSwipeTranslationX, x});
        animator.setDuration(250L);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        for (Animator.AnimatorListener listener : listeners) {
            if (listener == null) continue;
            animator.addListener(listener);
        }
        animator.start();
    }

    void resetSwipe(boolean animate) {
        if (this.isAnimating() || !this.mSwipeStarted) {
            return;
        }
        if (this.mSwipeTranslationX != 0.0f) {
            if (animate) {
                this.animateToSwipeTranslationX(0.0f, new Animator.AnimatorListener[]{new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        ListSwipeItem.this.mSwipeState = SwipeState.IDLE;
                        ListSwipeItem.this.mSwipeListener = null;
                    }
                }});
            } else {
                this.setSwipeTranslationX(0.0f);
                this.mSwipeState = SwipeState.IDLE;
                this.mSwipeListener = null;
            }
        } else {
            this.mSwipeListener = null;
        }
        if (this.mViewHolder != null && !this.mViewHolder.isRecyclable()) {
            this.mViewHolder.setIsRecyclable(true);
        }
        this.mViewHolder = null;
        this.mFlingSpeed = 0.0f;
        this.mStartSwipeTranslationX = 0.0f;
        this.mSwipeStarted = false;
    }

    void handleSwipeUp(Animator.AnimatorListener listener) {
        if (this.isAnimating() || !this.mSwipeStarted) {
            return;
        }
        AnimatorListenerAdapter idleListener = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ListSwipeItem.this.mSwipeState = SwipeState.IDLE;
                if (ListSwipeItem.this.mSwipeTranslationX == 0.0f) {
                    ListSwipeItem.this.resetSwipe(false);
                }
                if (ListSwipeItem.this.mViewHolder != null) {
                    ListSwipeItem.this.mViewHolder.setIsRecyclable(true);
                }
            }
        };
        if (this.mFlingSpeed == 0.0f && Math.abs(this.mStartSwipeTranslationX - this.mSwipeTranslationX) < (float)(this.getMeasuredWidth() / 3)) {
            this.animateToSwipeTranslationX(this.mStartSwipeTranslationX, new Animator.AnimatorListener[]{idleListener, listener});
        } else {
            float newX = this.getTranslateToXPosition(this.mStartSwipeTranslationX, this.mSwipeTranslationX, this.mFlingSpeed);
            this.animateToSwipeTranslationX(newX, new Animator.AnimatorListener[]{idleListener, listener});
        }
        this.mStartSwipeTranslationX = 0.0f;
        this.mFlingSpeed = 0.0f;
    }

    private float getTranslateToXPosition(float startTranslationX, float currentTranslationX, float flingSpeed) {
        if (flingSpeed == 0.0f && Math.abs(startTranslationX - currentTranslationX) < (float)(this.getMeasuredWidth() / 3)) {
            return startTranslationX;
        }
        if (currentTranslationX < 0.0f) {
            if (flingSpeed > 0.0f) {
                return 0.0f;
            }
            return -this.getMeasuredWidth();
        }
        if (startTranslationX == 0.0f) {
            if (flingSpeed < 0.0f) {
                return 0.0f;
            }
            return this.getMeasuredWidth();
        }
        if (flingSpeed > 0.0f) {
            return this.getMeasuredWidth();
        }
        return 0.0f;
    }

    void handleSwipeMoveStarted(ListSwipeHelper.OnSwipeListener listener) {
        this.mStartSwipeTranslationX = this.mSwipeTranslationX;
        this.mSwipeListener = listener;
    }

    void handleSwipeMove(float dx, RecyclerView.ViewHolder viewHolder) {
        if (this.isAnimating()) {
            return;
        }
        this.mSwipeState = SwipeState.SWIPING;
        if (!this.mSwipeStarted) {
            this.mSwipeStarted = true;
            this.mViewHolder = viewHolder;
            this.mViewHolder.setIsRecyclable(false);
        }
        this.swipeTranslationByX(dx);
    }

    public static enum SwipeInStyle {
        APPEAR,
        SLIDE;

    }

    public static enum SwipeDirection {
        LEFT,
        RIGHT,
        LEFT_AND_RIGHT,
        NONE;

    }

    private static enum SwipeState {
        IDLE,
        SWIPING,
        ANIMATING;

    }
}

