/*
 * Decompiled with CFR 0.152.
 */
package com.woxthebox.draglistview.swipe;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.woxthebox.draglistview.swipe.ListSwipeItem;

public class ListSwipeHelper
extends RecyclerView.OnScrollListener
implements RecyclerView.OnItemTouchListener {
    private GestureListener mGestureListener;
    private GestureDetector mGestureDetector;
    private ListSwipeItem mSwipeView;
    private RecyclerView mRecyclerView;
    private OnSwipeListener mSwipeListener;
    private int mTouchSlop;

    public ListSwipeHelper(Context applicationContext, OnSwipeListener listener) {
        this.mSwipeListener = listener;
        this.mGestureListener = new GestureListener();
        this.mGestureDetector = new GestureDetector(applicationContext, (GestureDetector.OnGestureListener)this.mGestureListener);
    }

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent event) {
        this.handleTouch(rv, event);
        return this.mGestureListener.isSwipeStarted();
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent event) {
        this.handleTouch(rv, event);
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        this.resetSwipedViews(null);
    }

    public void resetSwipedViews(View exceptionView) {
        int childCount = this.mRecyclerView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.mRecyclerView.getChildAt(i);
            if (!(view instanceof ListSwipeItem) || view == exceptionView) continue;
            ((ListSwipeItem)view).resetSwipe(true);
        }
    }

    private void handleTouch(RecyclerView rv, MotionEvent event) {
        this.mGestureDetector.onTouchEvent(event);
        switch (event.getAction()) {
            case 0: {
                View swipeView = rv.findChildViewUnder(event.getX(), event.getY());
                if (!(swipeView instanceof ListSwipeItem) || ((ListSwipeItem)swipeView).getSupportedSwipeDirection() == ListSwipeItem.SwipeDirection.NONE) break;
                this.mSwipeView = (ListSwipeItem)swipeView;
                break;
            }
            case 1: 
            case 3: {
                if (this.mSwipeView != null) {
                    final ListSwipeItem endingSwipeView = this.mSwipeView;
                    endingSwipeView.handleSwipeUp((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            if (endingSwipeView.isSwipeStarted()) {
                                ListSwipeHelper.this.resetSwipedViews((View)endingSwipeView);
                            }
                            if (ListSwipeHelper.this.mSwipeListener != null) {
                                ListSwipeHelper.this.mSwipeListener.onItemSwipeEnded(endingSwipeView, endingSwipeView.getSwipedDirection());
                            }
                        }
                    });
                } else {
                    this.resetSwipedViews(null);
                }
                this.mSwipeView = null;
                this.mRecyclerView.requestDisallowInterceptTouchEvent(false);
            }
        }
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public void detachFromRecyclerView() {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.removeOnItemTouchListener((RecyclerView.OnItemTouchListener)this);
            this.mRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
        }
        this.mRecyclerView = null;
    }

    public void attachToRecyclerView(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)this);
        this.mRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this);
        this.mTouchSlop = ViewConfiguration.get((Context)this.mRecyclerView.getContext()).getScaledTouchSlop();
    }

    public void setSwipeListener(OnSwipeListener listener) {
        this.mSwipeListener = listener;
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private boolean mSwipeStarted;

        private GestureListener() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (e1 == null || e2 == null || ListSwipeHelper.this.mSwipeView == null || ListSwipeHelper.this.mRecyclerView.getScrollState() != 0) {
                return false;
            }
            float diffX = Math.abs(e2.getX() - e1.getX());
            float diffY = Math.abs(e2.getY() - e1.getY());
            if (!this.mSwipeStarted && diffX > (float)(ListSwipeHelper.this.mTouchSlop * 2) && diffX * 0.5f > diffY) {
                this.mSwipeStarted = true;
                ListSwipeHelper.this.mRecyclerView.requestDisallowInterceptTouchEvent(true);
                ListSwipeHelper.this.mSwipeView.handleSwipeMoveStarted(ListSwipeHelper.this.mSwipeListener);
                if (ListSwipeHelper.this.mSwipeListener != null) {
                    ListSwipeHelper.this.mSwipeListener.onItemSwipeStarted(ListSwipeHelper.this.mSwipeView);
                }
            }
            if (this.mSwipeStarted) {
                ListSwipeHelper.this.mSwipeView.handleSwipeMove(-distanceX, ListSwipeHelper.this.mRecyclerView.getChildViewHolder((View)ListSwipeHelper.this.mSwipeView));
            }
            return this.mSwipeStarted;
        }

        public boolean onDown(MotionEvent e) {
            this.mSwipeStarted = false;
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!this.canStartSwipe(e1, e2)) {
                return false;
            }
            ListSwipeHelper.this.mSwipeView.setFlingSpeed(velocityX);
            return true;
        }

        boolean isSwipeStarted() {
            return this.mSwipeStarted;
        }

        private boolean canStartSwipe(MotionEvent e1, MotionEvent e2) {
            return e1 != null && e2 != null && ListSwipeHelper.this.mSwipeView != null && ListSwipeHelper.this.mRecyclerView.getScrollState() == 0 && ListSwipeHelper.this.mSwipeView.getSupportedSwipeDirection() != ListSwipeItem.SwipeDirection.NONE;
        }
    }

    public static interface OnSwipeListener {
        public void onItemSwipeStarted(ListSwipeItem var1);

        public void onItemSwipeEnded(ListSwipeItem var1, ListSwipeItem.SwipeDirection var2);

        public void onItemSwiping(ListSwipeItem var1, float var2);
    }

    public static abstract class OnSwipeListenerAdapter
    implements OnSwipeListener {
        @Override
        public void onItemSwipeStarted(ListSwipeItem item) {
        }

        @Override
        public void onItemSwipeEnded(ListSwipeItem item, ListSwipeItem.SwipeDirection swipedDirection) {
        }

        @Override
        public void onItemSwiping(ListSwipeItem item, float swipedDistanceX) {
        }
    }
}

