/*
 * Decompiled with CFR 0.152.
 */
package com.woxthebox.draglistview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.Scroller;
import com.lshershun.draglistview.R;
import com.woxthebox.draglistview.AutoScroller;
import com.woxthebox.draglistview.DragItem;
import com.woxthebox.draglistview.DragItemAdapter;
import com.woxthebox.draglistview.DragItemRecyclerView;
import java.util.ArrayList;

public class BoardView
extends HorizontalScrollView
implements AutoScroller.AutoScrollListener {
    private static final int SCROLL_ANIMATION_DURATION = 325;
    private Scroller mScroller;
    private AutoScroller mAutoScroller;
    private GestureDetector mGestureDetector;
    private FrameLayout mRootLayout;
    private LinearLayout mColumnLayout;
    private ArrayList<DragItemRecyclerView> mLists = new ArrayList();
    private ArrayList<View> mHeaders = new ArrayList();
    private DragItemRecyclerView mCurrentRecyclerView;
    private DragItem mDragItem;
    private DragItem mDragColumn;
    private BoardListener mBoardListener;
    private BoardCallback mBoardCallback;
    private boolean mSnapToColumnWhenScrolling = true;
    private boolean mSnapToColumnWhenDragging = true;
    private boolean mSnapToColumnInLandscape = false;
    private ColumnSnapPosition mSnapPosition = ColumnSnapPosition.CENTER;
    private int mCurrentColumn;
    private float mTouchX;
    private float mTouchY;
    private float mDragColumnStartScrollX;
    private int mColumnSpacing;
    private int mListBackgroundDrawable;
    private int mListBackgroundColor;
    private int mColumnWidth;
    private int mDragStartColumn;
    private int mDragStartRow;
    private boolean mHasLaidOut;
    private boolean mDragEnabled = true;
    private int mLastDragColumn = -1;
    private int mLastDragRow = -1;
    private SavedState mSavedState;

    public BoardView(Context context) {
        super(context);
    }

    public BoardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet set) {
        if (set == null) {
            return;
        }
        TypedArray ta = this.getContext().obtainStyledAttributes(set, R.styleable.BoardView);
        try {
            this.mListBackgroundDrawable = ta.getResourceId(R.styleable.BoardView_listBackgroundDrawable, 0);
            this.mListBackgroundColor = ta.getResourceId(R.styleable.BoardView_listBackgroundColor, 0);
            this.mColumnSpacing = ta.getDimensionPixelSize(R.styleable.BoardView_columnSpacing, 0);
        }
        finally {
            ta.recycle();
        }
    }

    public BoardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        Resources res = this.getResources();
        boolean isPortrait = res.getConfiguration().orientation == 1;
        this.mColumnWidth = isPortrait ? (int)((double)res.getDisplayMetrics().widthPixels * 0.87) : (int)(res.getDisplayMetrics().density * 320.0f);
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureListener());
        this.mScroller = new Scroller(this.getContext(), (Interpolator)new DecelerateInterpolator(1.1f));
        this.mAutoScroller = new AutoScroller(this.getContext(), this);
        this.mAutoScroller.setAutoScrollMode(this.snapToColumnWhenDragging() ? AutoScroller.AutoScrollMode.COLUMN : AutoScroller.AutoScrollMode.POSITION);
        this.mDragItem = new DragItem(this.getContext());
        this.mDragColumn = new DragItem(this.getContext());
        this.mDragColumn.setSnapToTouch(false);
        this.mRootLayout = new FrameLayout(this.getContext());
        this.mRootLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        FrameLayout statusView = new FrameLayout(this.getContext());
        statusView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        statusView.setVisibility(8);
        this.mColumnLayout = new LinearLayout(this.getContext());
        this.mColumnLayout.setOrientation(0);
        this.mColumnLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        this.mColumnLayout.setMotionEventSplittingEnabled(false);
        this.mRootLayout.addView((View)this.mColumnLayout);
        this.mRootLayout.addView((View)statusView);
        this.mRootLayout.addView(this.mDragItem.getDragItemView());
        this.addView((View)this.mRootLayout);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (!this.mHasLaidOut && this.mSavedState != null) {
            this.mCurrentColumn = this.mSavedState.currentColumn;
            this.mSavedState = null;
            this.post(new Runnable(){

                @Override
                public void run() {
                    BoardView.this.scrollToColumn(BoardView.this.mCurrentColumn, false);
                }
            });
        }
        this.mHasLaidOut = true;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mSavedState = ss;
        this.requestLayout();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.snapToColumnWhenScrolling() ? this.mCurrentColumn : this.getClosestSnapColumn());
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        boolean retValue = this.handleTouchEvent(event);
        return retValue || super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean retValue = this.handleTouchEvent(event);
        return retValue || super.onTouchEvent(event);
    }

    private boolean handleTouchEvent(MotionEvent event) {
        if (this.mLists.size() == 0) {
            return false;
        }
        this.mTouchX = event.getX();
        this.mTouchY = event.getY();
        if (this.isDragging()) {
            switch (event.getAction()) {
                case 2: {
                    if (this.mAutoScroller.isAutoScrolling()) break;
                    this.updateScrollPosition();
                    break;
                }
                case 1: 
                case 3: {
                    this.mAutoScroller.stopAutoScroll();
                    if (this.isDraggingColumn()) {
                        this.endDragColumn();
                    } else {
                        this.mCurrentRecyclerView.onDragEnded();
                    }
                    if (this.snapToColumnWhenScrolling()) {
                        this.scrollToColumn(this.getColumnOfList(this.mCurrentRecyclerView), true);
                    }
                    this.invalidate();
                }
            }
            return true;
        }
        if (this.snapToColumnWhenScrolling() && this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.mScroller.isFinished()) break;
                this.mScroller.forceFinished(true);
                break;
            }
            case 1: 
            case 3: {
                if (!this.snapToColumnWhenScrolling()) break;
                this.scrollToColumn(this.getClosestSnapColumn(), true);
            }
        }
        return false;
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (this.getScrollX() != x || this.getScrollY() != y) {
                this.scrollTo(x, y);
            }
            if (this.mAutoScroller.isAutoScrolling() && this.isDragging()) {
                if (this.isDraggingColumn()) {
                    this.mDragColumn.setPosition(this.mTouchX + (float)this.getScrollX() - this.mDragColumnStartScrollX, this.mTouchY);
                } else {
                    this.mDragItem.setPosition(this.getRelativeViewTouchX((View)this.mCurrentRecyclerView.getParent()), this.getRelativeViewTouchY((View)this.mCurrentRecyclerView));
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else if (!this.snapToColumnWhenScrolling()) {
            super.computeScroll();
        }
    }

    @Override
    public void onAutoScrollPositionBy(int dx, int dy) {
        if (this.isDragging()) {
            this.scrollBy(dx, dy);
            this.updateScrollPosition();
        } else {
            this.mAutoScroller.stopAutoScroll();
        }
    }

    @Override
    public void onAutoScrollColumnBy(int columns) {
        if (this.isDragging()) {
            int newColumn = this.mCurrentColumn + columns;
            if (columns != 0 && newColumn >= 0 && newColumn < this.mLists.size()) {
                this.scrollToColumn(newColumn, true);
            }
            this.updateScrollPosition();
        } else {
            this.mAutoScroller.stopAutoScroll();
        }
    }

    private void updateScrollPosition() {
        DragItemRecyclerView currentList;
        if (this.isDraggingColumn()) {
            currentList = this.getCurrentRecyclerView(this.mTouchX + (float)this.getScrollX());
            if (this.mCurrentRecyclerView != currentList) {
                this.moveColumn(this.getColumnOfList(this.mCurrentRecyclerView), this.getColumnOfList(currentList));
            }
            this.mDragColumn.setPosition(this.mTouchX + (float)this.getScrollX() - this.mDragColumnStartScrollX, this.mTouchY);
        } else {
            currentList = this.getCurrentRecyclerView(this.mTouchX + (float)this.getScrollX());
            if (this.mCurrentRecyclerView != currentList) {
                Object item;
                int oldColumn = this.getColumnOfList(this.mCurrentRecyclerView);
                int newColumn = this.getColumnOfList(currentList);
                long itemId = this.mCurrentRecyclerView.getDragItemId();
                int newPosition = currentList.getDragPositionForY(this.getRelativeViewTouchY((View)currentList));
                if ((this.mBoardCallback == null || this.mBoardCallback.canDropItemAtPosition(this.mDragStartColumn, this.mDragStartRow, newColumn, newPosition)) && (item = this.mCurrentRecyclerView.removeDragItemAndEnd()) != null) {
                    this.mCurrentRecyclerView = currentList;
                    this.mCurrentRecyclerView.addDragItemAndStart(this.getRelativeViewTouchY((View)this.mCurrentRecyclerView), item, itemId);
                    this.mDragItem.setOffset(((View)this.mCurrentRecyclerView.getParent()).getLeft(), this.mCurrentRecyclerView.getTop());
                    if (this.mBoardListener != null) {
                        this.mBoardListener.onItemChangedColumn(oldColumn, newColumn);
                    }
                }
            }
            this.mCurrentRecyclerView.onDragging(this.getRelativeViewTouchX((View)this.mCurrentRecyclerView.getParent()), this.getRelativeViewTouchY((View)this.mCurrentRecyclerView));
        }
        boolean isPortrait = this.getResources().getConfiguration().orientation == 1;
        float scrollEdge = (float)this.getResources().getDisplayMetrics().widthPixels * (isPortrait ? 0.18f : 0.14f);
        if (this.mTouchX > (float)this.getWidth() - scrollEdge && this.getScrollX() < this.mColumnLayout.getWidth()) {
            this.mAutoScroller.startAutoScroll(AutoScroller.ScrollDirection.LEFT);
        } else if (this.mTouchX < scrollEdge && this.getScrollX() > 0) {
            this.mAutoScroller.startAutoScroll(AutoScroller.ScrollDirection.RIGHT);
        } else {
            this.mAutoScroller.stopAutoScroll();
        }
        this.invalidate();
    }

    private float getRelativeViewTouchX(View view) {
        return this.mTouchX + (float)this.getScrollX() - (float)view.getLeft();
    }

    private float getRelativeViewTouchY(View view) {
        return this.mTouchY - (float)view.getTop();
    }

    private DragItemRecyclerView getCurrentRecyclerView(float x) {
        for (DragItemRecyclerView list : this.mLists) {
            View parent = (View)list.getParent();
            if (!((float)parent.getLeft() <= x) || !((float)parent.getRight() > x)) continue;
            return list;
        }
        return this.mCurrentRecyclerView;
    }

    private int getColumnOfList(DragItemRecyclerView list) {
        int column = 0;
        for (int i = 0; i < this.mLists.size(); ++i) {
            RecyclerView tmpList = this.mLists.get(i);
            if (tmpList != list) continue;
            column = i;
        }
        return column;
    }

    private int getCurrentColumn(float posX) {
        for (int i = 0; i < this.mLists.size(); ++i) {
            RecyclerView list = this.mLists.get(i);
            View parent = (View)list.getParent();
            if (!((float)parent.getLeft() <= posX) || !((float)parent.getRight() > posX)) continue;
            return i;
        }
        return 0;
    }

    private int getClosestSnapColumn() {
        int column = 0;
        int minDiffX = Integer.MAX_VALUE;
        for (int i = 0; i < this.mLists.size(); ++i) {
            View listParent = (View)this.mLists.get(i).getParent();
            int diffX = 0;
            switch (this.mSnapPosition) {
                case LEFT: {
                    int leftPosX = this.getScrollX();
                    diffX = Math.abs(listParent.getLeft() - leftPosX);
                    break;
                }
                case CENTER: {
                    int middlePosX = this.getScrollX() + this.getMeasuredWidth() / 2;
                    diffX = Math.abs(listParent.getLeft() + this.mColumnWidth / 2 - middlePosX);
                    break;
                }
                case RIGHT: {
                    int rightPosX = this.getScrollX() + this.getMeasuredWidth();
                    diffX = Math.abs(listParent.getRight() - rightPosX);
                }
            }
            if (diffX >= minDiffX) continue;
            minDiffX = diffX;
            column = i;
        }
        return column;
    }

    private boolean snapToColumnWhenScrolling() {
        boolean isPortrait = this.getResources().getConfiguration().orientation == 1;
        return this.mSnapToColumnWhenScrolling && (isPortrait || this.mSnapToColumnInLandscape);
    }

    private boolean snapToColumnWhenDragging() {
        boolean isPortrait = this.getResources().getConfiguration().orientation == 1;
        return this.mSnapToColumnWhenDragging && (isPortrait || this.mSnapToColumnInLandscape);
    }

    private boolean isDraggingColumn() {
        return this.mCurrentRecyclerView != null && this.mDragColumn.isDragging();
    }

    private boolean isDragging() {
        return this.mCurrentRecyclerView != null && (this.mCurrentRecyclerView.isDragging() || this.isDraggingColumn());
    }

    public RecyclerView getRecyclerView(int column) {
        if (column >= 0 && column < this.mLists.size()) {
            return this.mLists.get(column);
        }
        return null;
    }

    public DragItemAdapter getAdapter(int column) {
        if (column >= 0 && column < this.mLists.size()) {
            return (DragItemAdapter)this.mLists.get(column).getAdapter();
        }
        return null;
    }

    public int getItemCount() {
        int count = 0;
        for (DragItemRecyclerView list : this.mLists) {
            count += list.getAdapter().getItemCount();
        }
        return count;
    }

    public int getItemCount(int column) {
        if (this.mLists.size() > column) {
            return this.mLists.get(column).getAdapter().getItemCount();
        }
        return 0;
    }

    public int getColumnCount() {
        return this.mLists.size();
    }

    public View getHeaderView(int column) {
        return this.mHeaders.get(column);
    }

    public int getColumnOfHeader(View header) {
        for (int i = 0; i < this.mHeaders.size(); ++i) {
            if (this.mHeaders.get(i) != header) continue;
            return i;
        }
        return -1;
    }

    public void removeItem(int column, int row) {
        if (!this.isDragging() && this.mLists.size() > column && this.mLists.get(column).getAdapter().getItemCount() > row) {
            DragItemAdapter adapter = (DragItemAdapter)this.mLists.get(column).getAdapter();
            adapter.removeItem(row);
        }
    }

    public void addItem(int column, int row, Object item, boolean scrollToItem) {
        if (!this.isDragging() && this.mLists.size() > column && this.mLists.get(column).getAdapter().getItemCount() >= row) {
            DragItemAdapter adapter = (DragItemAdapter)this.mLists.get(column).getAdapter();
            adapter.addItem(row, item);
            if (scrollToItem) {
                this.scrollToItem(column, row, false);
            }
        }
    }

    public void moveItem(int fromColumn, int fromRow, int toColumn, int toRow, boolean scrollToItem) {
        if (!this.isDragging() && this.mLists.size() > fromColumn && this.mLists.get(fromColumn).getAdapter().getItemCount() > fromRow && this.mLists.size() > toColumn && this.mLists.get(toColumn).getAdapter().getItemCount() >= toRow) {
            DragItemAdapter adapter = (DragItemAdapter)this.mLists.get(fromColumn).getAdapter();
            Object item = adapter.removeItem(fromRow);
            adapter = (DragItemAdapter)this.mLists.get(toColumn).getAdapter();
            adapter.addItem(toRow, item);
            if (scrollToItem) {
                this.scrollToItem(toColumn, toRow, false);
            }
        }
    }

    public void moveItem(long itemId, int toColumn, int toRow, boolean scrollToItem) {
        for (int i = 0; i < this.mLists.size(); ++i) {
            RecyclerView.Adapter adapter = this.mLists.get(i).getAdapter();
            int count = adapter.getItemCount();
            for (int j = 0; j < count; ++j) {
                long id = adapter.getItemId(j);
                if (id != itemId) continue;
                this.moveItem(i, j, toColumn, toRow, scrollToItem);
                return;
            }
        }
    }

    public void replaceItem(int column, int row, Object item, boolean scrollToItem) {
        if (!this.isDragging() && this.mLists.size() > column && this.mLists.get(column).getAdapter().getItemCount() > row) {
            DragItemAdapter adapter = (DragItemAdapter)this.mLists.get(column).getAdapter();
            adapter.removeItem(row);
            adapter.addItem(row, item);
            if (scrollToItem) {
                this.scrollToItem(column, row, false);
            }
        }
    }

    public void scrollToItem(int column, int row, boolean animate) {
        if (!this.isDragging() && this.mLists.size() > column && this.mLists.get(column).getAdapter().getItemCount() > row) {
            this.mScroller.forceFinished(true);
            this.scrollToColumn(column, animate);
            if (animate) {
                this.mLists.get(column).smoothScrollToPosition(row);
            } else {
                this.mLists.get(column).scrollToPosition(row);
            }
        }
    }

    public void scrollToColumn(int column, boolean animate) {
        if (this.mLists.size() <= column) {
            return;
        }
        View parent = (View)this.mLists.get(column).getParent();
        int newX = 0;
        switch (this.mSnapPosition) {
            case LEFT: {
                newX = parent.getLeft();
                break;
            }
            case CENTER: {
                newX = parent.getLeft() - (this.getMeasuredWidth() - parent.getMeasuredWidth()) / 2;
                break;
            }
            case RIGHT: {
                newX = parent.getRight() - this.getMeasuredWidth();
            }
        }
        int maxScroll = this.mRootLayout.getMeasuredWidth() - this.getMeasuredWidth();
        newX = newX < 0 ? 0 : newX;
        int n = newX = newX > maxScroll ? maxScroll : newX;
        if (this.getScrollX() != newX) {
            this.mScroller.forceFinished(true);
            if (animate) {
                this.mScroller.startScroll(this.getScrollX(), this.getScrollY(), newX - this.getScrollX(), 0, 325);
                ViewCompat.postInvalidateOnAnimation((View)this);
            } else {
                this.scrollTo(newX, this.getScrollY());
            }
        }
        int oldColumn = this.mCurrentColumn;
        this.mCurrentColumn = column;
        if (this.mBoardListener != null && oldColumn != this.mCurrentColumn) {
            this.mBoardListener.onFocusedColumnChanged(oldColumn, this.mCurrentColumn);
        }
    }

    public void clearBoard() {
        int count = this.mLists.size();
        for (int i = count - 1; i >= 0; --i) {
            this.mColumnLayout.removeViewAt(i);
            this.mHeaders.remove(i);
            this.mLists.remove(i);
        }
    }

    public void removeColumn(int column) {
        if (column >= 0 && this.mLists.size() > column) {
            this.mColumnLayout.removeViewAt(column);
            this.mHeaders.remove(column);
            this.mLists.remove(column);
        }
    }

    public boolean isDragEnabled() {
        return this.mDragEnabled;
    }

    public void setDragEnabled(boolean enabled) {
        this.mDragEnabled = enabled;
        if (this.mLists.size() > 0) {
            for (DragItemRecyclerView list : this.mLists) {
                list.setDragEnabled(this.mDragEnabled);
            }
        }
    }

    public int getFocusedColumn() {
        if (!this.snapToColumnWhenScrolling()) {
            return 0;
        }
        return this.mCurrentColumn;
    }

    public void setColumnWidth(int width) {
        this.mColumnWidth = width;
    }

    public int getColumnWidth() {
        return this.mColumnWidth;
    }

    public void setSnapToColumnsWhenScrolling(boolean snapToColumn) {
        this.mSnapToColumnWhenScrolling = snapToColumn;
    }

    public void setSnapToColumnWhenDragging(boolean snapToColumn) {
        this.mSnapToColumnWhenDragging = snapToColumn;
        this.mAutoScroller.setAutoScrollMode(this.snapToColumnWhenDragging() ? AutoScroller.AutoScrollMode.COLUMN : AutoScroller.AutoScrollMode.POSITION);
    }

    public void setSnapToColumnInLandscape(boolean snapToColumnInLandscape) {
        this.mSnapToColumnInLandscape = snapToColumnInLandscape;
        this.mAutoScroller.setAutoScrollMode(this.snapToColumnWhenDragging() ? AutoScroller.AutoScrollMode.COLUMN : AutoScroller.AutoScrollMode.POSITION);
    }

    public void setColumnSnapPosition(ColumnSnapPosition snapPosition) {
        this.mSnapPosition = snapPosition;
    }

    public void setSnapDragItemToTouch(boolean snapToTouch) {
        this.mDragItem.setSnapToTouch(snapToTouch);
    }

    public void setBoardListener(BoardListener listener) {
        this.mBoardListener = listener;
    }

    public void setBoardCallback(BoardCallback callback) {
        this.mBoardCallback = callback;
    }

    public void setCustomDragItem(DragItem dragItem) {
        DragItem newDragItem = dragItem != null ? dragItem : new DragItem(this.getContext());
        newDragItem.setSnapToTouch(this.mDragItem.isSnapToTouch());
        this.mDragItem = newDragItem;
        this.mRootLayout.removeViewAt(2);
        this.mRootLayout.addView(this.mDragItem.getDragItemView(), 2);
    }

    public void setCustomColumnDragItem(DragItem dragItem) {
        this.mDragColumn = dragItem != null ? dragItem : new DragItem(this.getContext());
    }

    private void startDragColumn(DragItemRecyclerView recyclerView, float posX, float posY) {
        this.mDragColumnStartScrollX = this.getScrollX();
        this.mCurrentRecyclerView = recyclerView;
        View columnView = this.mColumnLayout.getChildAt(this.getColumnOfList(recyclerView));
        this.mDragColumn.startDrag(columnView, posX, posY);
        this.mRootLayout.addView(this.mDragColumn.getDragItemView());
        columnView.setAlpha(0.0f);
        if (this.mBoardListener != null) {
            this.mBoardListener.onColumnDragStarted(this.getColumnOfList(this.mCurrentRecyclerView));
        }
    }

    private void endDragColumn() {
        this.mDragColumn.endDrag(this.mDragColumn.getRealDragView(), new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BoardView.this.mDragColumn.getRealDragView().setAlpha(1.0f);
                BoardView.this.mDragColumn.hide();
                BoardView.this.mRootLayout.removeView(BoardView.this.mDragColumn.getDragItemView());
                if (BoardView.this.mBoardListener != null) {
                    BoardView.this.mBoardListener.onColumnDragEnded(BoardView.this.getColumnOfList(BoardView.this.mCurrentRecyclerView));
                }
            }
        });
    }

    private void moveColumn(int fromIndex, int toIndex) {
        DragItemRecyclerView list = this.mLists.remove(fromIndex);
        this.mLists.add(toIndex, list);
        View header = this.mHeaders.remove(fromIndex);
        this.mHeaders.add(toIndex, header);
        final View column1 = this.mColumnLayout.getChildAt(fromIndex);
        final View column2 = this.mColumnLayout.getChildAt(toIndex);
        this.mColumnLayout.removeViewAt(fromIndex);
        this.mColumnLayout.addView(column1, toIndex);
        this.mColumnLayout.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                BoardView.this.mColumnLayout.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                column2.setTranslationX(column2.getTranslationX() + (float)column1.getLeft() - (float)column2.getLeft());
                column2.animate().translationX(0.0f).setDuration(350L).start();
            }
        });
        if (this.mBoardListener != null) {
            this.mBoardListener.onColumnDragChangedPosition(fromIndex, toIndex);
        }
    }

    public DragItemRecyclerView insertColumn(DragItemAdapter adapter, int index, @Nullable View header, @Nullable View columnDragView, boolean hasFixedItemSize) {
        DragItemRecyclerView recyclerView = this.insertColumn(adapter, index, header, hasFixedItemSize);
        this.setupColumnDragListener(columnDragView, recyclerView);
        return recyclerView;
    }

    public DragItemRecyclerView addColumn(DragItemAdapter adapter, @Nullable View header, @Nullable View columnDragView, boolean hasFixedItemSize) {
        DragItemRecyclerView recyclerView = this.insertColumn(adapter, this.getColumnCount(), header, hasFixedItemSize);
        this.setupColumnDragListener(columnDragView, recyclerView);
        return recyclerView;
    }

    private void setupColumnDragListener(View columnDragView, final DragItemRecyclerView recyclerView) {
        if (columnDragView != null) {
            columnDragView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    BoardView.this.startDragColumn(recyclerView, BoardView.this.mTouchX, BoardView.this.mTouchY);
                    return true;
                }
            });
        }
    }

    public int getmColumnSpacing() {
        return this.mColumnSpacing;
    }

    private DragItemRecyclerView insertColumn(DragItemAdapter adapter, int index, @Nullable View header, boolean hasFixedItemSize) {
        if (index > this.getColumnCount()) {
            throw new IllegalArgumentException("Index is out of bounds");
        }
        final DragItemRecyclerView recyclerView = (DragItemRecyclerView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.drag_item_recycler_view, (ViewGroup)this, false);
        recyclerView.setId(this.getColumnCount());
        recyclerView.setHorizontalScrollBarEnabled(false);
        recyclerView.setVerticalScrollBarEnabled(false);
        recyclerView.setMotionEventSplittingEnabled(false);
        recyclerView.setDragItem(this.mDragItem);
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        recyclerView.setHasFixedSize(hasFixedItemSize);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        recyclerView.setDragItemListener(new DragItemRecyclerView.DragItemListener(){

            @Override
            public void onDragStarted(int itemPosition, float x, float y) {
                BoardView.this.mDragStartColumn = BoardView.this.getColumnOfList(recyclerView);
                BoardView.this.mDragStartRow = itemPosition;
                BoardView.this.mCurrentRecyclerView = recyclerView;
                BoardView.this.mDragItem.setOffset(((View)BoardView.this.mCurrentRecyclerView.getParent()).getX(), BoardView.this.mCurrentRecyclerView.getY());
                if (BoardView.this.mBoardListener != null) {
                    BoardView.this.mBoardListener.onItemDragStarted(BoardView.this.mDragStartColumn, BoardView.this.mDragStartRow);
                }
                BoardView.this.invalidate();
            }

            @Override
            public void onDragging(int itemPosition, float x, float y) {
                boolean positionChanged;
                int column = BoardView.this.getColumnOfList(recyclerView);
                boolean bl = positionChanged = column != BoardView.this.mLastDragColumn || itemPosition != BoardView.this.mLastDragRow;
                if (BoardView.this.mBoardListener != null) {
                    BoardView.this.mBoardListener.onDragPointChange(x, y);
                    if (positionChanged) {
                        BoardView.this.mLastDragColumn = column;
                        BoardView.this.mLastDragRow = itemPosition;
                        BoardView.this.mBoardListener.onItemChangedPosition(BoardView.this.mDragStartColumn, BoardView.this.mDragStartRow, column, itemPosition);
                    }
                }
            }

            @Override
            public void onDragEnded(int newItemPosition) {
                BoardView.this.mLastDragColumn = -1;
                BoardView.this.mLastDragRow = -1;
                if (BoardView.this.mBoardListener != null) {
                    BoardView.this.mBoardListener.onItemDragEnded(BoardView.this.mDragStartColumn, BoardView.this.mDragStartRow, BoardView.this.getColumnOfList(recyclerView), newItemPosition);
                }
            }
        });
        recyclerView.setDragItemCallback(new DragItemRecyclerView.DragItemCallback(){

            @Override
            public boolean canDragItemAtPosition(int dragPosition) {
                int column = BoardView.this.getColumnOfList(recyclerView);
                return BoardView.this.mBoardCallback == null || BoardView.this.mBoardCallback.canDragItemAtPosition(column, dragPosition);
            }

            @Override
            public boolean canDropItemAtPosition(int dropPosition) {
                int column = BoardView.this.getColumnOfList(recyclerView);
                return BoardView.this.mBoardCallback == null || BoardView.this.mBoardCallback.canDropItemAtPosition(BoardView.this.mDragStartColumn, BoardView.this.mDragStartRow, column, dropPosition);
            }
        });
        recyclerView.setAdapter(adapter);
        recyclerView.setDragEnabled(this.mDragEnabled);
        adapter.setDragStartedListener(new DragItemAdapter.DragStartCallback(){

            @Override
            public boolean startDrag(View itemView, long itemId) {
                return recyclerView.startDrag(itemView, itemId, BoardView.this.getRelativeViewTouchX((View)recyclerView.getParent()), BoardView.this.getRelativeViewTouchY((View)recyclerView));
            }

            @Override
            public boolean isDragging() {
                return recyclerView.isDragging();
            }
        });
        LinearLayout layout2 = new LinearLayout(this.getContext());
        layout2.setOrientation(1);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.mColumnWidth, -1);
        layout2.setLayoutParams((ViewGroup.LayoutParams)params);
        View columnHeader = header;
        if (header == null) {
            columnHeader = new View(this.getContext());
            columnHeader.setVisibility(8);
        }
        try {
            if (Build.VERSION.SDK_INT >= 16) {
                if (this.mListBackgroundDrawable != 0) {
                    recyclerView.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)this.mListBackgroundDrawable));
                } else if (this.mListBackgroundColor != 0) {
                    recyclerView.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)this.mListBackgroundColor));
                }
            }
        }
        catch (Exception ex) {
            Log.w((String)"boardView", (String)"could not resolve resources provided as list background");
        }
        layout2.addView(columnHeader);
        this.mHeaders.add(columnHeader);
        layout2.addView((View)recyclerView);
        this.mLists.add(index, recyclerView);
        int leftMargin = index == 0 ? this.mColumnSpacing : 0;
        layout2.setPadding(leftMargin, 0, this.mColumnSpacing, 0);
        this.mColumnLayout.addView((View)layout2, index);
        return recyclerView;
    }

    static class SavedState
    extends View.BaseSavedState {
        public int currentColumn;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int currentColumn) {
            super(superState);
            this.currentColumn = currentColumn;
        }

        public SavedState(Parcel source) {
            super(source);
            this.currentColumn = source.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentColumn);
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private float mStartScrollX;
        private int mStartColumn;

        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            this.mStartScrollX = BoardView.this.getScrollX();
            this.mStartColumn = BoardView.this.mCurrentColumn;
            return super.onDown(e);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            boolean wrongSnapDirection;
            int closestColumn = BoardView.this.getClosestSnapColumn();
            int newColumn = closestColumn;
            boolean bl = wrongSnapDirection = newColumn > this.mStartColumn && velocityX > 0.0f || newColumn < this.mStartColumn && velocityX < 0.0f;
            if (this.mStartScrollX == (float)BoardView.this.getScrollX()) {
                newColumn = this.mStartColumn;
            } else if (this.mStartColumn == closestColumn || wrongSnapDirection) {
                newColumn = velocityX < 0.0f ? closestColumn + 1 : closestColumn - 1;
            }
            if (newColumn < 0 || newColumn > BoardView.this.mLists.size() - 1) {
                newColumn = newColumn < 0 ? 0 : BoardView.this.mLists.size() - 1;
            }
            BoardView.this.scrollToColumn(newColumn, true);
            return true;
        }
    }

    public static enum ColumnSnapPosition {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static abstract class BoardListenerAdapter
    implements BoardListener {
        @Override
        public void onItemDragStarted(int column, int row) {
        }

        @Override
        public void onItemDragEnded(int fromColumn, int fromRow, int toColumn, int toRow) {
        }

        @Override
        public void onItemChangedPosition(int oldColumn, int oldRow, int newColumn, int newRow) {
        }

        @Override
        public void onItemChangedColumn(int oldColumn, int newColumn) {
        }

        @Override
        public void onFocusedColumnChanged(int oldColumn, int newColumn) {
        }

        @Override
        public void onColumnDragStarted(int position) {
        }

        @Override
        public void onColumnDragChangedPosition(int oldPosition, int newPosition) {
        }

        @Override
        public void onColumnDragEnded(int position) {
        }
    }

    public static interface BoardListener {
        public void onItemDragStarted(int var1, int var2);

        public void onItemDragEnded(int var1, int var2, int var3, int var4);

        public void onItemChangedPosition(int var1, int var2, int var3, int var4);

        public void onDragPointChange(float var1, float var2);

        public void onItemChangedColumn(int var1, int var2);

        public void onFocusedColumnChanged(int var1, int var2);

        public void onColumnDragStarted(int var1);

        public void onColumnDragChangedPosition(int var1, int var2);

        public void onColumnDragEnded(int var1);
    }

    public static interface BoardCallback {
        public boolean canDragItemAtPosition(int var1, int var2);

        public boolean canDropItemAtPosition(int var1, int var2, int var3, int var4);
    }
}

