/*
 * Decompiled with CFR 0.152.
 */
package com.woxthebox.draglistview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.lshershun.draglistview.R;
import com.woxthebox.draglistview.DragItem;
import com.woxthebox.draglistview.DragItemAdapter;
import com.woxthebox.draglistview.DragItemRecyclerView;
import com.woxthebox.draglistview.swipe.ListSwipeHelper;

public class DragListView
extends FrameLayout {
    private DragItemRecyclerView mRecyclerView;
    private DragListListener mDragListListener;
    private DragListCallback mDragListCallback;
    private DragItem mDragItem;
    private ListSwipeHelper mSwipeHelper;
    private float mTouchX;
    private float mTouchY;

    public DragListView(Context context) {
        super(context);
    }

    public DragListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DragListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mDragItem = new DragItem(this.getContext());
        this.mRecyclerView = this.createRecyclerView();
        this.mRecyclerView.setDragItem(this.mDragItem);
        this.addView((View)this.mRecyclerView);
        this.addView(this.mDragItem.getDragItemView());
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        boolean retValue = this.handleTouchEvent(event);
        return retValue || super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean retValue = this.handleTouchEvent(event);
        return retValue || super.onTouchEvent(event);
    }

    private boolean handleTouchEvent(MotionEvent event) {
        this.mTouchX = event.getX();
        this.mTouchY = event.getY();
        if (this.isDragging()) {
            switch (event.getAction()) {
                case 2: {
                    this.mRecyclerView.onDragging(event.getX(), event.getY());
                    break;
                }
                case 1: 
                case 3: {
                    this.mRecyclerView.onDragEnded();
                }
            }
            return true;
        }
        return false;
    }

    private DragItemRecyclerView createRecyclerView() {
        DragItemRecyclerView recyclerView = (DragItemRecyclerView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.drag_item_recycler_view, (ViewGroup)this, false);
        recyclerView.setMotionEventSplittingEnabled(false);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        recyclerView.setVerticalScrollBarEnabled(false);
        recyclerView.setHorizontalScrollBarEnabled(false);
        recyclerView.setDragItemListener(new DragItemRecyclerView.DragItemListener(){
            private int mDragStartPosition;

            @Override
            public void onDragStarted(int itemPosition, float x, float y) {
                DragListView.this.getParent().requestDisallowInterceptTouchEvent(true);
                this.mDragStartPosition = itemPosition;
                if (DragListView.this.mDragListListener != null) {
                    DragListView.this.mDragListListener.onItemDragStarted(itemPosition);
                }
            }

            @Override
            public void onDragging(int itemPosition, float x, float y) {
                if (DragListView.this.mDragListListener != null) {
                    DragListView.this.mDragListListener.onItemDragging(itemPosition, x, y);
                }
            }

            @Override
            public void onDragEnded(int newItemPosition) {
                if (DragListView.this.mDragListListener != null) {
                    DragListView.this.mDragListListener.onItemDragEnded(this.mDragStartPosition, newItemPosition);
                }
            }
        });
        recyclerView.setDragItemCallback(new DragItemRecyclerView.DragItemCallback(){

            @Override
            public boolean canDragItemAtPosition(int dragPosition) {
                return DragListView.this.mDragListCallback == null || DragListView.this.mDragListCallback.canDragItemAtPosition(dragPosition);
            }

            @Override
            public boolean canDropItemAtPosition(int dropPosition) {
                return DragListView.this.mDragListCallback == null || DragListView.this.mDragListCallback.canDropItemAtPosition(dropPosition);
            }
        });
        return recyclerView;
    }

    public void setSwipeListener(ListSwipeHelper.OnSwipeListener swipeListener) {
        if (this.mSwipeHelper == null) {
            this.mSwipeHelper = new ListSwipeHelper(this.getContext().getApplicationContext(), swipeListener);
        } else {
            this.mSwipeHelper.setSwipeListener(swipeListener);
        }
        this.mSwipeHelper.detachFromRecyclerView();
        if (swipeListener != null) {
            this.mSwipeHelper.attachToRecyclerView(this.mRecyclerView);
        }
    }

    public void resetSwipedViews(View exceptionView) {
        if (this.mSwipeHelper != null) {
            this.mSwipeHelper.resetSwipedViews(exceptionView);
        }
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public DragItemAdapter getAdapter() {
        if (this.mRecyclerView != null) {
            return (DragItemAdapter)this.mRecyclerView.getAdapter();
        }
        return null;
    }

    public void setAdapter(DragItemAdapter adapter, boolean hasFixedItemSize) {
        this.mRecyclerView.setHasFixedSize(hasFixedItemSize);
        this.mRecyclerView.setAdapter(adapter);
        adapter.setDragStartedListener(new DragItemAdapter.DragStartCallback(){

            @Override
            public boolean startDrag(View itemView, long itemId) {
                return DragListView.this.mRecyclerView.startDrag(itemView, itemId, DragListView.this.mTouchX, DragListView.this.mTouchY);
            }

            @Override
            public boolean isDragging() {
                return DragListView.this.mRecyclerView.isDragging();
            }
        });
    }

    public void swapAdapter(DragItemAdapter adapter, boolean removeAndRecycleExisting) {
        this.mRecyclerView.swapAdapter(adapter, removeAndRecycleExisting);
        adapter.setDragStartedListener(new DragItemAdapter.DragStartCallback(){

            @Override
            public boolean startDrag(View itemView, long itemId) {
                return DragListView.this.mRecyclerView.startDrag(itemView, itemId, DragListView.this.mTouchX, DragListView.this.mTouchY);
            }

            @Override
            public boolean isDragging() {
                return DragListView.this.mRecyclerView.isDragging();
            }
        });
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout2) {
        this.mRecyclerView.setLayoutManager(layout2);
    }

    public void setDragListListener(DragListListener listener) {
        this.mDragListListener = listener;
    }

    public void setDragListCallback(DragListCallback callback) {
        this.mDragListCallback = callback;
    }

    public boolean isDragEnabled() {
        return this.mRecyclerView.isDragEnabled();
    }

    public void setDragEnabled(boolean enabled) {
        this.mRecyclerView.setDragEnabled(enabled);
    }

    public void setCustomDragItem(DragItem dragItem) {
        this.removeViewAt(1);
        DragItem newDragItem = dragItem != null ? dragItem : new DragItem(this.getContext());
        newDragItem.setCanDragHorizontally(this.mDragItem.canDragHorizontally());
        newDragItem.setSnapToTouch(this.mDragItem.isSnapToTouch());
        this.mDragItem = newDragItem;
        this.mRecyclerView.setDragItem(this.mDragItem);
        this.addView(this.mDragItem.getDragItemView());
    }

    public boolean isDragging() {
        return this.mRecyclerView.isDragging();
    }

    public void setCanDragHorizontally(boolean canDragHorizontally) {
        this.mDragItem.setCanDragHorizontally(canDragHorizontally);
    }

    public void setSnapDragItemToTouch(boolean snapToTouch) {
        this.mDragItem.setSnapToTouch(snapToTouch);
    }

    public void setCanNotDragAboveTopItem(boolean canNotDragAboveTop) {
        this.mRecyclerView.setCanNotDragAboveTopItem(canNotDragAboveTop);
    }

    public void setCanNotDragBelowBottomItem(boolean canNotDragBelowBottom) {
        this.mRecyclerView.setCanNotDragBelowBottomItem(canNotDragBelowBottom);
    }

    public void setScrollingEnabled(boolean scrollingEnabled) {
        this.mRecyclerView.setScrollingEnabled(scrollingEnabled);
    }

    public void setDisableReorderWhenDragging(boolean disableReorder) {
        this.mRecyclerView.setDisableReorderWhenDragging(disableReorder);
    }

    public void setDropTargetDrawables(Drawable backgroundDrawable, Drawable foregroundDrawable) {
        this.mRecyclerView.setDropTargetDrawables(backgroundDrawable, foregroundDrawable);
    }

    public static abstract class DragListCallbackAdapter
    implements DragListCallback {
        @Override
        public boolean canDragItemAtPosition(int dragPosition) {
            return true;
        }

        @Override
        public boolean canDropItemAtPosition(int dropPosition) {
            return true;
        }
    }

    public static interface DragListCallback {
        public boolean canDragItemAtPosition(int var1);

        public boolean canDropItemAtPosition(int var1);
    }

    public static abstract class DragListListenerAdapter
    implements DragListListener {
        @Override
        public void onItemDragStarted(int position) {
        }

        @Override
        public void onItemDragging(int itemPosition, float x, float y) {
        }

        @Override
        public void onItemDragEnded(int fromPosition, int toPosition) {
        }
    }

    public static interface DragListListener {
        public void onItemDragStarted(int var1);

        public void onItemDragging(int var1, float var2, float var3);

        public void onItemDragEnded(int var1, int var2);
    }
}

