/*
 * Decompiled with CFR 0.152.
 */
package com.woxthebox.draglistview;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import java.util.Collections;
import java.util.List;

public abstract class DragItemAdapter<T, VH extends ViewHolder>
extends RecyclerView.Adapter<VH> {
    private DragStartCallback mDragStartCallback;
    private long mDragItemId = -1L;
    private long mDropTargetId = -1L;
    protected List<T> mItemList;

    public abstract long getUniqueItemId(int var1);

    public DragItemAdapter() {
        this.setHasStableIds(true);
    }

    public void setItemList(List<T> itemList) {
        this.mItemList = itemList;
        this.notifyDataSetChanged();
    }

    public List<T> getItemList() {
        return this.mItemList;
    }

    public int getPositionForItem(T item) {
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (this.mItemList.get(i) != item) continue;
            return i;
        }
        return -1;
    }

    public Object removeItem(int pos) {
        if (this.mItemList != null && this.mItemList.size() > pos && pos >= 0) {
            T item = this.mItemList.remove(pos);
            this.notifyItemRemoved(pos);
            return item;
        }
        return null;
    }

    public void addItem(int pos, T item) {
        if (this.mItemList != null && this.mItemList.size() >= pos) {
            this.mItemList.add(pos, item);
            this.notifyItemInserted(pos);
        }
    }

    public void changeItemPosition(int fromPos, int toPos) {
        if (this.mItemList != null && this.mItemList.size() > fromPos && this.mItemList.size() > toPos) {
            T item = this.mItemList.remove(fromPos);
            this.mItemList.add(toPos, item);
            this.notifyItemMoved(fromPos, toPos);
        }
    }

    public void swapItems(int pos1, int pos2) {
        if (this.mItemList != null && this.mItemList.size() > pos1 && this.mItemList.size() > pos2) {
            Collections.swap(this.mItemList, pos1, pos2);
            this.notifyDataSetChanged();
        }
    }

    public int getPositionForItemId(long id) {
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (id != this.getItemId(i)) continue;
            return i;
        }
        return -1;
    }

    public final long getItemId(int position) {
        return this.getUniqueItemId(position);
    }

    public int getItemCount() {
        return this.mItemList == null ? 0 : this.mItemList.size();
    }

    @CallSuper
    public void onBindViewHolder(@NonNull VH holder, int position) {
        long itemId;
        ((ViewHolder)((Object)holder)).mItemId = itemId = this.getItemId(position);
        ((ViewHolder)((Object)holder)).itemView.setVisibility(this.mDragItemId == itemId ? 4 : 0);
        ((ViewHolder)((Object)holder)).setDragStartCallback(this.mDragStartCallback);
    }

    public void onViewRecycled(@NonNull VH holder) {
        super.onViewRecycled(holder);
        ((ViewHolder)((Object)holder)).setDragStartCallback(null);
    }

    void setDragStartedListener(DragStartCallback dragStartedListener) {
        this.mDragStartCallback = dragStartedListener;
    }

    void setDragItemId(long dragItemId) {
        this.mDragItemId = dragItemId;
    }

    void setDropTargetId(long dropTargetId) {
        this.mDropTargetId = dropTargetId;
    }

    public long getDropTargetId() {
        return this.mDropTargetId;
    }

    public static abstract class ViewHolder
    extends RecyclerView.ViewHolder {
        public View mGrabView;
        public long mItemId;
        private DragStartCallback mDragStartCallback;

        public ViewHolder(final View itemView, int handleResId, boolean dragOnLongPress) {
            super(itemView);
            this.mGrabView = itemView.findViewById(handleResId);
            if (dragOnLongPress) {
                this.mGrabView.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View view) {
                        if (ViewHolder.this.mDragStartCallback == null) {
                            return false;
                        }
                        if (ViewHolder.this.mDragStartCallback.startDrag(itemView, ViewHolder.this.mItemId)) {
                            return true;
                        }
                        if (itemView == ViewHolder.this.mGrabView) {
                            return ViewHolder.this.onItemLongClicked(view);
                        }
                        return false;
                    }
                });
            } else {
                this.mGrabView.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View view, MotionEvent event) {
                        if (ViewHolder.this.mDragStartCallback == null) {
                            return false;
                        }
                        if (event.getAction() == 0 && ViewHolder.this.mDragStartCallback.startDrag(itemView, ViewHolder.this.mItemId)) {
                            return true;
                        }
                        if (!ViewHolder.this.mDragStartCallback.isDragging() && itemView == ViewHolder.this.mGrabView) {
                            return ViewHolder.this.onItemTouch(view, event);
                        }
                        return false;
                    }
                });
            }
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ViewHolder.this.onItemClicked(view);
                }
            });
            if (itemView != this.mGrabView) {
                itemView.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View view) {
                        return ViewHolder.this.onItemLongClicked(view);
                    }
                });
                itemView.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View view, MotionEvent event) {
                        return ViewHolder.this.onItemTouch(view, event);
                    }
                });
            }
        }

        public void setDragStartCallback(DragStartCallback dragStartedListener) {
            this.mDragStartCallback = dragStartedListener;
        }

        public void onItemClicked(View view) {
        }

        public boolean onItemLongClicked(View view) {
            return false;
        }

        public boolean onItemTouch(View view, MotionEvent event) {
            return false;
        }
    }

    static interface DragStartCallback {
        public boolean startDrag(View var1, long var2);

        public boolean isDragging();
    }
}

