/*
 * Decompiled with CFR 0.152.
 */
package com.woxthebox.draglistview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;

public class DragItem {
    protected static final int ANIMATION_DURATION = 250;
    private View mDragView;
    private View mRealDragView;
    private float mOffsetX;
    private float mOffsetY;
    private float mPosX;
    private float mPosY;
    private float mPosTouchDx;
    private float mPosTouchDy;
    private float mAnimationDx;
    private float mAnimationDy;
    private boolean mCanDragHorizontally = true;
    private boolean mSnapToTouch = true;

    DragItem(Context context) {
        this.mDragView = new View(context);
        this.hide();
    }

    public DragItem(Context context, int layoutId) {
        this.mDragView = View.inflate((Context)context, (int)layoutId, null);
        this.hide();
    }

    public void onBindDragView(View clickedView, View dragView) {
        Bitmap bitmap = Bitmap.createBitmap((int)clickedView.getWidth(), (int)clickedView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        clickedView.draw(canvas);
        if (Build.VERSION.SDK_INT >= 16) {
            dragView.setBackground((Drawable)new BitmapDrawable(clickedView.getResources(), bitmap));
        } else {
            dragView.setBackgroundDrawable((Drawable)new BitmapDrawable(clickedView.getResources(), bitmap));
        }
    }

    public void onMeasureDragView(View clickedView, View dragView) {
        dragView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(clickedView.getMeasuredWidth(), clickedView.getMeasuredHeight()));
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)clickedView.getMeasuredWidth(), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)clickedView.getMeasuredHeight(), (int)0x40000000);
        dragView.measure(widthSpec, heightSpec);
    }

    public void onStartDragAnimation(View dragView) {
    }

    public void onEndDragAnimation(View dragView) {
    }

    boolean canDragHorizontally() {
        return this.mCanDragHorizontally;
    }

    void setCanDragHorizontally(boolean canDragHorizontally) {
        this.mCanDragHorizontally = canDragHorizontally;
    }

    boolean isSnapToTouch() {
        return this.mSnapToTouch;
    }

    protected void setSnapToTouch(boolean snapToTouch) {
        this.mSnapToTouch = snapToTouch;
    }

    View getDragItemView() {
        return this.mDragView;
    }

    View getRealDragView() {
        return this.mRealDragView;
    }

    private void show() {
        this.mDragView.setVisibility(0);
    }

    void hide() {
        this.mDragView.setVisibility(8);
        this.mRealDragView = null;
    }

    boolean isDragging() {
        return this.mDragView.getVisibility() == 0;
    }

    void startDrag(View startFromView, float touchX, float touchY) {
        this.show();
        this.mRealDragView = startFromView;
        this.onBindDragView(startFromView, this.mDragView);
        this.onMeasureDragView(startFromView, this.mDragView);
        this.onStartDragAnimation(this.mDragView);
        float startX = startFromView.getX() - (float)((this.mDragView.getMeasuredWidth() - startFromView.getMeasuredWidth()) / 2) + (float)(this.mDragView.getMeasuredWidth() / 2);
        float startY = startFromView.getY() - (float)((this.mDragView.getMeasuredHeight() - startFromView.getMeasuredHeight()) / 2) + (float)(this.mDragView.getMeasuredHeight() / 2);
        if (this.mSnapToTouch) {
            this.mPosTouchDx = 0.0f;
            this.mPosTouchDy = 0.0f;
            this.setPosition(touchX, touchY);
            this.setAnimationDx(startX - touchX);
            this.setAnimationDY(startY - touchY);
            PropertyValuesHolder pvhX = PropertyValuesHolder.ofFloat((String)"AnimationDx", (float[])new float[]{this.mAnimationDx, 0.0f});
            PropertyValuesHolder pvhY = PropertyValuesHolder.ofFloat((String)"AnimationDY", (float[])new float[]{this.mAnimationDy, 0.0f});
            ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)this, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhX, pvhY});
            anim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            anim.setDuration(250L);
            anim.start();
        } else {
            this.mPosTouchDx = startX - touchX;
            this.mPosTouchDy = startY - touchY;
            this.setPosition(touchX, touchY);
        }
    }

    void endDrag(View endToView, AnimatorListenerAdapter listener) {
        this.onEndDragAnimation(this.mDragView);
        float endX = endToView.getX() - (float)((this.mDragView.getMeasuredWidth() - endToView.getMeasuredWidth()) / 2) + (float)(this.mDragView.getMeasuredWidth() / 2);
        float endY = endToView.getY() - (float)((this.mDragView.getMeasuredHeight() - endToView.getMeasuredHeight()) / 2) + (float)(this.mDragView.getMeasuredHeight() / 2);
        PropertyValuesHolder pvhX = PropertyValuesHolder.ofFloat((String)"X", (float[])new float[]{this.mPosX, endX});
        PropertyValuesHolder pvhY = PropertyValuesHolder.ofFloat((String)"Y", (float[])new float[]{this.mPosY, endY});
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)this, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhX, pvhY});
        anim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        anim.setDuration(250L);
        anim.addListener((Animator.AnimatorListener)listener);
        anim.start();
    }

    void setAnimationDx(float x) {
        this.mAnimationDx = x;
        this.updatePosition();
    }

    void setAnimationDY(float y) {
        this.mAnimationDy = y;
        this.updatePosition();
    }

    void setX(float x) {
        this.mPosX = x;
        this.updatePosition();
    }

    void setY(float y) {
        this.mPosY = y;
        this.updatePosition();
    }

    float getX() {
        return this.mPosX;
    }

    float getY() {
        return this.mPosY;
    }

    void setPosition(float touchX, float touchY) {
        this.mPosX = touchX + this.mPosTouchDx;
        this.mPosY = touchY + this.mPosTouchDy;
        this.updatePosition();
    }

    void setOffset(float offsetX, float offsetY) {
        this.mOffsetX = offsetX;
        this.mOffsetY = offsetY;
        this.updatePosition();
    }

    private void updatePosition() {
        if (this.mCanDragHorizontally) {
            this.mDragView.setX(this.mPosX + this.mOffsetX + this.mAnimationDx - (float)(this.mDragView.getMeasuredWidth() / 2));
        }
        this.mDragView.setY(this.mPosY + this.mOffsetY + this.mAnimationDy - (float)(this.mDragView.getMeasuredHeight() / 2));
        this.mDragView.invalidate();
    }
}

