/*
 * Decompiled with CFR 0.152.
 */
package com.woxthebox.draglistview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.woxthebox.draglistview.AutoScroller;
import com.woxthebox.draglistview.DragItem;
import com.woxthebox.draglistview.DragItemAdapter;

public class DragItemRecyclerView
extends RecyclerView
implements AutoScroller.AutoScrollListener {
    private AutoScroller mAutoScroller;
    private DragItemListener mListener;
    private DragItemCallback mDragCallback;
    private DragState mDragState = DragState.DRAG_ENDED;
    private DragItemAdapter mAdapter;
    private DragItem mDragItem;
    private Drawable mDropTargetBackgroundDrawable;
    private Drawable mDropTargetForegroundDrawable;
    private long mDragItemId = -1L;
    private boolean mHoldChangePosition;
    private int mDragItemPosition;
    private int mTouchSlop;
    private float mStartY;
    private boolean mClipToPadding;
    private boolean mCanNotDragAboveTop;
    private boolean mCanNotDragBelowBottom;
    private boolean mScrollingEnabled = true;
    private boolean mDisableReorderWhenDragging;
    private boolean mDragEnabled = true;

    public DragItemRecyclerView(Context context) {
        super(context);
        this.init();
    }

    public DragItemRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.init();
    }

    public DragItemRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mAutoScroller = new AutoScroller(this.getContext(), this);
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.addItemDecoration(new RecyclerView.ItemDecoration(){

            public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
                super.onDraw(c, parent, state);
                this.drawDecoration(c, parent, DragItemRecyclerView.this.mDropTargetBackgroundDrawable);
            }

            public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
                super.onDrawOver(c, parent, state);
                this.drawDecoration(c, parent, DragItemRecyclerView.this.mDropTargetForegroundDrawable);
            }

            private void drawDecoration(Canvas c, RecyclerView parent, Drawable drawable) {
                if (DragItemRecyclerView.this.mAdapter == null || DragItemRecyclerView.this.mAdapter.getDropTargetId() == -1L || drawable == null) {
                    return;
                }
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    View item = parent.getChildAt(i);
                    int pos = DragItemRecyclerView.this.getChildAdapterPosition(item);
                    if (pos == -1 || DragItemRecyclerView.this.mAdapter.getItemId(pos) != DragItemRecyclerView.this.mAdapter.getDropTargetId()) continue;
                    drawable.setBounds(item.getLeft(), item.getTop(), item.getRight(), item.getBottom());
                    drawable.draw(c);
                }
            }
        });
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.mScrollingEnabled) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.mStartY = event.getY();
                break;
            }
            case 2: {
                float diffY = Math.abs(event.getY() - this.mStartY);
                if (!((double)diffY > (double)this.mTouchSlop * 0.5)) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    void setDragEnabled(boolean enabled) {
        this.mDragEnabled = enabled;
    }

    boolean isDragEnabled() {
        return this.mDragEnabled;
    }

    void setCanNotDragAboveTopItem(boolean canNotDragAboveTop) {
        this.mCanNotDragAboveTop = canNotDragAboveTop;
    }

    void setCanNotDragBelowBottomItem(boolean canNotDragBelowBottom) {
        this.mCanNotDragBelowBottom = canNotDragBelowBottom;
    }

    void setScrollingEnabled(boolean scrollingEnabled) {
        this.mScrollingEnabled = scrollingEnabled;
    }

    void setDisableReorderWhenDragging(boolean disableReorder) {
        this.mDisableReorderWhenDragging = disableReorder;
    }

    public void setDropTargetDrawables(Drawable backgroundDrawable, Drawable foregroundDrawable) {
        this.mDropTargetBackgroundDrawable = backgroundDrawable;
        this.mDropTargetForegroundDrawable = foregroundDrawable;
    }

    void setDragItemListener(DragItemListener listener) {
        this.mListener = listener;
    }

    void setDragItemCallback(DragItemCallback callback) {
        this.mDragCallback = callback;
    }

    void setDragItem(DragItem dragItem) {
        this.mDragItem = dragItem;
    }

    boolean isDragging() {
        return this.mDragState != DragState.DRAG_ENDED;
    }

    long getDragItemId() {
        return this.mDragItemId;
    }

    public void setClipToPadding(boolean clipToPadding) {
        super.setClipToPadding(clipToPadding);
        this.mClipToPadding = clipToPadding;
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (!this.isInEditMode()) {
            if (!(adapter instanceof DragItemAdapter)) {
                throw new RuntimeException("Adapter must extend DragItemAdapter");
            }
            if (!adapter.hasStableIds()) {
                throw new RuntimeException("Adapter must have stable ids");
            }
        }
        super.setAdapter(adapter);
        this.mAdapter = (DragItemAdapter)adapter;
    }

    public void swapAdapter(RecyclerView.Adapter adapter, boolean r) {
        if (!this.isInEditMode()) {
            if (!(adapter instanceof DragItemAdapter)) {
                throw new RuntimeException("Adapter must extend DragItemAdapter");
            }
            if (!adapter.hasStableIds()) {
                throw new RuntimeException("Adapter must have stable ids");
            }
        }
        super.swapAdapter(adapter, r);
        this.mAdapter = (DragItemAdapter)adapter;
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout2) {
        super.setLayoutManager(layout2);
        if (!(layout2 instanceof LinearLayoutManager)) {
            throw new RuntimeException("Layout must be an instance of LinearLayoutManager");
        }
    }

    @Override
    public void onAutoScrollPositionBy(int dx, int dy) {
        if (this.isDragging()) {
            this.scrollBy(dx, dy);
            this.updateDragPositionAndScroll();
        } else {
            this.mAutoScroller.stopAutoScroll();
        }
    }

    @Override
    public void onAutoScrollColumnBy(int columns) {
    }

    public View findChildView(float x, float y) {
        int count = this.getChildCount();
        if (y <= 0.0f && count > 0) {
            return this.getChildAt(0);
        }
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            if (!(x >= (float)(child.getLeft() - params.leftMargin)) || !(x <= (float)(child.getRight() + params.rightMargin)) || !(y >= (float)(child.getTop() - params.topMargin)) || !(y <= (float)(child.getBottom() + params.bottomMargin))) continue;
            return child;
        }
        return null;
    }

    private boolean shouldChangeItemPosition(int newPos) {
        if (this.mHoldChangePosition || this.mDragItemPosition == -1 || this.mDragItemPosition == newPos) {
            return false;
        }
        if (this.mCanNotDragAboveTop && newPos == 0 || this.mCanNotDragBelowBottom && newPos == this.mAdapter.getItemCount() - 1) {
            return false;
        }
        return this.mDragCallback == null || this.mDragCallback.canDropItemAtPosition(newPos);
    }

    private void updateDragPositionAndScroll() {
        boolean linearLayoutManager;
        View view = this.findChildView(this.mDragItem.getX(), this.mDragItem.getY());
        int newPos = this.getChildLayoutPosition(view);
        if (newPos == -1 || view == null) {
            return;
        }
        boolean bl = linearLayoutManager = this.getLayoutManager() instanceof LinearLayoutManager && !(this.getLayoutManager() instanceof GridLayoutManager);
        if (linearLayoutManager) {
            boolean movedPassedCenterY;
            boolean dragDown;
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            int viewHeight = view.getMeasuredHeight() + params.topMargin + params.bottomMargin;
            int viewCenterY = view.getTop() - params.topMargin + viewHeight / 2;
            boolean bl2 = dragDown = this.mDragItemPosition < this.getChildLayoutPosition(view);
            boolean bl3 = dragDown ? this.mDragItem.getY() > (float)viewCenterY : (movedPassedCenterY = this.mDragItem.getY() < (float)viewCenterY);
            if (viewHeight > this.mDragItem.getDragItemView().getMeasuredHeight() && !movedPassedCenterY) {
                newPos = this.mDragItemPosition;
            }
        }
        LinearLayoutManager layoutManager = (LinearLayoutManager)this.getLayoutManager();
        if (this.shouldChangeItemPosition(newPos)) {
            if (this.mDisableReorderWhenDragging) {
                this.mAdapter.setDropTargetId(this.mAdapter.getItemId(newPos));
                this.mAdapter.notifyDataSetChanged();
            } else {
                int pos = layoutManager.findFirstVisibleItemPosition();
                View posView = layoutManager.findViewByPosition(pos);
                this.mAdapter.changeItemPosition(this.mDragItemPosition, newPos);
                this.mDragItemPosition = newPos;
                if (layoutManager.getOrientation() == 1) {
                    int topMargin = ((ViewGroup.MarginLayoutParams)posView.getLayoutParams()).topMargin;
                    layoutManager.scrollToPositionWithOffset(pos, posView.getTop() - topMargin);
                } else {
                    int leftMargin = ((ViewGroup.MarginLayoutParams)posView.getLayoutParams()).leftMargin;
                    layoutManager.scrollToPositionWithOffset(pos, posView.getLeft() - leftMargin);
                }
            }
        }
        boolean lastItemReached = false;
        boolean firstItemReached = false;
        int top = this.mClipToPadding ? this.getPaddingTop() : 0;
        int bottom = this.mClipToPadding ? this.getHeight() - this.getPaddingBottom() : this.getHeight();
        int left = this.mClipToPadding ? this.getPaddingLeft() : 0;
        int right = this.mClipToPadding ? this.getWidth() - this.getPaddingRight() : this.getWidth();
        RecyclerView.ViewHolder lastChild = this.findViewHolderForLayoutPosition(this.mAdapter.getItemCount() - 1);
        RecyclerView.ViewHolder firstChild = this.findViewHolderForLayoutPosition(0);
        if (layoutManager.getOrientation() == 1) {
            if (lastChild != null && lastChild.itemView.getBottom() <= bottom) {
                lastItemReached = true;
            }
            if (firstChild != null && firstChild.itemView.getTop() >= top) {
                firstItemReached = true;
            }
        } else {
            if (lastChild != null && lastChild.itemView.getRight() <= right) {
                lastItemReached = true;
            }
            if (firstChild != null && firstChild.itemView.getLeft() >= left) {
                firstItemReached = true;
            }
        }
        if (layoutManager.getOrientation() == 1) {
            if (this.mDragItem.getY() > (float)(this.getHeight() - view.getHeight() / 2) && !lastItemReached) {
                this.mAutoScroller.startAutoScroll(AutoScroller.ScrollDirection.UP);
            } else if (this.mDragItem.getY() < (float)(view.getHeight() / 2) && !firstItemReached) {
                this.mAutoScroller.startAutoScroll(AutoScroller.ScrollDirection.DOWN);
            } else {
                this.mAutoScroller.stopAutoScroll();
            }
        } else if (this.mDragItem.getX() > (float)(this.getWidth() - view.getWidth() / 2) && !lastItemReached) {
            this.mAutoScroller.startAutoScroll(AutoScroller.ScrollDirection.LEFT);
        } else if (this.mDragItem.getX() < (float)(view.getWidth() / 2) && !firstItemReached) {
            this.mAutoScroller.startAutoScroll(AutoScroller.ScrollDirection.RIGHT);
        } else {
            this.mAutoScroller.stopAutoScroll();
        }
    }

    boolean startDrag(View itemView, long itemId, float x, float y) {
        int dragItemPosition = this.mAdapter.getPositionForItemId(itemId);
        if (!this.mDragEnabled || this.mCanNotDragAboveTop && dragItemPosition == 0 || this.mCanNotDragBelowBottom && dragItemPosition == this.mAdapter.getItemCount() - 1) {
            return false;
        }
        if (this.mDragCallback != null && !this.mDragCallback.canDragItemAtPosition(dragItemPosition)) {
            return false;
        }
        this.getParent().requestDisallowInterceptTouchEvent(false);
        this.mDragState = DragState.DRAG_STARTED;
        this.mDragItemId = itemId;
        this.mDragItem.startDrag(itemView, x, y);
        this.mDragItemPosition = dragItemPosition;
        this.updateDragPositionAndScroll();
        this.mAdapter.setDragItemId(this.mDragItemId);
        this.mAdapter.notifyDataSetChanged();
        if (this.mListener != null) {
            this.mListener.onDragStarted(this.mDragItemPosition, this.mDragItem.getX(), this.mDragItem.getY());
        }
        this.invalidate();
        return true;
    }

    void onDragging(float x, float y) {
        if (this.mDragState == DragState.DRAG_ENDED) {
            return;
        }
        this.mDragState = DragState.DRAGGING;
        this.mDragItemPosition = this.mAdapter.getPositionForItemId(this.mDragItemId);
        this.mDragItem.setPosition(x, y);
        if (!this.mAutoScroller.isAutoScrolling()) {
            this.updateDragPositionAndScroll();
        }
        if (this.mListener != null) {
            this.mListener.onDragging(this.mDragItemPosition, x, y);
        }
        this.invalidate();
    }

    void onDragEnded() {
        if (this.mDragState == DragState.DRAG_ENDED) {
            return;
        }
        this.mAutoScroller.stopAutoScroll();
        this.setEnabled(false);
        if (this.mDisableReorderWhenDragging) {
            int newPos = this.mAdapter.getPositionForItemId(this.mAdapter.getDropTargetId());
            if (newPos != -1) {
                this.mAdapter.swapItems(this.mDragItemPosition, newPos);
                this.mDragItemPosition = newPos;
            }
            this.mAdapter.setDropTargetId(-1L);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                final RecyclerView.ViewHolder holder = DragItemRecyclerView.this.findViewHolderForAdapterPosition(DragItemRecyclerView.this.mDragItemPosition);
                if (holder != null) {
                    DragItemRecyclerView.this.getItemAnimator().endAnimation(holder);
                    DragItemRecyclerView.this.mDragItem.endDrag(holder.itemView, new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            holder.itemView.setAlpha(1.0f);
                            DragItemRecyclerView.this.onDragItemAnimationEnd();
                        }
                    });
                } else {
                    DragItemRecyclerView.this.onDragItemAnimationEnd();
                }
            }
        });
    }

    private void onDragItemAnimationEnd() {
        this.mAdapter.setDragItemId(-1L);
        this.mAdapter.setDropTargetId(-1L);
        this.mAdapter.notifyDataSetChanged();
        this.mDragState = DragState.DRAG_ENDED;
        if (this.mListener != null) {
            this.mListener.onDragEnded(this.mDragItemPosition);
        }
        this.mDragItemId = -1L;
        this.mDragItem.hide();
        this.setEnabled(true);
        this.invalidate();
    }

    int getDragPositionForY(float y) {
        View child = this.findChildView(0.0f, y);
        int pos = child == null && this.getChildCount() > 0 ? this.getChildLayoutPosition(this.getChildAt(this.getChildCount() - 1)) + 1 : this.getChildLayoutPosition(child);
        if (pos == -1) {
            pos = 0;
        }
        return pos;
    }

    void addDragItemAndStart(float y, Object item, long itemId) {
        int pos = this.getDragPositionForY(y);
        this.mDragState = DragState.DRAG_STARTED;
        this.mDragItemId = itemId;
        this.mAdapter.setDragItemId(this.mDragItemId);
        this.mAdapter.addItem(pos, item);
        this.mDragItemPosition = pos;
        this.mHoldChangePosition = true;
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                DragItemRecyclerView.this.mHoldChangePosition = false;
            }
        }, this.getItemAnimator().getMoveDuration());
        this.invalidate();
    }

    Object removeDragItemAndEnd() {
        if (this.mDragItemPosition == -1) {
            return null;
        }
        this.mAutoScroller.stopAutoScroll();
        Object item = this.mAdapter.removeItem(this.mDragItemPosition);
        this.mAdapter.setDragItemId(-1L);
        this.mDragState = DragState.DRAG_ENDED;
        this.mDragItemId = -1L;
        this.invalidate();
        return item;
    }

    private static enum DragState {
        DRAG_STARTED,
        DRAGGING,
        DRAG_ENDED;

    }

    public static interface DragItemCallback {
        public boolean canDragItemAtPosition(int var1);

        public boolean canDropItemAtPosition(int var1);
    }

    public static interface DragItemListener {
        public void onDragStarted(int var1, float var2, float var3);

        public void onDragging(int var1, float var2, float var3);

        public void onDragEnded(int var1);
    }
}

