/*
 * Decompiled with CFR 0.152.
 */
package com.woxthebox.draglistview;

import android.content.Context;
import android.os.Handler;

class AutoScroller {
    private static final int SCROLL_SPEED_DP = 8;
    private static final int AUTO_SCROLL_UPDATE_DELAY = 12;
    private static final int COLUMN_SCROLL_UPDATE_DELAY = 1000;
    private Handler mHandler = new Handler();
    private AutoScrollListener mListener;
    private boolean mIsAutoScrolling;
    private int mScrollSpeed;
    private long mLastScrollTime;
    private AutoScrollMode mAutoScrollMode = AutoScrollMode.POSITION;

    AutoScroller(Context context, AutoScrollListener listener) {
        this.mListener = listener;
        this.mScrollSpeed = (int)(context.getResources().getDisplayMetrics().density * 8.0f);
    }

    void setAutoScrollMode(AutoScrollMode autoScrollMode) {
        this.mAutoScrollMode = autoScrollMode;
    }

    boolean isAutoScrolling() {
        return this.mIsAutoScrolling;
    }

    void stopAutoScroll() {
        this.mIsAutoScrolling = false;
    }

    void startAutoScroll(ScrollDirection direction) {
        switch (direction) {
            case UP: {
                this.startAutoScrollPositionBy(0, this.mScrollSpeed);
                break;
            }
            case DOWN: {
                this.startAutoScrollPositionBy(0, -this.mScrollSpeed);
                break;
            }
            case LEFT: {
                if (this.mAutoScrollMode == AutoScrollMode.POSITION) {
                    this.startAutoScrollPositionBy(this.mScrollSpeed, 0);
                    break;
                }
                this.startAutoScrollColumnBy(1);
                break;
            }
            case RIGHT: {
                if (this.mAutoScrollMode == AutoScrollMode.POSITION) {
                    this.startAutoScrollPositionBy(-this.mScrollSpeed, 0);
                    break;
                }
                this.startAutoScrollColumnBy(-1);
            }
        }
    }

    private void startAutoScrollPositionBy(int dx, int dy) {
        if (!this.mIsAutoScrolling) {
            this.mIsAutoScrolling = true;
            this.autoScrollPositionBy(dx, dy);
        }
    }

    private void autoScrollPositionBy(final int dx, final int dy) {
        if (this.mIsAutoScrolling) {
            this.mListener.onAutoScrollPositionBy(dx, dy);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AutoScroller.this.autoScrollPositionBy(dx, dy);
                }
            }, 12L);
        }
    }

    private void startAutoScrollColumnBy(int columns) {
        if (!this.mIsAutoScrolling) {
            this.mIsAutoScrolling = true;
            this.autoScrollColumnBy(columns);
        }
    }

    private void autoScrollColumnBy(final int columns) {
        if (this.mIsAutoScrolling) {
            if (System.currentTimeMillis() - this.mLastScrollTime > 1000L) {
                this.mListener.onAutoScrollColumnBy(columns);
                this.mLastScrollTime = System.currentTimeMillis();
            } else {
                this.mListener.onAutoScrollColumnBy(0);
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AutoScroller.this.autoScrollColumnBy(columns);
                }
            }, 12L);
        }
    }

    static interface AutoScrollListener {
        public void onAutoScrollPositionBy(int var1, int var2);

        public void onAutoScrollColumnBy(int var1);
    }

    static enum ScrollDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    static enum AutoScrollMode {
        POSITION,
        COLUMN;

    }
}

