/*
 * Decompiled with CFR 0.152.
 */
package com.lqr.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.lqr.adapter.OnItemClickListener;
import com.lqr.adapter.OnItemLongClickListener;
import com.lqr.adapter.OnItemTouchListener;

public class LQRViewHolder
extends RecyclerView.ViewHolder {
    protected Context mContext;
    protected View mConvertView;
    protected SparseArray<View> mViews;
    protected int mMyPosition;
    protected OnItemClickListener mOnItemClickListener;
    protected OnItemLongClickListener mOnItemLongClickListener;
    protected OnItemTouchListener mOnItemTouchListener;

    public LQRViewHolder(View itemView) {
        super(itemView);
    }

    public <T extends View> T getView(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public View getConvertView() {
        return this.mConvertView;
    }

    public int getMyPosition() {
        return this.mMyPosition;
    }

    public void setMyPosition(int myPosition) {
        this.mMyPosition = myPosition;
    }

    public OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public OnItemLongClickListener getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public OnItemTouchListener getOnItemTouchListener() {
        return this.mOnItemTouchListener;
    }

    public void setOnItemTouchListener(OnItemTouchListener onItemTouchListener) {
        this.mOnItemTouchListener = onItemTouchListener;
    }

    public LQRViewHolder setText(int viewId, String text) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setText((CharSequence)text);
        return this;
    }

    public LQRViewHolder setTextColor(int viewId, int colorId) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setTextColor(this.mContext.getResources().getColor(colorId));
        return this;
    }

    public LQRViewHolder setImageResource(int viewId, int resId) {
        ImageView iv = (ImageView)this.getView(viewId);
        iv.setImageResource(resId);
        return this;
    }

    public LQRViewHolder setImageBitmap(int viewId, Bitmap bitmap) {
        ImageView iv = (ImageView)this.getView(viewId);
        iv.setImageBitmap(bitmap);
        return this;
    }

    public LQRViewHolder setImageFileResource(int viewId, String path) {
        ImageView iv = (ImageView)this.getView(viewId);
        Bitmap bitmap = BitmapFactory.decodeFile((String)path);
        iv.setImageBitmap(bitmap);
        return this;
    }

    public LQRViewHolder setBackgroundColor(int viewId, int colorId) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(this.mContext.getResources().getColor(colorId));
        return this;
    }

    public LQRViewHolder setBackgrounResource(int viewId, int resId) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(resId);
        return this;
    }

    public LQRViewHolder setViewVisibility(int viewId, int visibility) {
        Object view = this.getView(viewId);
        view.setVisibility(visibility);
        return this;
    }

    public LQRViewHolder setEnabled(int viewId, boolean enabled) {
        Object view = this.getView(viewId);
        view.setEnabled(enabled);
        return this;
    }

    public LQRViewHolder setFocusable(int viewId, boolean focusable) {
        Object view = this.getView(viewId);
        view.setFocusable(focusable);
        return this;
    }
}

