/*
 * Decompiled with CFR 0.152.
 */
package com.lqr.adapter;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.lqr.adapter.LQRViewHolderForAbsListView;
import com.lqr.adapter.OnItemClickListener;
import com.lqr.adapter.OnItemLongClickListener;
import com.lqr.adapter.OnItemTouchListener;
import java.util.List;

public abstract class LQRAdapterForAbsListView<T>
extends BaseAdapter {
    private Context mContext;
    private List<T> mData;
    private int mDefaultLayouId;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    private OnItemTouchListener mOnItemTouchListener;

    public OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public OnItemLongClickListener getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public OnItemTouchListener getOnItemTouchListener() {
        return this.mOnItemTouchListener;
    }

    public void setOnItemTouchListener(OnItemTouchListener onItemTouchListener) {
        this.mOnItemTouchListener = onItemTouchListener;
    }

    public LQRAdapterForAbsListView(Context context, List<T> data, int defaultLayouId) {
        this.mContext = context;
        this.mData = data;
        this.mDefaultLayouId = defaultLayouId;
    }

    public int getCount() {
        if (this.mData != null) {
            return this.mData.size();
        }
        return 0;
    }

    public T getItem(int i) {
        return this.mData.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int position, View convertView, ViewGroup viewGroup) {
        LQRViewHolderForAbsListView viewHolder = this.getViewHolder(position, convertView, viewGroup);
        this.convert(viewHolder, this.getItem(position), position);
        return viewHolder.getConvertView();
    }

    public abstract void convert(LQRViewHolderForAbsListView var1, T var2, int var3);

    public List<T> getData() {
        return this.mData;
    }

    public void addNewData(List<T> data) {
        if (data != null) {
            this.mData.addAll(0, data);
            this.notifyDataSetChanged();
        }
    }

    public void addMoreData(List<T> data) {
        if (data != null) {
            this.mData.addAll(this.mData.size(), data);
            this.notifyDataSetChanged();
        }
    }

    public void setData(List<T> data) {
        if (data != null) {
            this.mData = data;
        } else {
            this.mData.clear();
        }
        this.notifyDataSetChanged();
    }

    public void clearData() {
        this.mData.clear();
        this.notifyDataSetChanged();
    }

    public void removeItem(int position) {
        this.mData.remove(position);
        this.notifyDataSetChanged();
    }

    public void removeItem(T model) {
        this.mData.remove(model);
        this.notifyDataSetChanged();
    }

    public void addItem(int position, T model) {
        this.mData.add(position, model);
        this.notifyDataSetChanged();
    }

    public void addFirstItem(T model) {
        this.addItem(0, model);
    }

    public void addLastItem(T model) {
        this.addItem(this.mData.size(), model);
    }

    public void setItem(int location, T newModel) {
        this.mData.set(location, newModel);
        this.notifyDataSetChanged();
    }

    public void setItem(T oldModel, T newModel) {
        this.setItem((T)this.mData.indexOf(oldModel), newModel);
    }

    public void moveItem(int fromPosition, int toPosition) {
        this.mData.add(toPosition, this.mData.remove(fromPosition));
        this.notifyDataSetChanged();
    }

    @Nullable
    public T getFirstItem() {
        return this.getCount() > 0 ? (T)this.getItem(0) : null;
    }

    @Nullable
    public T getLastItem() {
        return this.getCount() > 0 ? (T)this.getItem(this.getCount() - 1) : null;
    }

    private LQRViewHolderForAbsListView getViewHolder(int position, View convertView, ViewGroup viewGroup) {
        LQRViewHolderForAbsListView holder = LQRViewHolderForAbsListView.get(this.mContext, this.mDefaultLayouId, position, convertView, viewGroup);
        holder.setOnItemClickListener(this.mOnItemClickListener);
        holder.setOnItemLongClickListener(this.mOnItemLongClickListener);
        holder.setOnItemTouchListener(this.mOnItemTouchListener);
        return holder;
    }
}

