/*
 * Decompiled with CFR 0.152.
 */
package com.lqr.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

public class LQRViewHolderForRecyclerView
extends RecyclerView.ViewHolder {
    private Context mContext;
    private View mConvertView;
    private SparseArray<View> mViews;

    public LQRViewHolderForRecyclerView(Context context, View itemView) {
        super(itemView);
        this.mContext = context;
        this.mConvertView = itemView;
        this.mViews = new SparseArray();
    }

    public <T extends View> T getView(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
        }
        return (T)view;
    }

    public View getConvertView() {
        return this.mConvertView;
    }

    public LQRViewHolderForRecyclerView setText(int viewId, String text) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setText((CharSequence)text);
        return this;
    }

    public LQRViewHolderForRecyclerView setTextColor(int viewId, int colorId) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setTextColor(this.mContext.getResources().getColor(colorId));
        return this;
    }

    public LQRViewHolderForRecyclerView setImageResource(int viewId, int resId) {
        ImageView iv = (ImageView)this.getView(viewId);
        iv.setImageResource(resId);
        return this;
    }

    public LQRViewHolderForRecyclerView setImageBitmap(int viewId, Bitmap bitmap) {
        ImageView iv = (ImageView)this.getView(viewId);
        iv.setImageBitmap(bitmap);
        return this;
    }

    public LQRViewHolderForRecyclerView setImageFileResource(int viewId, String path) {
        ImageView iv = (ImageView)this.getView(viewId);
        Bitmap bitmap = BitmapFactory.decodeFile((String)path);
        iv.setImageBitmap(bitmap);
        return this;
    }

    public LQRViewHolderForRecyclerView setBackgroundColor(int viewId, int colorId) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(this.mContext.getResources().getColor(colorId));
        return this;
    }

    public LQRViewHolderForRecyclerView setBackgrounResource(int viewId, int resId) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(resId);
        return this;
    }

    public LQRViewHolderForRecyclerView setViewVisibility(int viewId, int visibility) {
        Object view = this.getView(viewId);
        view.setVisibility(visibility);
        return this;
    }

    public LQRViewHolderForRecyclerView setEnabled(int viewId, boolean enabled) {
        Object view = this.getView(viewId);
        view.setEnabled(enabled);
        return this;
    }

    public LQRViewHolderForRecyclerView setFocusable(int viewId, boolean focusable) {
        Object view = this.getView(viewId);
        view.setFocusable(focusable);
        return this;
    }
}

