/*
 * Decompiled with CFR 0.152.
 */
package com.lqr.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

public class LQRViewHolderForAbsListView {
    private Context mContext;
    private View mConvertView;
    private SparseArray<View> mViews;

    public LQRViewHolderForAbsListView(Context context, int defaultLayouId, ViewGroup parent) {
        this.mContext = context;
        this.mViews = new SparseArray();
        this.mConvertView = View.inflate((Context)context, (int)defaultLayouId, null);
        this.mConvertView.setTag((Object)this);
    }

    public static LQRViewHolderForAbsListView get(Context context, int defaultLayouId, int position, View convertView, ViewGroup viewGroup) {
        LQRViewHolderForAbsListView viewHolder = convertView == null ? new LQRViewHolderForAbsListView(context, defaultLayouId, viewGroup) : (LQRViewHolderForAbsListView)convertView.getTag();
        return viewHolder;
    }

    public <T extends View> T getView(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public View getConvertView() {
        return this.mConvertView;
    }

    public LQRViewHolderForAbsListView setText(int viewId, String text) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setText((CharSequence)text);
        return this;
    }

    public LQRViewHolderForAbsListView setTextColor(int viewId, int colorId) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setTextColor(this.mContext.getResources().getColor(colorId));
        return this;
    }

    public LQRViewHolderForAbsListView setImageResource(int viewId, int resId) {
        ImageView iv = (ImageView)this.getView(viewId);
        iv.setImageResource(resId);
        return this;
    }

    public LQRViewHolderForAbsListView setImageBitmap(int viewId, Bitmap bitmap) {
        ImageView iv = (ImageView)this.getView(viewId);
        iv.setImageBitmap(bitmap);
        return this;
    }

    public LQRViewHolderForAbsListView setImageFileResource(int viewId, String path) {
        ImageView iv = (ImageView)this.getView(viewId);
        Bitmap bitmap = BitmapFactory.decodeFile((String)path);
        iv.setImageBitmap(bitmap);
        return this;
    }

    public LQRViewHolderForAbsListView setBackgroundColor(int viewId, int colorId) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(this.mContext.getResources().getColor(colorId));
        return this;
    }

    public LQRViewHolderForAbsListView setBackgrounResource(int viewId, int resId) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(resId);
        return this;
    }

    public LQRViewHolderForAbsListView setViewVisibility(int viewId, int visibility) {
        Object view = this.getView(viewId);
        view.setVisibility(visibility);
        return this;
    }

    public LQRViewHolderForAbsListView setEnabled(int viewId, boolean enabled) {
        Object view = this.getView(viewId);
        view.setEnabled(enabled);
        return this;
    }

    public LQRViewHolderForAbsListView setFocusable(int viewId, boolean focusable) {
        Object view = this.getView(viewId);
        view.setFocusable(focusable);
        return this;
    }
}

