/*
 * Decompiled with CFR 0.152.
 */
package com.lqr.adapter;

import android.support.v4.util.SparseArrayCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;

public class LQRHeaderAndFooterAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int BASE_ITEM_TYPE_HEADER = 1024;
    private static final int BASE_ITEM_TYPE_FOOTER = 2048;
    private SparseArrayCompat<View> mHeaderViews = new SparseArrayCompat();
    private SparseArrayCompat<View> mFooterViews = new SparseArrayCompat();
    private RecyclerView.Adapter mInnerAdapter;

    public LQRHeaderAndFooterAdapter(RecyclerView.Adapter innerAdapter) {
        this.mInnerAdapter = innerAdapter;
    }

    public RecyclerView.Adapter getInnerAdapter() {
        return this.mInnerAdapter;
    }

    public int getItemViewType(int position) {
        if (this.isHeaderView(position)) {
            return this.mHeaderViews.keyAt(position);
        }
        if (this.isFooterView(position)) {
            return this.mFooterViews.keyAt(position - this.getHeadersCount() - this.getRealItemCount());
        }
        return this.mInnerAdapter.getItemViewType(position - this.getHeadersCount());
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mHeaderViews.get(viewType) != null) {
            return new RecyclerView.ViewHolder((View)this.mHeaderViews.get(viewType)){};
        }
        if (this.mFooterViews.get(viewType) != null) {
            return new RecyclerView.ViewHolder((View)this.mFooterViews.get(viewType)){};
        }
        return this.mInnerAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.isHeaderView(position)) {
            return;
        }
        if (this.isFooterView(position)) {
            return;
        }
        this.mInnerAdapter.onBindViewHolder(holder, position - this.getHeadersCount());
    }

    public int getItemCount() {
        return this.getHeadersCount() + this.getFootersCount() + this.getRealItemCount();
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.mInnerAdapter.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            final GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            final GridLayoutManager.SpanSizeLookup spanSizeLookup = gridLayoutManager.getSpanSizeLookup();
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    int viewType = LQRHeaderAndFooterAdapter.this.getItemViewType(position);
                    if (LQRHeaderAndFooterAdapter.this.mHeaderViews.get(viewType) != null) {
                        return gridLayoutManager.getSpanCount();
                    }
                    if (LQRHeaderAndFooterAdapter.this.mFooterViews.get(viewType) != null) {
                        return gridLayoutManager.getSpanCount();
                    }
                    if (spanSizeLookup != null) {
                        return spanSizeLookup.getSpanSize(position - LQRHeaderAndFooterAdapter.this.getHeadersCount());
                    }
                    return 1;
                }
            });
        }
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        ViewGroup.LayoutParams lp;
        this.mInnerAdapter.onViewAttachedToWindow(holder);
        int position = holder.getLayoutPosition();
        if ((this.isHeaderView(position) || this.isFooterView(position)) && (lp = holder.itemView.getLayoutParams()) != null && lp instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(true);
        }
    }

    public void addHeaderView(View view) {
        this.mHeaderViews.put(this.mHeaderViews.size() + 1024, (Object)view);
    }

    public void addFooterView(View view) {
        this.mFooterViews.put(this.mFooterViews.size() + 2048, (Object)view);
    }

    private boolean isHeaderView(int position) {
        return position < this.getHeadersCount();
    }

    private boolean isFooterView(int position) {
        return position >= this.getHeadersCount() + this.getRealItemCount();
    }

    public int getHeadersCount() {
        return this.mHeaderViews.size();
    }

    public int getFootersCount() {
        return this.mFooterViews.size();
    }

    private int getRealItemCount() {
        return this.mInnerAdapter.getItemCount();
    }
}

