/*
 * Decompiled with CFR 0.152.
 */
package com.lqr.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.lqr.adapter.LQRHeaderAndFooterAdapter;
import com.lqr.adapter.LQRViewHolderForRecyclerView;
import java.util.List;

public abstract class LQRAdapterForRecyclerView<T>
extends RecyclerView.Adapter<LQRViewHolderForRecyclerView> {
    private Context mContext;
    private int mDefaultLayoutId = 0;
    private List<T> mData;
    private LQRHeaderAndFooterAdapter mHeaderAndFooterAdapter;

    public LQRAdapterForRecyclerView(Context context, List<T> data) {
        this.mContext = context;
        this.mData = data;
    }

    public LQRAdapterForRecyclerView(Context context, int defaultLayoutId, List<T> data) {
        this(context, data);
        this.mDefaultLayoutId = defaultLayoutId;
    }

    public int getItemViewType(int position) {
        if (this.mDefaultLayoutId == 0) {
            throw new RuntimeException("\u8bf7\u5728 " + ((Object)((Object)this)).getClass().getSimpleName() + " \u4e2d\u91cd\u5199 getItemViewType \u65b9\u6cd5\u8fd4\u56de\u5e03\u5c40\u8d44\u6e90 id\uff0c\u6216\u8005\u4f7f\u7528 " + ((Object)((Object)this)).getClass().getSimpleName() + " \u4e09\u4e2a\u53c2\u6570\u7684\u6784\u9020\u65b9\u6cd5 LQRAdapterForRecyclerView(Context context, int defaultLayoutId, List<T> data)");
        }
        return this.mDefaultLayoutId;
    }

    public LQRViewHolderForRecyclerView onCreateViewHolder(ViewGroup parent, int viewType) {
        return new LQRViewHolderForRecyclerView(this.mContext, View.inflate((Context)this.mContext, (int)viewType, null));
    }

    public void onBindViewHolder(LQRViewHolderForRecyclerView holder, int position) {
        this.convert(holder, this.mData.get(position), position);
    }

    public int getItemCount() {
        if (this.mData != null) {
            return this.mData.size();
        }
        return 0;
    }

    public abstract void convert(LQRViewHolderForRecyclerView var1, T var2, int var3);

    public T getItem(int position) {
        return this.mData.get(position);
    }

    public List<T> getData() {
        return this.mData;
    }

    public final void notifyItemRangeInsertedWrapper(int positionStart, int itemCount) {
        if (this.mHeaderAndFooterAdapter == null) {
            this.notifyItemRangeInserted(positionStart, itemCount);
        } else {
            this.mHeaderAndFooterAdapter.notifyItemRangeInserted(this.mHeaderAndFooterAdapter.getHeadersCount() + positionStart, itemCount);
        }
    }

    public void addNewData(List<T> data) {
        if (data != null) {
            this.mData.addAll(0, data);
            this.notifyItemRangeInsertedWrapper(0, data.size());
        }
    }

    public void addMoreData(List<T> data) {
        if (data != null) {
            this.mData.addAll(this.mData.size(), data);
            this.notifyItemRangeInsertedWrapper(this.mData.size(), data.size());
        }
    }

    public final void notifyDataSetChangedWrapper() {
        if (this.mHeaderAndFooterAdapter == null) {
            this.notifyDataSetChanged();
        } else {
            this.mHeaderAndFooterAdapter.notifyDataSetChanged();
        }
    }

    public void setData(List<T> data) {
        if (data != null) {
            if (this.mData == null) {
                this.mData = data;
            } else {
                this.mData.clear();
                this.mData.addAll(data);
            }
        } else {
            this.mData.clear();
        }
        this.notifyDataSetChangedWrapper();
    }

    public void clearData() {
        this.mData.clear();
        this.notifyDataSetChangedWrapper();
    }

    public final void notifyItemRemoveWrapper(int position) {
        if (this.mHeaderAndFooterAdapter == null) {
            this.notifyItemRemoved(position);
        } else {
            this.mHeaderAndFooterAdapter.notifyItemRemoved(this.mHeaderAndFooterAdapter.getHeadersCount() + position);
        }
    }

    public void removeItem(int position) {
        this.mData.remove(position);
        this.notifyItemRemoveWrapper(position);
    }

    public void removeItem(T model) {
        this.removeItem(this.mData.indexOf(model));
    }

    public final void notifyItemInsertedWrapper(int position) {
        if (this.mHeaderAndFooterAdapter == null) {
            this.notifyItemInserted(position);
        } else {
            this.mHeaderAndFooterAdapter.notifyItemInserted(this.mHeaderAndFooterAdapter.getHeadersCount() + position);
        }
    }

    public void addItem(int position, T model) {
        this.mData.add(position, model);
        this.notifyItemInsertedWrapper(position);
    }

    public void addFirstItem(T model) {
        this.addItem(0, model);
    }

    public void addLastItem(T model) {
        this.addItem(this.mData.size(), model);
    }

    public final void notifyItemChangedWrapper(int position) {
        if (this.mHeaderAndFooterAdapter == null) {
            this.notifyItemChanged(position);
        } else {
            this.mHeaderAndFooterAdapter.notifyItemChanged(this.mHeaderAndFooterAdapter.getHeadersCount() + position);
        }
    }

    public void setItem(int position, T newModel) {
        this.mData.set(position, newModel);
        this.notifyItemChangedWrapper(position);
    }

    public void setItem(T oldModel, T newModel) {
        this.setItem((T)this.mData.indexOf(oldModel), newModel);
    }

    public final void notifyItemMoveWrapper(int fromPosition, int toPosition) {
        if (this.mHeaderAndFooterAdapter == null) {
            this.notifyItemMoved(fromPosition, toPosition);
        } else {
            this.mHeaderAndFooterAdapter.notifyItemMoved(this.mHeaderAndFooterAdapter.getHeadersCount() + fromPosition, this.mHeaderAndFooterAdapter.getHeadersCount() + toPosition);
        }
    }

    public void moveItem(int fromPosition, int toPosition) {
        this.notifyItemChangedWrapper(fromPosition);
        this.notifyItemChangedWrapper(toPosition);
        this.mData.add(toPosition, this.mData.remove(fromPosition));
        this.notifyItemMoveWrapper(fromPosition, toPosition);
    }

    public T getFirstItem() {
        return this.getItemCount() > 0 ? (T)this.getItem(0) : null;
    }

    public T getLastItem() {
        return this.getItemCount() > 0 ? (T)this.getItem(this.getItemCount() - 1) : null;
    }

    public void addHeaderView(View headerView) {
        this.getHeaderAndFooterAdapter().addHeaderView(headerView);
    }

    public void addFooterView(View footerView) {
        this.getHeaderAndFooterAdapter().addFooterView(footerView);
    }

    public int getHeadersCount() {
        return this.mHeaderAndFooterAdapter == null ? 0 : this.mHeaderAndFooterAdapter.getHeadersCount();
    }

    public int getFootersCount() {
        return this.mHeaderAndFooterAdapter == null ? 0 : this.mHeaderAndFooterAdapter.getFootersCount();
    }

    public boolean isHeaderOrFooter(RecyclerView.ViewHolder viewHolder) {
        return viewHolder.getAdapterPosition() < this.getHeadersCount() || viewHolder.getAdapterPosition() >= this.getHeadersCount() + this.getItemCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LQRHeaderAndFooterAdapter getHeaderAndFooterAdapter() {
        if (this.mHeaderAndFooterAdapter != null) return this.mHeaderAndFooterAdapter;
        Class<LQRHeaderAndFooterAdapter> clazz = LQRHeaderAndFooterAdapter.class;
        synchronized (LQRHeaderAndFooterAdapter.class) {
            if (this.mHeaderAndFooterAdapter != null) return this.mHeaderAndFooterAdapter;
            this.mHeaderAndFooterAdapter = new LQRHeaderAndFooterAdapter(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mHeaderAndFooterAdapter;
        }
    }
}

