/*
 * Decompiled with CFR 0.152.
 */
package com.lovejoanlyn.scheduler.scheduler;

import com.lovejoanlyn.scheduler.log.Log;
import com.lovejoanlyn.scheduler.log.LogFactory;
import com.lovejoanlyn.scheduler.scheduler.IScheduler;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Scheduler
implements IScheduler {
    protected Log log = LogFactory.getLog(this.getClass());
    protected static final Map<String, Future<?>> tasks = new ConcurrentHashMap();
    protected static ScheduledExecutorService executors;

    protected Scheduler() {
        this.init();
    }

    void init() {
        executors = Executors.newScheduledThreadPool(this.getCorePoolSize(), new ThreadFactory(){
            AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                SecurityManager s = System.getSecurityManager();
                ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
                Thread t = new Thread(group, r);
                t.setDaemon(true);
                t.setName(Scheduler.this.getThreadName() + " - " + this.sn.incrementAndGet());
                return t;
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                Scheduler.this.destoryThreadPool();
            }
        }));
        this.initialize();
    }

    protected abstract void initialize();

    public void destoryThreadPool() {
        try {
            executors.awaitTermination(500L, TimeUnit.MICROSECONDS);
            executors.shutdown();
        }
        catch (InterruptedException e) {
            this.log.error(e.getCause().getMessage());
        }
    }

    protected abstract String getThreadName();

    protected abstract int getCorePoolSize();

    protected Runnable newTask(final String taskId, final Runnable task, final boolean removeAfterExecute) {
        return new Runnable(){

            public String toString() {
                return task.toString();
            }

            @Override
            public void run() {
                try {
                    if (taskId != null) {
                        // empty if block
                    }
                    task.run();
                }
                catch (Throwable e) {
                    Scheduler.this.log.error("SchedulerTask", e);
                }
                if (removeAfterExecute) {
                    tasks.remove(taskId);
                }
            }
        };
    }

    @Override
    public void submit(String taskId, long delay, Runnable task) {
        this.cancel(taskId);
        ScheduledFuture<?> future = executors.schedule(this.newTask(taskId, task, true), delay, TimeUnit.MILLISECONDS);
        if (!future.isDone() && !future.isCancelled()) {
            tasks.put(taskId, future);
        }
        this.log.debug("taskId[{" + taskId + "}] delay[{" + delay + "}] Thread Running");
    }

    @Override
    public <V> ScheduledFuture<V> submitFutrue(long delay, Callable<V> task) {
        ScheduledFuture<V> future = executors.schedule(task, delay, TimeUnit.MILLISECONDS);
        return future;
    }

    @Override
    public void submit(String taskId, Runnable task) {
        this.cancel(taskId);
        Future<?> future = executors.submit(this.newTask(taskId, task, true));
        if (!future.isDone() && !future.isCancelled()) {
            tasks.put(taskId, future);
        }
        this.log.debug("taskId[{" + taskId + "}] Thread Running");
    }

    @Override
    public String submit(Runnable task) {
        String taskId = null;
        executors.submit(this.newTask(taskId, task, true));
        this.log.debug("Thread Running");
        return taskId;
    }

    @Override
    public String submit(long delay, Runnable task) {
        String task_id = UUID.randomUUID().toString();
        this.submit(task_id, delay, task);
        return task_id;
    }

    @Override
    public String submit(Date time, Runnable task) {
        String task_id = UUID.randomUUID().toString();
        this.submit(task_id, time, task);
        return task_id;
    }

    @Override
    public void submit(String taskId, Date time, Runnable task) {
        long delay = 0L;
        Date now = new Date();
        if (now.before(time)) {
            delay = time.getTime() - now.getTime();
        }
        this.submit(taskId, delay, task);
    }

    @Override
    public String submit(Date time, long interval, Runnable task) {
        long delay = 0L;
        Date now = new Date();
        if (now.before(time)) {
            delay = time.getTime() - now.getTime();
        }
        return this.submit(delay, task);
    }

    @Override
    public String submit(long delay, long interval, Runnable task) {
        String taskId = UUID.randomUUID().toString();
        this.submit(taskId, delay, interval, task);
        return taskId;
    }

    @Override
    public void submit(String taskId, Date time, long interval, Runnable task) {
        long delay = 0L;
        Date now = new Date();
        if (now.before(time)) {
            delay = time.getTime() - now.getTime();
        }
        this.submit(taskId, delay, interval, task);
    }

    @Override
    public void submit(String taskId, long delay, long interval, Runnable task) {
        this.cancel(taskId);
        ScheduledFuture<?> future = executors.scheduleWithFixedDelay(this.newTask(taskId, task, false), delay, interval, TimeUnit.MILLISECONDS);
        if (!future.isDone() && !future.isCancelled()) {
            tasks.put(taskId, future);
        }
        this.log.error("taskId[{" + taskId + "}] delay[{" + delay + "}] Thread Running in ever [{" + interval + "}] second");
    }

    @Override
    public void cancel(String taskId) {
        if (taskId != null && tasks.containsKey(taskId)) {
            this.log.error("taskId [" + taskId + "] has been cancel");
            Future<?> future = tasks.get(taskId);
            if (future != null) {
                future.cancel(false);
                tasks.remove(taskId);
            }
        }
    }

    @Override
    public long getDelay(String taskId) {
        Future<?> future;
        if (taskId != null && tasks.containsKey(taskId) && (future = tasks.get(taskId)) instanceof ScheduledFuture) {
            return ((ScheduledFuture)future).getDelay(TimeUnit.MILLISECONDS);
        }
        return -1L;
    }

    @Override
    public boolean isContainTask(String taskId) {
        boolean isContain = false;
        if (taskId != null) {
            isContain = tasks.containsKey(taskId);
        }
        return isContain;
    }
}

