/*
 * Decompiled with CFR 0.152.
 */
package com.lovejoanlyn.scheduler.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FixThreadPool {
    private static ExecutorService executors;
    private static Map instance;
    private int size = Runtime.getRuntime().availableProcessors() * 2 + 1;

    private FixThreadPool() {
        this.init();
    }

    public static synchronized FixThreadPool newInstance(String name) {
        if (instance.get(name) == null) {
            instance.put(name, new FixThreadPool());
        }
        return (FixThreadPool)instance.get(name);
    }

    void init() {
        executors = Executors.newFixedThreadPool(this.size);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                FixThreadPool.this.destoryThreadPool();
            }
        }));
    }

    public void destoryThreadPool() {
        try {
            executors.awaitTermination(500L, TimeUnit.MICROSECONDS);
            executors.shutdown();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void submit(Runnable task) {
        executors.execute(task);
    }

    public <V> Future<V> submitFutrue(Callable<V> task) {
        return executors.submit(task);
    }

    static {
        instance = new HashMap();
    }
}

