/*
 * Decompiled with CFR 0.152.
 */
package com.lovejoanlyn.scheduler.scheduler;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CacheThreadPool {
    private static ExecutorService executors;
    private static CacheThreadPool instance;

    private CacheThreadPool() {
        this.init();
    }

    public static CacheThreadPool newInstance() {
        return instance;
    }

    void init() {
        executors = Executors.newCachedThreadPool();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                CacheThreadPool.this.destoryThreadPool();
            }
        }));
    }

    public void destoryThreadPool() {
        try {
            executors.awaitTermination(500L, TimeUnit.MICROSECONDS);
            executors.shutdown();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void submit(Runnable task) {
        executors.execute(task);
    }

    public <V> Future<V> submitFutrue(Callable<V> task) {
        return executors.submit(task);
    }

    static {
        instance = new CacheThreadPool();
    }
}

