package com.lovejoanlyn.log;

/**
 * Created by 柏杰 on 2017/3/1.
 */

public final class Log {

    public final static int ALL = 0;
    public final static int DEBUG = 1;
    public final static int WARM = 2;
    public final static int ERROR = 3;

    private static Log mInstance = null;
    public static Log getLoger() {
        if(mInstance == null){
            synchronized (Log.class){
                mInstance = new Log();
            }
        }
        return mInstance;
    }

    private int level = ALL;

    public void setLevel(int l){
        level = l;
    }

    public void v(String tag,String log){
        if(level <= ALL)
            android.util.Log.v(tag,log);
    }

    public void d(String tag,String log){
        if(level <= DEBUG)
            android.util.Log.d(tag,log);
    }

    public void w(String tag,String log){
        if(level <= WARM)
            android.util.Log.w(tag,log);
    }

    public void e(String tag,String log){
        if(level <= ERROR)
            android.util.Log.e(tag,log);
    }

    public void e(String tag,String log,Throwable e){
        if(level <= ERROR)
            android.util.Log.e(tag,log,e);
    }
}
