/*
 * Decompiled with CFR 0.152.
 */
package kr.co.namee.permissiongen.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.support.v4.app.Fragment;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kr.co.namee.permissiongen.PermissionFail;
import kr.co.namee.permissiongen.PermissionSuccess;

public final class Utils {
    private Utils() {
    }

    public static boolean isOverMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    @TargetApi(value=23)
    public static List<String> findDeniedPermissions(Activity activity, String ... permission) {
        ArrayList<String> denyPermissions = new ArrayList<String>();
        for (String value : permission) {
            if (activity.checkSelfPermission(value) == 0) continue;
            denyPermissions.add(value);
        }
        return denyPermissions;
    }

    public static List<Method> findAnnotationMethods(Class clazz, Class<? extends Annotation> clazz1) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(clazz1)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static <A extends Annotation> Method findMethodPermissionFailWithRequestCode(Class clazz, Class<A> permissionFailClass, int requestCode) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(permissionFailClass) || requestCode != method.getAnnotation(PermissionFail.class).requestCode()) continue;
            return method;
        }
        return null;
    }

    public static boolean isEqualRequestCodeFromAnntation(Method m, Class clazz, int requestCode) {
        if (clazz.equals(PermissionFail.class)) {
            return requestCode == m.getAnnotation(PermissionFail.class).requestCode();
        }
        if (clazz.equals(PermissionSuccess.class)) {
            return requestCode == m.getAnnotation(PermissionSuccess.class).requestCode();
        }
        return false;
    }

    public static <A extends Annotation> Method findMethodWithRequestCode(Class clazz, Class<A> annotation, int requestCode) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotation) || !Utils.isEqualRequestCodeFromAnntation(method, annotation, requestCode)) continue;
            return method;
        }
        return null;
    }

    public static <A extends Annotation> Method findMethodPermissionSuccessWithRequestCode(Class clazz, Class<A> permissionFailClass, int requestCode) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(permissionFailClass) || requestCode != method.getAnnotation(PermissionSuccess.class).requestCode()) continue;
            return method;
        }
        return null;
    }

    public static Activity getActivity(Object object) {
        if (object instanceof Fragment) {
            return ((Fragment)object).getActivity();
        }
        if (object instanceof Activity) {
            return (Activity)object;
        }
        return null;
    }
}

