/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;

public class DeepEquals {
    private static final Map<Class<?>, Boolean> _customEquals = new ConcurrentHashMap();
    private static final Map<Class<?>, Boolean> _customHash = new ConcurrentHashMap();
    private static final Map<Class<?>, Collection<Field>> _reflectedFields = new ConcurrentHashMap();

    public static boolean deepEquals(Object a, Object b) {
        HashSet<DualKey> visited = new HashSet<DualKey>();
        LinkedList<DualKey> stack = new LinkedList<DualKey>();
        stack.addFirst(new DualKey(a, b));
        while (!stack.isEmpty()) {
            DualKey dualKey = (DualKey)stack.removeFirst();
            visited.add(dualKey);
            if (dualKey._key1 == dualKey._key2) continue;
            if (dualKey._key1 == null || dualKey._key2 == null) {
                return false;
            }
            if (!dualKey._key1.getClass().equals(dualKey._key2.getClass())) {
                return false;
            }
            if (dualKey._key1.getClass().isArray()) {
                if (DeepEquals.compareArrays(dualKey._key1, dualKey._key2, stack, visited)) continue;
                return false;
            }
            if (dualKey._key1 instanceof SortedSet) {
                if (DeepEquals.compareOrderedCollection((Collection)dualKey._key1, (Collection)dualKey._key2, stack, visited)) continue;
                return false;
            }
            if (dualKey._key1 instanceof Set) {
                if (DeepEquals.compareUnorderedCollection((Collection)dualKey._key1, (Collection)dualKey._key2, stack, visited)) continue;
                return false;
            }
            if (dualKey._key1 instanceof Collection) {
                if (DeepEquals.compareOrderedCollection((Collection)dualKey._key1, (Collection)dualKey._key2, stack, visited)) continue;
                return false;
            }
            if (dualKey._key1 instanceof SortedMap) {
                if (DeepEquals.compareSortedMap((SortedMap)dualKey._key1, (SortedMap)dualKey._key2, stack, visited)) continue;
                return false;
            }
            if (dualKey._key1 instanceof Map) {
                if (DeepEquals.compareUnorderedMap((Map)dualKey._key1, (Map)dualKey._key2, stack, visited)) continue;
                return false;
            }
            if (DeepEquals.hasCustomEquals(dualKey._key1.getClass())) {
                if (dualKey._key1.equals(dualKey._key2)) continue;
                return false;
            }
            Collection<Field> fields = DeepEquals.getDeepDeclaredFields(dualKey._key1.getClass());
            for (Field field : fields) {
                try {
                    DualKey dk = new DualKey(field.get(dualKey._key1), field.get(dualKey._key2));
                    if (visited.contains(dk)) continue;
                    stack.addFirst(dk);
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private static boolean compareArrays(Object array1, Object array2, Deque<DualKey> stack, Set<DualKey> visited) {
        int len = Array.getLength(array1);
        if (len != Array.getLength(array2)) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            DualKey dk = new DualKey(Array.get(array1, i), Array.get(array2, i));
            if (visited.contains(dk)) continue;
            stack.addFirst(dk);
        }
        return true;
    }

    private static boolean compareOrderedCollection(Collection<Object> col1, Collection<Object> col2, Deque<DualKey> stack, Set<DualKey> visited) {
        if (col1.size() != col2.size()) {
            return false;
        }
        Iterator<Object> i1 = col1.iterator();
        Iterator<Object> i2 = col2.iterator();
        while (i1.hasNext()) {
            DualKey dk = new DualKey(i1.next(), i2.next());
            if (visited.contains(dk)) continue;
            stack.addFirst(dk);
        }
        return true;
    }

    private static boolean compareUnorderedCollection(Collection<Object> col1, Collection<Object> col2, Deque<DualKey> stack, Set<DualKey> visited) {
        if (col1.size() != col2.size()) {
            return false;
        }
        HashMap<Integer, Object> fastLookup = new HashMap<Integer, Object>();
        for (Object o : col2) {
            fastLookup.put(DeepEquals.deepHashCode(o), o);
        }
        for (Object o : col1) {
            Object other = fastLookup.get(DeepEquals.deepHashCode(o));
            if (other == null) {
                return false;
            }
            DualKey dk = new DualKey(o, other);
            if (visited.contains(dk)) continue;
            stack.addFirst(dk);
        }
        return true;
    }

    private static boolean compareSortedMap(SortedMap<Object, Object> map1, SortedMap<Object, Object> map2, Deque<DualKey> stack, Set<DualKey> visited) {
        if (map1.size() != map2.size()) {
            return false;
        }
        Iterator<Map.Entry<Object, Object>> i1 = map1.entrySet().iterator();
        Iterator<Map.Entry<Object, Object>> i2 = map2.entrySet().iterator();
        while (i1.hasNext()) {
            Map.Entry<Object, Object> entry1 = i1.next();
            Map.Entry<Object, Object> entry2 = i2.next();
            DualKey dk = new DualKey(entry1.getKey(), entry2.getKey());
            if (!visited.contains(dk)) {
                stack.addFirst(dk);
            }
            if (visited.contains(dk = new DualKey(entry1.getValue(), entry2.getValue()))) continue;
            stack.addFirst(dk);
        }
        return true;
    }

    private static boolean compareUnorderedMap(Map<Object, Object> map1, Map<Object, Object> map2, Deque<DualKey> stack, Set<DualKey> visited) {
        if (map1.size() != map2.size()) {
            return false;
        }
        HashMap<Integer, Map.Entry<Object, Object>> fastLookup = new HashMap<Integer, Map.Entry<Object, Object>>();
        for (Map.Entry<Object, Object> entry : map2.entrySet()) {
            fastLookup.put(DeepEquals.deepHashCode(entry.getKey()), entry);
        }
        for (Map.Entry<Object, Object> entry : map1.entrySet()) {
            Map.Entry other = (Map.Entry)fastLookup.get(DeepEquals.deepHashCode(entry.getKey()));
            if (other == null) {
                return false;
            }
            DualKey dk = new DualKey(entry.getKey(), other.getKey());
            if (!visited.contains(dk)) {
                stack.addFirst(dk);
            }
            if (visited.contains(dk = new DualKey(entry.getValue(), other.getValue()))) continue;
            stack.addFirst(dk);
        }
        return true;
    }

    public static boolean hasCustomEquals(Class<?> c) {
        Class<?> origClass = c;
        if (_customEquals.containsKey(c)) {
            return _customEquals.get(c);
        }
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("equals", Object.class);
                _customEquals.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        _customEquals.put(origClass, false);
        return false;
    }

    public static int deepHashCode(Object obj) {
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(obj);
        int hash = 0;
        while (!stack.isEmpty()) {
            obj = stack.removeFirst();
            if (obj == null || visited.contains(obj)) continue;
            visited.add(obj);
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    stack.addFirst(Array.get(obj, i));
                }
                continue;
            }
            if (obj instanceof Collection) {
                stack.addAll(0, (Collection)obj);
                continue;
            }
            if (obj instanceof Map) {
                stack.addAll(0, ((Map)obj).keySet());
                stack.addAll(0, ((Map)obj).values());
                continue;
            }
            if (DeepEquals.hasCustomHashCode(obj.getClass())) {
                hash += obj.hashCode();
                continue;
            }
            Collection<Field> fields = DeepEquals.getDeepDeclaredFields(obj.getClass());
            for (Field field : fields) {
                try {
                    stack.addFirst(field.get(obj));
                }
                catch (Exception exception) {}
            }
        }
        return hash;
    }

    public static boolean hasCustomHashCode(Class<?> c) {
        Class<?> origClass = c;
        if (_customHash.containsKey(c)) {
            return _customHash.get(c);
        }
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("hashCode", new Class[0]);
                _customHash.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        _customHash.put(origClass, false);
        return false;
    }

    public static Collection<Field> getDeepDeclaredFields(Class<?> c) {
        if (_reflectedFields.containsKey(c)) {
            return _reflectedFields.get(c);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> curr = c; curr != null; curr = curr.getSuperclass()) {
            try {
                Field[] local;
                for (Field field : local = curr.getDeclaredFields()) {
                    int modifiers;
                    if (!field.isAccessible()) {
                        try {
                            field.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (Modifier.isStatic(modifiers = field.getModifiers()) || field.getName().startsWith("this$") || Modifier.isTransient(modifiers)) continue;
                    fields.add(field);
                }
                continue;
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        _reflectedFields.put(c, fields);
        return fields;
    }

    private static class DualKey {
        private final Object _key1;
        private final Object _key2;

        private DualKey(Object k1, Object k2) {
            this._key1 = k1;
            this._key2 = k2;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof DualKey)) {
                return false;
            }
            DualKey that = (DualKey)other;
            return this._key1 == that._key1 && this._key2 == that._key2;
        }

        public int hashCode() {
            int h1 = this._key1 != null ? this._key1.hashCode() : 0;
            int h2 = this._key2 != null ? this._key2.hashCode() : 0;
            return h1 + h2;
        }
    }
}

