/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public final class IOUtils {
    private IOUtils() {
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = IOUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static Class<?> getClassWithAnnotation(Class<?> source, Class<? extends Annotation> annotationClass) {
        for (Class<?> nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
            if (!nextSource.isAnnotationPresent(annotationClass)) continue;
            return nextSource;
        }
        return null;
    }

    public static List<Field> getFieldsWithAnnotation(final Class<?> source, final Class<? extends Annotation> annotationClass) {
        List<Field> declaredAccessableFields = AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                ArrayList<Field> foundFields = new ArrayList<Field>();
                for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                    for (Field field : nextSource.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(annotationClass)) continue;
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        foundFields.add(field);
                    }
                }
                return foundFields;
            }
        });
        return declaredAccessableFields;
    }

    public static boolean isFileAvailableOnClasspath(Class<?> resourceBase, String dataLocation) {
        return resourceBase.getResourceAsStream(dataLocation) != null;
    }

    public static List<InputStream> getAllStreamsFromClasspathBaseResource(Class<?> resourceBase, String[] dataLocations) {
        ArrayList<InputStream> scriptContent = new ArrayList<InputStream>();
        for (int i = 0; i < dataLocations.length; ++i) {
            InputStream content = IOUtils.getStreamFromClasspathBaseResource(resourceBase, dataLocations[i]);
            if (content == null) continue;
            scriptContent.add(content);
        }
        return scriptContent;
    }

    public static InputStream getStreamFromClasspathBaseResource(Class<?> resourceBase, String dataLocation) {
        if (IOUtils.isFileAvailableOnClasspath(resourceBase, dataLocation)) {
            return resourceBase.getResourceAsStream(dataLocation);
        }
        return null;
    }

    public static String readAllStreamFromClasspathBaseResource(Class<?> resourceBase, String dataLocation) throws IOException {
        if (IOUtils.isFileAvailableOnClasspath(resourceBase, dataLocation)) {
            return IOUtils.readFullStream(resourceBase.getResourceAsStream(dataLocation));
        }
        return null;
    }

    public static List<String> readAllStreamsFromClasspathBaseResource(Class<?> resourceBase, String[] dataLocations) throws IOException {
        ArrayList<String> scriptContent = new ArrayList<String>();
        for (int i = 0; i < dataLocations.length; ++i) {
            String content = IOUtils.readAllStreamFromClasspathBaseResource(resourceBase, dataLocations[i]);
            if (content == null) continue;
            scriptContent.add(content);
        }
        return scriptContent;
    }

    public static String readFullStream(InputStream data) throws IOException {
        String readLine;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(data, "UTF-8"));
        StringBuilder readData = new StringBuilder();
        while ((readLine = bufferedReader.readLine()) != null) {
            readData.append(readLine);
        }
        return readData.toString();
    }
}

