/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.core;

import com.lordofthejars.nosqlunit.core.AccessibilityChanger;
import java.lang.reflect.Field;

public class FieldSetter {
    private final Object target;
    private final Field field;

    public FieldSetter(Object target, Field field) {
        this.target = target;
        this.field = field;
    }

    public void set(Object value) {
        AccessibilityChanger changer = new AccessibilityChanger();
        changer.enableAccess(this.field);
        try {
            this.field.set(this.target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access not authorized on field '" + this.field + "' of object '" + this.target + "' with value: '" + value + "'", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Wrong argument on field '" + this.field + "' of object '" + this.target + "' with value: '" + value + "', \n" + "reason : " + e.getMessage(), e);
        }
        changer.safelyDisableAccess(this.field);
    }
}

