/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.core;

import com.lordofthejars.nosqlunit.core.AccessibilityChanger;
import java.lang.reflect.Field;

public class FieldGetter {
    private final Object target;
    private final Field field;

    public FieldGetter(Object target, Field field) {
        this.target = target;
        this.field = field;
    }

    public Object get() {
        AccessibilityChanger changer = new AccessibilityChanger();
        changer.enableAccess(this.field);
        try {
            Object object = this.field.get(this.target);
            return object;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access not authorized on field '" + this.field + "' of object '" + this.target, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Wrong argument on field '" + this.field + "' of object '" + this.target + e.getMessage(), e);
        }
        finally {
            changer.safelyDisableAccess(this.field);
        }
    }
}

