/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.core;

import ch.lambdaj.Lambda;
import com.lordofthejars.nosqlunit.annotation.CustomComparisonStrategy;
import com.lordofthejars.nosqlunit.annotation.CustomInsertionStrategy;
import com.lordofthejars.nosqlunit.annotation.IgnorePropertyValue;
import com.lordofthejars.nosqlunit.annotation.Selective;
import com.lordofthejars.nosqlunit.annotation.SelectiveMatcher;
import com.lordofthejars.nosqlunit.annotation.ShouldMatchDataSet;
import com.lordofthejars.nosqlunit.annotation.UsingDataSet;
import com.lordofthejars.nosqlunit.core.AbstractCustomizableDatabaseOperation;
import com.lordofthejars.nosqlunit.core.ComparisonStrategy;
import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.core.DefaultDataSetLocationResolver;
import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.core.InjectAnnotationProcessor;
import com.lordofthejars.nosqlunit.core.InsertionStrategy;
import com.lordofthejars.nosqlunit.core.LoadStrategyEnum;
import com.lordofthejars.nosqlunit.core.LoadStrategyFactory;
import com.lordofthejars.nosqlunit.core.LoadStrategyOperation;
import com.lordofthejars.nosqlunit.core.ReflectionLoadStrategyFactory;
import com.lordofthejars.nosqlunit.util.DefaultClasspathLocationBuilder;
import com.lordofthejars.nosqlunit.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public abstract class AbstractNoSqlTestRule
implements MethodRule {
    private static final String EXPECTED_RESERVED_WORD = "-expected";
    private Object target;
    private String identifier;
    private DefaultDataSetLocationResolver defaultDataSetLocationResolver;
    private LoadStrategyFactory loadStrategyFactory = new ReflectionLoadStrategyFactory();
    private InjectAnnotationProcessor injectAnnotationProcessor;

    public AbstractNoSqlTestRule(String identifier) {
        this.identifier = identifier;
        this.injectAnnotationProcessor = new InjectAnnotationProcessor(this.identifier);
    }

    public abstract DatabaseOperation getDatabaseOperation();

    public abstract String getWorkingExtension();

    public abstract void close();

    public Statement apply(final Statement base, final FrameworkMethod method, final Object testObject) {
        return new Statement(){

            public void evaluate() throws Throwable {
                AbstractNoSqlTestRule.this.target = testObject;
                AbstractNoSqlTestRule.this.defaultDataSetLocationResolver = new DefaultDataSetLocationResolver(testObject.getClass());
                UsingDataSet usingDataSet = this.getUsingDataSetAnnotation();
                try {
                    if (this.isTestAnnotatedWithDataSet(usingDataSet)) {
                        this.createCustomInsertationStrategyIfPresent();
                        this.loadDataSet(usingDataSet, method);
                    }
                    AbstractNoSqlTestRule.this.injectAnnotationProcessor.processInjectAnnotation(testObject.getClass(), AbstractNoSqlTestRule.this.target, AbstractNoSqlTestRule.this.getDatabaseOperation().connectionManager());
                    base.evaluate();
                    ShouldMatchDataSet shouldMatchDataSet = this.getShouldMatchDataSetAnnotation();
                    if (this.isTestAnnotatedWithExpectedDataSet(shouldMatchDataSet)) {
                        this.createCustomComparisionStrategyIfPresent();
                        this.assertExpectation(shouldMatchDataSet);
                    }
                }
                finally {
                    AbstractNoSqlTestRule.this.close();
                }
            }

            private void createCustomComparisionStrategyIfPresent() {
                CustomComparisonStrategy customComparisonStrategy = this.getCustomComparisionStrategy();
                if (this.isTestAnnotatedWithCustomComparisionStrategy(customComparisonStrategy)) {
                    DatabaseOperation databaseOperation = AbstractNoSqlTestRule.this.getDatabaseOperation();
                    if (this.isDatabaseOperationCustomizable(databaseOperation)) {
                        Class<? extends ComparisonStrategy<?>> comparisionStrategy = customComparisonStrategy.comparisonStrategy();
                        ComparisonStrategy comparisionStrategyObject = (ComparisonStrategy)ReflectionUtil.createInstance(comparisionStrategy);
                        Class<?> classWithAnnotation = IOUtils.getClassWithAnnotation(AbstractNoSqlTestRule.this.target.getClass(), IgnorePropertyValue.class);
                        if (method.getAnnotation(IgnorePropertyValue.class) != null || classWithAnnotation != null && classWithAnnotation.getAnnotation(IgnorePropertyValue.class) != null) {
                            comparisionStrategyObject.setIgnoreProperties(this.getPropertiesToIgnore());
                        }
                        this.overrideComparisionStrategy(databaseOperation, comparisionStrategyObject);
                    } else {
                        throw new IllegalArgumentException("Custom Insertation Strategy can only be used in DatabaseOperations that extends from AbstractCustomizableDatabaseOperation");
                    }
                }
            }

            private void createCustomInsertationStrategyIfPresent() {
                CustomInsertionStrategy customInsertionStrategy = this.getCustomInsertationStrategy();
                if (this.isTestAnnotatedWithCustomInsertationStrategy(customInsertionStrategy)) {
                    DatabaseOperation databaseOperation = AbstractNoSqlTestRule.this.getDatabaseOperation();
                    if (this.isDatabaseOperationCustomizable(databaseOperation)) {
                        Class<? extends InsertionStrategy<?>> insertationStrategy = customInsertionStrategy.insertionStrategy();
                        InsertionStrategy insertationStrategyObject = (InsertionStrategy)ReflectionUtil.createInstance(insertationStrategy);
                        this.overrideInsertationStrategy(databaseOperation, insertationStrategyObject);
                    } else {
                        throw new IllegalArgumentException("Custom Insertation Strategy can only be used in DatabaseOperations that extends from AbstractCustomizableDatabaseOperation");
                    }
                }
            }

            private void overrideComparisionStrategy(DatabaseOperation<?> databaseOperation, ComparisonStrategy<?> comparisionStrategyObject) {
                AbstractCustomizableDatabaseOperation customizableDatabaseOperation = (AbstractCustomizableDatabaseOperation)databaseOperation;
                customizableDatabaseOperation.setComparisonStrategy(comparisionStrategyObject);
            }

            private void overrideInsertationStrategy(DatabaseOperation<?> databaseOperation, InsertionStrategy<?> insertationStrategyObject) {
                AbstractCustomizableDatabaseOperation customizableDatabaseOperation = (AbstractCustomizableDatabaseOperation)databaseOperation;
                customizableDatabaseOperation.setInsertionStrategy(insertationStrategyObject);
            }

            private boolean isDatabaseOperationCustomizable(DatabaseOperation databaseOperation) {
                return databaseOperation instanceof AbstractCustomizableDatabaseOperation;
            }

            private ShouldMatchDataSet getShouldMatchDataSetAnnotation() {
                ShouldMatchDataSet shouldMatchDataSet = (ShouldMatchDataSet)method.getAnnotation(ShouldMatchDataSet.class);
                if (!this.isTestAnnotatedWithExpectedDataSet(shouldMatchDataSet)) {
                    Class<?> testClass = AbstractNoSqlTestRule.this.target.getClass();
                    Class<?> annotatedClass = IOUtils.getClassWithAnnotation(testClass, ShouldMatchDataSet.class);
                    shouldMatchDataSet = annotatedClass == null ? null : annotatedClass.getAnnotation(ShouldMatchDataSet.class);
                }
                return shouldMatchDataSet;
            }

            private String[] getPropertiesToIgnore() {
                IgnorePropertyValue ignorePropertyValue;
                String[] properties;
                IgnorePropertyValue annotationIgnore;
                ArrayList<String> propertyValuesToIgnore = new ArrayList<String>();
                Class<?> annotated = IOUtils.getClassWithAnnotation(AbstractNoSqlTestRule.this.target.getClass(), IgnorePropertyValue.class);
                if (annotated != null && (annotationIgnore = annotated.getAnnotation(IgnorePropertyValue.class)) != null) {
                    for (String property : properties = annotationIgnore.properties()) {
                        propertyValuesToIgnore.add(property);
                    }
                }
                if (this.isTestAnnotatedWithIgnoreProperty(ignorePropertyValue = (IgnorePropertyValue)method.getAnnotation(IgnorePropertyValue.class))) {
                    for (String property : properties = ignorePropertyValue.properties()) {
                        propertyValuesToIgnore.add(property);
                    }
                }
                return propertyValuesToIgnore.toArray(new String[propertyValuesToIgnore.size()]);
            }

            private UsingDataSet getUsingDataSetAnnotation() {
                UsingDataSet usingDataSet = (UsingDataSet)method.getAnnotation(UsingDataSet.class);
                if (!this.isTestAnnotatedWithDataSet(usingDataSet)) {
                    Class<?> testClass = AbstractNoSqlTestRule.this.target.getClass();
                    Class<?> annotatedClass = IOUtils.getClassWithAnnotation(testClass, UsingDataSet.class);
                    usingDataSet = annotatedClass == null ? null : annotatedClass.getAnnotation(UsingDataSet.class);
                }
                return usingDataSet;
            }

            private CustomComparisonStrategy getCustomComparisionStrategy() {
                Class<?> testClass = AbstractNoSqlTestRule.this.target.getClass();
                Class<?> annotatedClass = IOUtils.getClassWithAnnotation(testClass, CustomComparisonStrategy.class);
                return annotatedClass == null ? null : annotatedClass.getAnnotation(CustomComparisonStrategy.class);
            }

            private CustomInsertionStrategy getCustomInsertationStrategy() {
                Class<?> testClass = AbstractNoSqlTestRule.this.target.getClass();
                Class<?> annotatedClass = IOUtils.getClassWithAnnotation(testClass, CustomInsertionStrategy.class);
                return annotatedClass == null ? null : annotatedClass.getAnnotation(CustomInsertionStrategy.class);
            }

            private void assertExpectation(ShouldMatchDataSet shouldMatchDataSet) throws IOException {
                InputStream scriptContent = this.loadExpectedContentScript(method, shouldMatchDataSet);
                if (!this.isNotEmptyStream(scriptContent)) {
                    String suffix = "-expected." + AbstractNoSqlTestRule.this.getWorkingExtension();
                    String defaultClassLocation = DefaultClasspathLocationBuilder.defaultClassAnnotatedClasspathLocation(method);
                    String defaultMethodLocation = DefaultClasspathLocationBuilder.defaultMethodAnnotatedClasspathLocation(method, defaultClassLocation, suffix);
                    throw new IllegalArgumentException("File specified in location or selective matcher property  of ShouldMatchDataSet is not present, or no files matching default location. Valid default locations are: " + defaultClassLocation + suffix + " or " + defaultMethodLocation);
                }
                AbstractNoSqlTestRule.this.getDatabaseOperation().databaseIs(scriptContent);
            }

            private InputStream loadExpectedContentScript(FrameworkMethod method2, ShouldMatchDataSet shouldMatchDataSet) throws IOException {
                SelectiveMatcher[] selectiveMatchers;
                SelectiveMatcher requiredSelectiveMatcher;
                String location = shouldMatchDataSet.location();
                InputStream scriptContent = null;
                scriptContent = this.isNotEmptyString(location) ? this.loadExpectedResultFromLocationAttribute(location) : (this.isSelectiveMatchersDefined(requiredSelectiveMatcher = this.findSelectiveMatcherByConnectionIdentifier(selectiveMatchers = shouldMatchDataSet.withSelectiveMatcher())) ? this.loadExpectedResultFromLocationAttribute(requiredSelectiveMatcher.location()) : this.loadExpectedResultFromDefaultLocation(method2, shouldMatchDataSet));
                return scriptContent;
            }

            private boolean isSelectiveMatchersDefined(SelectiveMatcher requiredSelectiveMatcher) {
                return requiredSelectiveMatcher != null;
            }

            private SelectiveMatcher findSelectiveMatcherByConnectionIdentifier(SelectiveMatcher[] selectiveMatchers) {
                return (SelectiveMatcher)Lambda.selectFirst((Object)selectiveMatchers, (Matcher)Lambda.having((Object)((SelectiveMatcher)Lambda.on(SelectiveMatcher.class)).identifier(), (Matcher)CoreMatchers.equalTo((Object)AbstractNoSqlTestRule.this.identifier)).and((Matcher)Lambda.having((Object)((SelectiveMatcher)Lambda.on(SelectiveMatcher.class)).location(), (Matcher)CoreMatchers.notNullValue())));
            }

            private InputStream loadExpectedResultFromDefaultLocation(FrameworkMethod method2, ShouldMatchDataSet shouldMatchDataSet) throws IOException {
                InputStream scriptContent = null;
                String defaultLocation = AbstractNoSqlTestRule.this.defaultDataSetLocationResolver.resolveDefaultDataSetLocation(shouldMatchDataSet, method2, "-expected." + AbstractNoSqlTestRule.this.getWorkingExtension());
                if (defaultLocation != null) {
                    scriptContent = this.loadExpectedResultFromLocationAttribute(defaultLocation);
                }
                return scriptContent;
            }

            private InputStream loadExpectedResultFromLocationAttribute(String location) throws IOException {
                InputStream scriptContent = IOUtils.getStreamFromClasspathBaseResource(AbstractNoSqlTestRule.this.defaultDataSetLocationResolver.getResourceBase(), location);
                return scriptContent;
            }

            private void loadDataSet(UsingDataSet usingDataSet, FrameworkMethod method2) throws IOException {
                List<InputStream> scriptContent = this.loadDatasets(usingDataSet, method2);
                LoadStrategyEnum loadStrategyEnum = usingDataSet.loadStrategy();
                if (this.areDatasetsRequired(loadStrategyEnum) && this.emptyDataset(scriptContent) && this.notSelectiveAnnotation(usingDataSet.withSelectiveLocations())) {
                    String suffix = "." + AbstractNoSqlTestRule.this.getWorkingExtension();
                    String defaultClassLocation = DefaultClasspathLocationBuilder.defaultClassAnnotatedClasspathLocation(method2);
                    String defaultMethodLocation = DefaultClasspathLocationBuilder.defaultMethodAnnotatedClasspathLocation(method2, defaultClassLocation, suffix);
                    throw new IllegalArgumentException("File specified in locations property are not present in classpath, or no files matching default name are found. Valid default locations are: " + defaultClassLocation + suffix + " or " + defaultMethodLocation);
                }
                LoadStrategyOperation loadStrategyOperation = AbstractNoSqlTestRule.this.loadStrategyFactory.getLoadStrategyInstance(loadStrategyEnum, AbstractNoSqlTestRule.this.getDatabaseOperation());
                loadStrategyOperation.executeScripts(scriptContent.toArray(new InputStream[scriptContent.size()]));
            }

            private boolean notSelectiveAnnotation(Selective[] withSelectiveLocations) {
                return withSelectiveLocations.length == 0;
            }

            private boolean emptyDataset(List<InputStream> scriptContent) {
                return scriptContent.size() == 0;
            }

            private boolean areDatasetsRequired(LoadStrategyEnum loadStrategyEnum) {
                return LoadStrategyEnum.DELETE_ALL != loadStrategyEnum;
            }

            private List<InputStream> loadDatasets(UsingDataSet usingDataSet, FrameworkMethod method2) throws IOException {
                String[] locations = usingDataSet.locations();
                ArrayList<InputStream> scriptContent = new ArrayList<InputStream>();
                scriptContent.addAll(this.loadGlobalDataSets(usingDataSet, method2, locations));
                scriptContent.addAll(this.loadSelectiveDataSets(usingDataSet));
                return scriptContent;
            }

            private List<InputStream> loadSelectiveDataSets(UsingDataSet usingDataSet) throws IOException {
                Selective[] selectiveLocations;
                ArrayList<InputStream> scriptContent = new ArrayList<InputStream>();
                if (this.isSelectiveLocationsAttributeSpecified(usingDataSet) && (selectiveLocations = usingDataSet.withSelectiveLocations()) != null && selectiveLocations.length > 0) {
                    for (Selective selective : selectiveLocations) {
                        if (!AbstractNoSqlTestRule.this.identifier.equals(selective.identifier().trim()) || !this.isLocationsAttributeSpecified(selective.locations())) continue;
                        scriptContent.addAll(IOUtils.getAllStreamsFromClasspathBaseResource(AbstractNoSqlTestRule.this.defaultDataSetLocationResolver.getResourceBase(), selective.locations()));
                    }
                }
                return scriptContent;
            }

            private List<InputStream> loadGlobalDataSets(UsingDataSet usingDataSet, FrameworkMethod method2, String[] locations) throws IOException {
                ArrayList<InputStream> scriptContent = new ArrayList<InputStream>();
                if (this.isLocationsAttributeSpecified(locations)) {
                    scriptContent.addAll(IOUtils.getAllStreamsFromClasspathBaseResource(AbstractNoSqlTestRule.this.defaultDataSetLocationResolver.getResourceBase(), locations));
                } else {
                    String location = AbstractNoSqlTestRule.this.defaultDataSetLocationResolver.resolveDefaultDataSetLocation(usingDataSet, method2, "." + AbstractNoSqlTestRule.this.getWorkingExtension());
                    if (location != null) {
                        scriptContent.add(IOUtils.getStreamFromClasspathBaseResource(AbstractNoSqlTestRule.this.defaultDataSetLocationResolver.getResourceBase(), location));
                    }
                }
                return scriptContent;
            }

            private boolean isSelectiveLocationsAttributeSpecified(UsingDataSet usingDataSet) {
                Selective[] selectiveLocations = usingDataSet.withSelectiveLocations();
                if (selectiveLocations != null && selectiveLocations.length > 0) {
                    for (Selective selective : selectiveLocations) {
                        if (!AbstractNoSqlTestRule.this.identifier.equals(selective.identifier().trim()) || !this.isLocationsAttributeSpecified(selective.locations())) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean isNotEmptyStream(InputStream inputStream) {
                return inputStream != null;
            }

            private boolean isNotEmptyString(String location) {
                return location != null && !"".equals(location.trim());
            }

            private boolean isLocationsAttributeSpecified(String[] locations) {
                return locations != null && locations.length > 0;
            }

            private boolean isTestAnnotatedWithCustomComparisionStrategy(CustomComparisonStrategy customComparisonStrategy) {
                return customComparisonStrategy != null;
            }

            private boolean isTestAnnotatedWithCustomInsertationStrategy(CustomInsertionStrategy customInsertionStrategy) {
                return customInsertionStrategy != null;
            }

            private boolean isTestAnnotatedWithExpectedDataSet(ShouldMatchDataSet shouldMatchDataSet) {
                return shouldMatchDataSet != null;
            }

            private boolean isTestAnnotatedWithDataSet(UsingDataSet usingDataSet) {
                return usingDataSet != null;
            }

            private boolean isTestAnnotatedWithIgnoreProperty(IgnorePropertyValue ignorePropertyValue) {
                return ignorePropertyValue != null;
            }
        };
    }

    public void setLoadStrategyFactory(LoadStrategyFactory loadStrategyFactory) {
        this.loadStrategyFactory = loadStrategyFactory;
    }

    public void setInjectAnnotationProcessor(InjectAnnotationProcessor injectAnnotationProcessor) {
        this.injectAnnotationProcessor = injectAnnotationProcessor;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    protected void setTarget(Object target) {
        this.target = target;
    }
}

