/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.core;

import com.lordofthejars.nosqlunit.core.ConnectionManagement;
import com.lordofthejars.nosqlunit.core.LifecycleManager;

public abstract class AbstractLifecycleManager
implements LifecycleManager {
    private boolean ready = false;

    @Override
    public void startEngine() throws Throwable {
        if (this.isServerNotStartedYet()) {
            this.ready = true;
            this.doStart();
        }
        ConnectionManagement.getInstance().addConnection(this.getHost(), this.getPort());
    }

    @Override
    public void stopEngine() {
        int remainingConnections = ConnectionManagement.getInstance().removeConnection(this.getHost(), this.getPort());
        if (this.noMoreConnectionsToManage(remainingConnections)) {
            this.ready = false;
            this.doStop();
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    private boolean noMoreConnectionsToManage(int remainingConnections) {
        return remainingConnections < 1;
    }

    private boolean isServerNotStartedYet() {
        return !ConnectionManagement.getInstance().isConnectionRegistered(this.getHost(), this.getPort());
    }

    public abstract String getHost();

    public abstract int getPort();

    public abstract void doStart() throws Throwable;

    public abstract void doStop();
}

