/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.debugging;

import android.content.Context;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import com.loopme.common.Logging;
import com.loopme.common.Utils;
import com.loopme.debugging.HttpUtils;
import com.loopme.debugging.LogDbHelper;
import com.loopme.request.AdRequestParametersProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LiveDebug {
    private static final String LOG_TAG = LiveDebug.class.getSimpleName();
    private static final int DEBUG_TIME = 300000;
    private static LogDbHelper sLogDbHelper;
    private static ExecutorService sExecutor;
    private static CountDownTimer sDebugTimer;
    private static boolean sIsDebugOn;

    public static void init(Context context) {
        sLogDbHelper = new LogDbHelper(context);
    }

    public static void setLiveDebug(boolean debug) {
        Logging.out(LOG_TAG, "setLiveDebug " + debug);
        if (sIsDebugOn != debug && debug) {
            sIsDebugOn = debug;
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    LiveDebug.startTimer();
                }
            });
        }
    }

    public static void handle(String logTag, String text) {
        if (sIsDebugOn) {
            LiveDebug.saveLog(logTag, text);
        }
    }

    private static void startTimer() {
        if (sDebugTimer == null) {
            sDebugTimer = new CountDownTimer(300000L, 1000L){

                public void onTick(long millisUntilFinished) {
                }

                public void onFinish() {
                    LiveDebug.sendToServer();
                    sIsDebugOn = false;
                    sDebugTimer = null;
                }
            };
            Logging.out(LOG_TAG, "start debug timer");
            sDebugTimer.start();
        }
    }

    private static void sendToServer() {
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                if (sLogDbHelper != null) {
                    Logging.out(LOG_TAG, "send to server");
                    Map params = LiveDebug.initPostDataParams();
                    HttpUtils.postDataToServer(params);
                }
            }
        });
    }

    private static Map<String, String> initPostDataParams() {
        String debugLogs = LiveDebug.initLogsString();
        AdRequestParametersProvider provider = AdRequestParametersProvider.getInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("device_os", "android");
        params.put("sdk_type", "loopme");
        params.put("sdk_version", "5.2");
        params.put("device_id", provider.getViewerToken());
        params.put("package", provider.getPackage());
        params.put("app_key", provider.getAppKey());
        params.put("msg", "sdk_debug");
        params.put("debug_logs", debugLogs);
        params.put("app_ids", LiveDebug.encryptString(Utils.getPackageInstalledAsString(provider.getPackagesInstalled())));
        return params;
    }

    private static String encryptString(String installedAsString) {
        return Utils.getEncryptedString(installedAsString);
    }

    private static String initLogsString() {
        if (sLogDbHelper != null) {
            List<String> loglist = sLogDbHelper.getLogs();
            sLogDbHelper.clear();
            StringBuilder sb = new StringBuilder();
            for (String s2 : loglist) {
                sb.append(s2);
                sb.append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    private static void saveLog(String logTag, String text) {
        final String logString = LiveDebug.formatLogMessage(logTag, text);
        if (sLogDbHelper != null) {
            sExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    sLogDbHelper.putLog(logString);
                }
            });
        }
    }

    private static String formatLogMessage(String logTag, String text) {
        String thread = Looper.getMainLooper() == Looper.myLooper() ? "ui" : "bg";
        StringBuilder sb = new StringBuilder().append(thread).append(": ").append(logTag).append(": ").append(text);
        return sb.toString();
    }

    static {
        sExecutor = Executors.newSingleThreadExecutor();
    }
}

