/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.loopme.AdController;
import com.loopme.BaseAd;
import com.loopme.IViewController;
import com.loopme.LoopMeAdHolder;
import com.loopme.LoopMeBannerView;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.MinimizedMode;
import com.loopme.common.Utils;
import com.loopme.debugging.ErrorLog;
import com.loopme.debugging.LiveDebug;

public class LoopMeBannerGeneral
extends BaseAd {
    private static final String LOG_TAG = LoopMeBannerGeneral.class.getSimpleName();
    public static final String TEST_MPU_BANNER = "test_mpu";
    private Listener mAdListener;
    private volatile LoopMeBannerView mBannerView;
    private boolean mIsVideoFinished;

    LoopMeBannerGeneral(Activity activity, String appKey) {
        super(activity, appKey);
        this.mAdController = new AdController(this);
        Utils.init((Context)activity);
        LiveDebug.init((Context)activity);
        Logging.out(LOG_TAG, "Start creating banner with app key: " + appKey);
    }

    public static LoopMeBannerGeneral getInstance(String appKey, Activity activity) {
        return LoopMeAdHolder.createBanner(appKey, activity);
    }

    private void ensureAdIsVisible() {
        if (this.mAdController != null) {
            this.mAdController.ensureAdIsVisible((View)this.mBannerView);
        }
    }

    @Override
    public void destroy() {
        this.mAdListener = null;
        if (this.mAdController != null) {
            this.mAdController.destroyMinimizedView();
            if (this.mAdController.getViewController() != null) {
                this.mAdController.getViewController().onPause();
                this.mAdController.getViewController().onDestroy();
            }
        }
        super.destroy();
    }

    protected void destroyBannerView() {
        if (this.mBannerView != null) {
            this.mBannerView.setVisibility(8);
            this.mBannerView.removeAllViews();
            this.mBannerView = null;
        }
    }

    public void bindView(LoopMeBannerView viewGroup) {
        if (viewGroup != null) {
            String visibility = Utils.getViewVisibility((View)viewGroup);
            Logging.out(LOG_TAG, "Bind view (" + visibility + ")");
            this.mBannerView = viewGroup;
        }
    }

    public void setMinimizedMode(MinimizedMode mode) {
        if (this.mAdController != null && mode != null) {
            Logging.out(LOG_TAG, "Set minimized mode");
            this.mAdController.setMinimizedMode(mode);
        }
    }

    public LoopMeBannerView getBannerView() {
        return this.mBannerView;
    }

    public boolean isViewBinded() {
        return this.mBannerView != null;
    }

    public void pause() {
        if (this.mAdController != null) {
            if (this.mAdController.getViewController() != null) {
                this.mAdController.getViewController().onPause();
            }
            if (this.mAdController.getCurrentDisplayMode() == 102) {
                return;
            }
            if (this.mAdController.getCurrentVideoState() == 2) {
                Logging.out(LOG_TAG, "pause Ad");
                this.mAdController.setWebViewState(2);
            }
        }
    }

    public void setListener(Listener listener) {
        this.mAdListener = listener;
    }

    public Listener getListener() {
        return this.mAdListener;
    }

    public void removeListener() {
        this.mAdListener = null;
    }

    void showNativeVideo() {
        if (this.mAdState == 202) {
            return;
        }
        if (this.isReady() && this.mBannerView != null) {
            Logging.out(LOG_TAG, "Banner did start showing ad (native)");
            this.mAdState = 202;
            this.stopExpirationTimer();
            this.mAdController.buildVideoAdView((ViewGroup)this.mBannerView);
            if (this.getAdParams().isVideo360()) {
                IViewController v360 = this.mAdController.getViewController();
                v360.initVRLibrary(this.getContext());
                v360.onResume();
            }
            if (this.mBannerView.getVisibility() != 0) {
                this.mBannerView.setVisibility(0);
            }
            this.onLoopMeBannerShow();
        } else {
            ErrorLog.post("Banner is not ready");
        }
    }

    public void show() {
        Logging.out(LOG_TAG, "Banner did start showing ad");
        if (this.mAdState == 202) {
            Logging.out(LOG_TAG, "Banner already displays on screen");
            return;
        }
        if (this.isReady() && this.mBannerView != null) {
            this.mAdState = 202;
            this.stopExpirationTimer();
            if (this.getAdParams().isMraid()) {
                this.mAdController.buildMraidContainer((ViewGroup)this.mBannerView);
                this.mAdController.getMraidView().setIsViewable(true);
                this.mAdController.getMraidView().notifyStateChange();
            } else {
                if (this.isVideoPresented()) {
                    this.mAdController.buildVideoAdView((ViewGroup)this.mBannerView);
                } else {
                    this.mAdController.buildStaticAdView((ViewGroup)this.mBannerView);
                    this.mAdController.getAdView().setVideoState(2);
                }
                if (this.getAdParams().isVideo360()) {
                    IViewController v360 = this.mAdController.getViewController();
                    v360.initVRLibrary(this.getContext());
                    v360.onResume();
                }
            }
            if (this.mBannerView.getVisibility() != 0) {
                this.mBannerView.setVisibility(0);
            }
            final ViewTreeObserver observer = this.mBannerView.getViewTreeObserver();
            ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    Logging.out(LOG_TAG, "onGlobalLayout");
                    if (LoopMeBannerGeneral.this.mAdController != null && LoopMeBannerGeneral.this.mAdController.getCurrentDisplayMode() != 102) {
                        LoopMeBannerGeneral.this.ensureAdIsVisible();
                    }
                    if (observer.isAlive()) {
                        if (Build.VERSION.SDK_INT >= 16) {
                            observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                }
            };
            observer.addOnGlobalLayoutListener(layoutListener);
            this.onLoopMeBannerShow();
        } else {
            ErrorLog.post("Banner is not ready");
        }
    }

    private boolean isVideoPresented() {
        return this.mAdController.isVideoPresented();
    }

    public void resume() {
        Logging.out(LOG_TAG, "resume");
        if (this.mAdController != null && this.isReady()) {
            this.ensureAdIsVisible();
            if (this.mAdController.getViewController() != null) {
                this.mAdController.getViewController().onResume();
            }
            this.mAdController.setWebViewState(1);
        }
    }

    @Override
    public AdController getAdController() {
        return this.mAdController;
    }

    void switchToMinimizedMode() {
        if (this.mAdState == 202 && this.mAdController != null && !this.mIsVideoFinished) {
            if (this.mAdController.isBackFromExpand()) {
                return;
            }
            if (this.mAdController.isMinimizedModeEnable()) {
                this.mAdController.switchToMinimizedMode();
            } else {
                this.pause();
            }
        }
    }

    void playbackFinishedWithError() {
        this.mIsVideoFinished = true;
    }

    void switchToNormalMode() {
        if (this.mAdState == 202 && this.mAdController != null) {
            this.mAdController.switchToNormalMode();
        }
    }

    @Override
    public void dismiss() {
        Logging.out(LOG_TAG, "Banner will be dismissed");
        if (this.mAdState == 202) {
            if (this.mBannerView != null) {
                this.mBannerView.setVisibility(8);
                this.mBannerView.removeAllViews();
            }
            if (this.mAdController != null) {
                this.mAdController.destroyMinimizedView();
                this.mAdController.setWebViewState(3);
                if (this.mAdController.getViewController() != null) {
                    this.mAdController.getViewController().onPause();
                }
            }
            this.onLoopMeBannerHide();
            Logging.logEvent("Ad closed.");
        } else {
            Logging.out(LOG_TAG, "Can't dismiss ad, it's not displaying");
        }
    }

    @Override
    public int getAdFormat() {
        return 1000;
    }

    void onLoopMeBannerLoadFail(LoopMeError error) {
        Logging.out(LOG_TAG, "Ad fails to load: " + error.getMessage());
        this.mAdState = 200;
        this.mIsReady = false;
        this.stopFetcherTimer();
        if (this.mAdController != null) {
            this.mAdController.resetFullScreenCommandCounter();
        }
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeBannerLoadFail(this, error);
            Logging.logEvent(this.getAppKey(), "Ad failed to load. " + error.getMessage());
        } else {
            Logging.out(LOG_TAG, "Warning: empty listener");
        }
    }

    void onLoopMeBannerSuccessLoad() {
        long currentTime = System.currentTimeMillis();
        long loadingTime = currentTime - this.mAdLoadingTimer;
        Logging.out(LOG_TAG, "Ad successfully loaded (" + loadingTime + "ms)");
        this.mIsReady = true;
        this.mAdState = 200;
        this.stopFetcherTimer();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeBannerLoadSuccess(this);
            Logging.logEvent(this.getAppKey(), "Ad loaded successfully.");
        } else {
            Logging.out(LOG_TAG, "Warning: empty listener");
        }
    }

    void onLoopMeBannerShow() {
        Logging.out(LOG_TAG, "Ad appeared on screen");
        this.mIsVideoFinished = false;
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeBannerShow(this);
            Logging.logEvent("Ad appeared on the screen.");
        }
    }

    void onLoopMeBannerHide() {
        Logging.out(LOG_TAG, "Ad disappeared from screen");
        this.mIsReady = false;
        this.mAdState = 200;
        if (this.mAdController != null) {
            this.mAdController.resetFullScreenCommandCounter();
        }
        this.releaseViewController();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeBannerHide(this);
        }
    }

    void onLoopMeBannerClicked() {
        Logging.out(LOG_TAG, "Ad received click event");
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeBannerClicked(this);
            Logging.logEvent("User interacts with Ad.");
        }
    }

    void onLoopMeBannerLeaveApp() {
        Logging.out(LOG_TAG, "Leaving application");
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeBannerLeaveApp(this);
        }
    }

    void onLoopMeBannerVideoDidReachEnd() {
        Logging.out(LOG_TAG, "Video did reach end");
        this.mIsVideoFinished = true;
        this.mIsReady = false;
        this.mAdState = 200;
        if (this.mAdController != null) {
            this.mAdController.resetFullScreenCommandCounter();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (LoopMeBannerGeneral.this.mAdController != null) {
                    LoopMeBannerGeneral.this.mAdController.switchToNormalMode();
                }
            }
        };
        Handler handler = new Handler(Looper.getMainLooper());
        if (this.mAdController.getCurrentDisplayMode() == 101) {
            handler.postDelayed(runnable, 1000L);
        }
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeBannerVideoDidReachEnd(this);
        }
    }

    void onLoopMeBannerExpired() {
        Logging.out(LOG_TAG, "Ad content is expired");
        this.mExpirationTimer = null;
        this.mIsReady = false;
        this.mAdState = 200;
        this.releaseViewController();
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeBannerExpired(this);
        }
    }

    @Override
    void onAdExpired() {
        this.onLoopMeBannerExpired();
    }

    @Override
    void onAdLoadSuccess() {
        this.onLoopMeBannerSuccessLoad();
    }

    @Override
    void onAdLoadFail(final LoopMeError error) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                LoopMeBannerGeneral.this.onLoopMeBannerLoadFail(error);
            }
        });
    }

    @Override
    void onAdLeaveApp() {
        this.onLoopMeBannerLeaveApp();
    }

    @Override
    void onAdClicked() {
        this.onLoopMeBannerClicked();
    }

    @Override
    void onAdVideoDidReachEnd() {
        this.onLoopMeBannerVideoDidReachEnd();
    }

    @Override
    int detectWidth() {
        if (this.mBannerView == null) {
            return 0;
        }
        ViewGroup.LayoutParams params = this.mBannerView.getLayoutParams();
        return params.width;
    }

    @Override
    int detectHeight() {
        if (this.mBannerView == null) {
            return 0;
        }
        ViewGroup.LayoutParams params = this.mBannerView.getLayoutParams();
        return params.height;
    }

    public static interface Listener {
        public void onLoopMeBannerLoadSuccess(LoopMeBannerGeneral var1);

        public void onLoopMeBannerLoadFail(LoopMeBannerGeneral var1, LoopMeError var2);

        public void onLoopMeBannerShow(LoopMeBannerGeneral var1);

        public void onLoopMeBannerHide(LoopMeBannerGeneral var1);

        public void onLoopMeBannerClicked(LoopMeBannerGeneral var1);

        public void onLoopMeBannerLeaveApp(LoopMeBannerGeneral var1);

        public void onLoopMeBannerVideoDidReachEnd(LoopMeBannerGeneral var1);

        public void onLoopMeBannerExpired(LoopMeBannerGeneral var1);
    }
}

